/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.NotificationBackConnector;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;

abstract class GenericHttpNotificationForwarder
extends GenericHttpConnectorClient
implements NotificationBackConnector {
    private static final int BUFFER_SIZE = 256;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm", "GenericHttpNotificationForwarder");
    private transient boolean connected = false;

    public GenericHttpNotificationForwarder(GenericHttpConnectorAddress address) {
        this.httpConnAddr = address;
        this.factory = this.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sendHttp(Object[] al) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        int len = al.length;
        for (int i = 0; i < len; ++i) {
            objOut.writeObject(al[i]);
        }
        byte[] request_content = out.toByteArray();
        Socket socket = null;
        ByteArrayOutputStream response_content = null;
        try {
            int byte_count;
            socket = this.factory.createSocket(this.httpConnAddr.getHost(), this.httpConnAddr.getPort(), this);
            OutputStream outputStream = socket.getOutputStream();
            if (request_content.length != 0) {
                outputStream.write(request_content);
            }
            outputStream.flush();
            InputStream inputStream = socket.getInputStream();
            byte[] buffer = new byte[256];
            response_content = new ByteArrayOutputStream(256);
            while ((byte_count = inputStream.read(buffer, 0, 256)) != -1) {
                response_content.write(buffer, 0, byte_count);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                }
                finally {
                    socket = null;
                }
            }
        }
        return response_content.toByteArray();
    }

    public String connect() {
        if (logger.finerOn()) {
            logger.finer("connect", "connect");
        }
        this.connected = true;
        return null;
    }

    public void disconnect() {
        if (logger.finerOn()) {
            logger.finer("disconnect", "disconnect");
        }
        if (this.connected) {
            this.httpConnAddr = null;
            this.connected = false;
        }
    }

    public Object[] remoteRequest(int opType, Object[] params) throws Exception {
        if (logger.finerOn()) {
            logger.finer("remoteRequest", "remoteRequest");
        }
        if (!this.connected) {
            throw new CommunicationException("NotificationForwarder not connected");
        }
        Object[] aList = new Object[]{"remoteRequest", new Integer(opType), params};
        try {
            byte[] responseEntityBody = this.sendHttp(aList);
            if (responseEntityBody.length == 0) {
                throw new IllegalAccessException("Entity Body in HTTP Response is empty");
            }
            Object result = this.readObjectValue(responseEntityBody);
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            return (Object[])result;
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (ListenerNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            if (logger.finestOn()) {
                logger.finest("remoteRequest", "Cannot get ObjectInputStream");
            }
            throw new CommunicationException(e);
        }
        catch (Exception e) {
            if (logger.finestOn()) {
                logger.finest("remoteRequest", "Unexpected exception");
            }
            throw new CommunicationException(e);
        }
    }

    private Object readObjectValue(byte[] entityBody) throws IOException, ClassNotFoundException {
        if (entityBody == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(entityBody);
        ObjectInputStream objIn = new ObjectInputStream(bIn);
        String typeStr = (String)objIn.readObject();
        if (logger.finestOn()) {
            logger.finest("readObjectValue", "Received object of type " + typeStr);
        }
        return objIn.readObject();
    }
}

