/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.IPAcl.AclEntryImpl;
import com.sun.management.snmp.IPAcl.AclImpl;
import com.sun.management.snmp.IPAcl.JDMAccess;
import com.sun.management.snmp.IPAcl.JDMAclItem;
import com.sun.management.snmp.IPAcl.JDMCommunities;
import com.sun.management.snmp.IPAcl.JDMHost;
import com.sun.management.snmp.IPAcl.JDMHostInform;
import com.sun.management.snmp.IPAcl.JDMHostTrap;
import com.sun.management.snmp.IPAcl.JDMInformCommunity;
import com.sun.management.snmp.IPAcl.JDMInformInterestedHost;
import com.sun.management.snmp.IPAcl.JDMInformItem;
import com.sun.management.snmp.IPAcl.JDMManagers;
import com.sun.management.snmp.IPAcl.JDMTrapCommunity;
import com.sun.management.snmp.IPAcl.JDMTrapInterestedHost;
import com.sun.management.snmp.IPAcl.JDMTrapItem;
import com.sun.management.snmp.IPAcl.Parser;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import com.sun.management.snmp.IPAcl.SimpleNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.util.Hashtable;
import java.util.Vector;

abstract class Host
extends SimpleNode
implements Serializable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "Host");
    String dbgTag = "Host";

    public Host(int id) {
        super(id);
    }

    public Host(Parser p, int id) {
        super(p, id);
    }

    protected abstract PrincipalImpl createAssociatedPrincipal() throws UnknownHostException;

    protected abstract String getHname();

    public void buildAclEntries(PrincipalImpl owner, AclImpl acl) {
        PrincipalImpl p = null;
        try {
            p = this.createAssociatedPrincipal();
        }
        catch (UnknownHostException e) {
            if (logger.finestOn()) {
                logger.finest("buildAclEntries", "Cannot create ACL entry for " + e.getMessage());
            }
            throw new IllegalArgumentException("Cannot create ACL entry for " + e.getMessage());
        }
        AclEntryImpl entry = null;
        try {
            entry = new AclEntryImpl(p);
            this.registerPermission(entry);
            acl.addEntry(owner, entry);
        }
        catch (UnknownHostException e) {
            if (logger.finestOn()) {
                logger.finest("buildAclEntries", "Cannot create ACL entry for " + e.getMessage());
            }
            return;
        }
        catch (NotOwnerException a) {
            if (logger.finestOn()) {
                logger.finest("buildAclEntries", "Not owner of ACL " + a.getMessage());
            }
            return;
        }
    }

    private void registerPermission(AclEntryImpl entry) {
        JDMHost host = (JDMHost)this.jjtGetParent();
        JDMManagers manager = (JDMManagers)host.jjtGetParent();
        JDMAclItem acl = (JDMAclItem)manager.jjtGetParent();
        JDMAccess access = acl.getAccess();
        access.putPermission(entry);
        JDMCommunities comm = acl.getCommunities();
        comm.buildCommunities(entry);
    }

    public void buildTrapEntries(Hashtable dest) {
        JDMHostTrap host = (JDMHostTrap)this.jjtGetParent();
        JDMTrapInterestedHost hosts = (JDMTrapInterestedHost)host.jjtGetParent();
        JDMTrapItem trap = (JDMTrapItem)hosts.jjtGetParent();
        JDMTrapCommunity community = trap.getCommunity();
        String comm = community.getCommunity();
        InetAddress add = null;
        try {
            add = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException e) {
            if (logger.finestOn()) {
                logger.finest("buildTrapEntries", "Cannot create TRAP entry for " + e.getMessage());
            }
            return;
        }
        Vector list = null;
        if (dest.containsKey(add)) {
            list = (Vector)dest.get(add);
            if (!list.contains(comm)) {
                list.addElement(comm);
            }
        } else {
            list = new Vector();
            list.addElement(comm);
            dest.put(add, list);
        }
    }

    public void buildInformEntries(Hashtable dest) {
        JDMHostInform host = (JDMHostInform)this.jjtGetParent();
        JDMInformInterestedHost hosts = (JDMInformInterestedHost)host.jjtGetParent();
        JDMInformItem inform = (JDMInformItem)hosts.jjtGetParent();
        JDMInformCommunity community = inform.getCommunity();
        String comm = community.getCommunity();
        InetAddress add = null;
        try {
            add = InetAddress.getByName(this.getHname());
        }
        catch (UnknownHostException e) {
            if (logger.finestOn()) {
                logger.finest("buildInformEntries", "Cannot create INFORM entry for " + e.getMessage());
            }
            return;
        }
        Vector list = null;
        if (dest.containsKey(add)) {
            list = (Vector)dest.get(add);
            if (!list.contains(comm)) {
                list.addElement(comm);
            }
        } else {
            list = new Vector();
            list.addElement(comm);
            dest.put(add, list);
        }
    }
}

