/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.mpm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.mpm.SnmpMsgTranslator;
import java.net.InetAddress;

class SnmpIncomingResponseImpl
implements SnmpIncomingResponse {
    SnmpMsg resp = null;
    SnmpSecuritySubSystem secureSubSys = null;
    SnmpMsgTranslator translator = null;
    SnmpSecurityParameters params = null;
    SnmpSecurityCache cache = null;
    SnmpPduFactory factory = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpIncomingResponseImpl");
    String dbgTag = "SnmpIncomingResponseImpl";

    public SnmpIncomingResponseImpl(SnmpSecuritySubSystem secureSubSys, SnmpPduFactory factory, SnmpMsg resp, SnmpMsgTranslator translator) {
        this.secureSubSys = secureSubSys;
        this.resp = resp;
        this.translator = translator;
        this.factory = factory;
    }

    public InetAddress getAddress() {
        return this.resp.address;
    }

    public int getPort() {
        return this.resp.port;
    }

    public void setSecurityCache(SnmpSecurityCache cache) {
        this.cache = cache;
    }

    public int getSecurityLevel() {
        return this.translator.getSecurityLevel(this.resp);
    }

    public int getSecurityModel() {
        return this.translator.getMsgSecurityModel(this.resp);
    }

    public byte[] getContextName() {
        return this.translator.getContextName(this.resp);
    }

    public SnmpSecurityParameters getSecurityParameters() {
        return this.params;
    }

    public int getRequestId(byte[] data) throws SnmpStatusException {
        return this.resp.getRequestId(data);
    }

    public SnmpMsg decodeMessage(byte[] inputBytes, int byteCount, InetAddress address, int port) throws SnmpStatusException, SnmpSecurityException {
        this.resp.address = address;
        this.resp.port = port;
        this.resp.decodeMessage(inputBytes, byteCount);
        SnmpDecryptedPdu decrPdu = new SnmpDecryptedPdu();
        try {
            this.params = this.secureSubSys.processIncomingResponse(this.cache, this.resp.version, this.translator.getMsgId(this.resp), this.translator.getMsgMaxSize(this.resp), this.translator.getMsgFlags(this.resp), this.translator.getMsgSecurityModel(this.resp), this.translator.getFlatSecurityParameters(this.resp), this.translator.getContextEngineId(this.resp), this.translator.getContextName(this.resp), this.resp.data, this.translator.getEncryptedPdu(this.resp), decrPdu);
            this.secureSubSys.releaseSecurityCache(this.translator.getMsgSecurityModel(this.resp), this.cache);
        }
        catch (SnmpUnknownSecModelException x) {
            if (logger.finestOn()) {
                logger.finest("decodeMessage", x.toString() + "\n Will fail in timeout!!!");
            }
            return null;
        }
        if (decrPdu.data != null) {
            this.resp.data = decrPdu.data;
            this.translator.setContextName(this.resp, decrPdu.contextName);
            this.translator.setContextEngineId(this.resp, decrPdu.contextEngineId);
        }
        return this.resp;
    }

    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        return this.factory.decodeSnmpPdu(this.resp);
    }

    public String printMessage() {
        return this.resp.printMessage();
    }
}

