/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpModelImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmAuthModule;
import com.sun.management.snmp.usm.SnmpUsmEngineIdException;
import com.sun.management.snmp.usm.SnmpUsmEnginePeer;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmExceptionGenerator;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmPrivAlgorithmException;
import com.sun.management.snmp.usm.SnmpUsmPrivModule;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.SnmpUsmSecurityCache;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.SnmpUsmSecurityParametersImpl;
import com.sun.management.snmp.usm.SnmpUsmTimelinessModule;
import com.sun.management.snmp.usm.SnmpUsmUserNameException;
import java.util.Hashtable;

public class SnmpUserSecurityModel
extends SnmpModelImpl
implements SnmpUsm {
    private Hashtable peers = new Hashtable();
    private SnmpUsmLcd lcd = null;
    private SnmpUsmExceptionGenerator genExp = null;
    private SnmpUsmTimelinessModule timeModule = null;
    private SnmpUsmAuthModule authModule = null;
    private SnmpUsmPrivModule privModule = null;
    private static int unsupportedSecLevelsCounter = 0;
    private static int notInTimeWindowsCounter = 0;
    private static int unknownUserNamesCounter = 0;
    private static int unknownEngineIdsCounter = 0;
    private static int wrongDigestsCounter = 0;
    private static int decryptionErrorsCounter = 0;
    SnmpMsgProcessingSubSystem sys = null;
    SnmpEngineImpl engine = null;
    private String DISCOVERY_USER = "";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUserSecurityModel");
    String dbgTag = "SnmpUserSecurityModel";

    public SnmpUserSecurityModel(SnmpSubSystem subsys, SnmpUsmLcd snmplcd) {
        super(subsys, "Usm");
        this.lcd = snmplcd;
        this.genExp = new SnmpUsmExceptionGenerator(this);
        this.timeModule = new SnmpUsmTimelinessModule(this.genExp);
        this.authModule = new SnmpUsmAuthModule(this, this.lcd, this.genExp);
        this.privModule = new SnmpUsmPrivModule(this, this.lcd, this.genExp);
        subsys.addModel(3, this);
        this.engine = (SnmpEngineImpl)subsys.getEngine();
        this.sys = this.engine.getMsgProcessingSubSystem();
    }

    public int getTimelinessWindow() {
        return this.timeModule.getTimelinessWindow();
    }

    public void setTimelinessWindow(int t) {
        this.timeModule.setTimelinessWindow(t);
    }

    public SnmpUsmLcd getLcd() {
        return this.lcd;
    }

    public void setLcd(SnmpUsmLcd lcd) {
        this.lcd = lcd;
    }

    public Long getUnsupportedSecLevelsCounter() {
        return new Long(unsupportedSecLevelsCounter);
    }

    public Long getNotInTimeWindowsCounter() {
        return new Long(notInTimeWindowsCounter);
    }

    public Long getUnknownUserNamesCounter() {
        return new Long(unknownUserNamesCounter);
    }

    public Long getUnknownEngineIdsCounter() {
        return new Long(unknownEngineIdsCounter);
    }

    public Long getWrongDigestsCounter() {
        return new Long(wrongDigestsCounter);
    }

    public Long getDecryptionErrorsCounter() {
        return new Long(decryptionErrorsCounter);
    }

    public synchronized SnmpUsmEnginePeer getEnginePeer(SnmpEngineId id) {
        SnmpUsmEnginePeer peer = (SnmpUsmEnginePeer)this.peers.get(id.toString());
        if (peer == null) {
            peer = new SnmpUsmEnginePeer(id);
            this.peers.put(id.toString(), peer);
        }
        return peer;
    }

    public SnmpUsmSecurityParameters createUsmSecurityParameters() {
        SnmpUsmSecurityParametersImpl parameters = new SnmpUsmSecurityParametersImpl();
        return parameters;
    }

    public SnmpSecurityCache createSecurityCache() {
        return new SnmpUsmSecurityCache();
    }

    public void releaseSecurityCache(SnmpSecurityCache cache) {
    }

    public int generateResponseMsg(SnmpSecurityCache cache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, SnmpSecurityParameters p, byte[] contextEngineId, byte[] contextName, byte[] data, int dataLength, byte[] outputBytes) throws SnmpTooBigException, SnmpStatusException, SnmpSecurityException {
        if (logger.finestOn()) {
            logger.finest("generateResponseMsg", "Sending a response");
        }
        SnmpUsmSecurityCache usmcache = (SnmpUsmSecurityCache)cache;
        SnmpUsmSecurityParameters params = (SnmpUsmSecurityParameters)p;
        params.setAuthoritativeEngineBoots(this.engine.getEngineBoots());
        params.setAuthoritativeEngineTime(this.engine.getEngineTime());
        try {
            return this.processOutgoingMessage(this.sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, contextEngineId, contextName, data, dataLength, outputBytes, true);
        }
        catch (SnmpUsmUserNameException ex) {
            throw new SnmpSecurityException(ex.toString());
        }
        catch (SnmpUsmAuthAlgorithmException ea) {
            throw new SnmpSecurityException(ea.toString());
        }
        catch (SnmpUsmPrivAlgorithmException ep) {
            throw new SnmpSecurityException(ep.toString());
        }
        catch (SnmpUsmException e) {
            throw new SnmpSecurityException(e.toString());
        }
    }

    public int generateRequestMsg(SnmpSecurityCache cache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, SnmpSecurityParameters p, byte[] contextEngineId, byte[] contextName, byte[] data, int dataLength, byte[] outputBytes) throws SnmpTooBigException, SnmpStatusException, SnmpSecurityException {
        if (logger.finestOn()) {
            logger.finest("generateRequestMsg", "Sending a request.");
        }
        SnmpUsmSecurityParameters params = null;
        SnmpUsmSecurityCache usmcache = (SnmpUsmSecurityCache)cache;
        params = (SnmpUsmSecurityParameters)p;
        if ((msgFlags & 1) != 0) {
            if (!this.engine.getEngineId().equals(params.getAuthoritativeEngineId())) {
                SnmpUsmEnginePeer peer = (SnmpUsmEnginePeer)this.peers.get(params.getAuthoritativeEngineId().toString());
                if (peer != null) {
                    params.setAuthoritativeEngineBoots(peer.getAuthoritativeEngineBoots());
                    params.setAuthoritativeEngineTime(peer.getAuthoritativeEngineTime());
                    if (logger.finestOn()) {
                        logger.finest("generateRequestMsg", "Setting security parameters to outgoing request using Peer parameters : \nBoot : " + params.getAuthoritativeEngineBoots() + "\n Time : " + params.getAuthoritativeEngineTime());
                    }
                }
            } else {
                params.setAuthoritativeEngineBoots(this.engine.getEngineBoots());
                params.setAuthoritativeEngineTime(this.engine.getEngineTime());
            }
        }
        try {
            return this.processOutgoingMessage(this.sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, contextEngineId, contextName, data, dataLength, outputBytes, false);
        }
        catch (SnmpUsmUserNameException ex) {
            SnmpSecurityException e = new SnmpSecurityException(ex.toString());
            e.contextEngineId = contextEngineId;
            e.contextName = contextName;
            e.flags = msgFlags;
            e.params = p;
            e.status = 244;
            throw e;
        }
        catch (SnmpUsmAuthAlgorithmException ea) {
            SnmpSecurityException e = new SnmpSecurityException(ea.toString());
            e.contextEngineId = contextEngineId;
            e.contextName = contextName;
            e.flags = msgFlags;
            e.params = p;
            e.status = 245;
            throw e;
        }
        catch (SnmpUsmPrivAlgorithmException ep) {
            SnmpSecurityException e = new SnmpSecurityException(ep.toString());
            e.contextEngineId = contextEngineId;
            e.contextName = contextName;
            e.flags = msgFlags;
            e.params = p;
            e.status = 246;
            throw e;
        }
        catch (SnmpUsmEngineIdException ei) {
            SnmpSecurityException e = new SnmpSecurityException(ei.toString());
            e.contextEngineId = contextEngineId;
            e.contextName = contextName;
            e.flags = msgFlags;
            e.params = p;
            e.status = 247;
            throw e;
        }
        catch (SnmpUsmException ee) {
            SnmpSecurityException e = new SnmpSecurityException(ee.toString());
            e.contextEngineId = contextEngineId;
            e.contextName = contextName;
            e.flags = msgFlags;
            e.params = p;
            throw e;
        }
    }

    public SnmpSecurityParameters processIncomingRequest(SnmpSecurityCache cache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] msgSecurityParameters, byte[] contextEngineId, byte[] contextName, byte[] data, byte[] encryptedPdu, SnmpDecryptedPdu decryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        SnmpUsmSecurityParameters params = this.decodeParameters(msgSecurityParameters);
        return this.processIncomingMessage(cache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, msgSecurityParameters, contextEngineId, contextName, data, encryptedPdu, decryptedPdu);
    }

    public SnmpSecurityParameters processIncomingResponse(SnmpSecurityCache cache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] msgSecurityParameters, byte[] contextEngineId, byte[] contextName, byte[] data, byte[] encryptedPdu, SnmpDecryptedPdu decryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        return this.processIncomingMessage(cache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, msgSecurityParameters, contextEngineId, contextName, data, encryptedPdu, decryptedPdu);
    }

    private SnmpSecurityParameters processIncomingMessage(SnmpSecurityCache cache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] msgSecurityParameters, byte[] contextEngineId, byte[] contextName, byte[] data, byte[] encryptedPdu, SnmpDecryptedPdu decryptedPdu) throws SnmpStatusException, SnmpSecurityException {
        SnmpUsmSecurityParameters params = this.decodeParameters(msgSecurityParameters);
        int msgSecurityLevel = msgFlags & 3;
        SnmpUsmSecurityCache usmcache = null;
        if (cache != null) {
            usmcache = (SnmpUsmSecurityCache)cache;
            usmcache.userName = params.getUserName();
        }
        if (this.handleEngineIdDiscovery(params, contextEngineId, contextName)) {
            if (logger.finerOn()) {
                logger.finer("processIncomingMessage", "Received Engine Id discovery response: [" + params.getAuthoritativeEngineId() + "]");
            }
            return params;
        }
        if (logger.finerOn()) {
            logger.finer("processIncomingMessage", "Received Engine Id : [" + params.getAuthoritativeEngineId() + "] , data : " + data);
        }
        if ((msgFlags & 4) == 4 && !this.engine.getEngineId().equals(params.getAuthoritativeEngineId())) {
            if (logger.finestOn()) {
                logger.finest("processIncomingMessage", "Received a reportable message but the received engine Id [" + params.getAuthoritativeEngineId() + "not the local one. Throwing unknownEngineId");
            }
            this.genExp.genEngineIdException(contextEngineId, contextName, msgFlags, params);
        }
        SnmpUsmSecureUser user = null;
        if (logger.finestOn()) {
            logger.finest("processIncomingMessage", "Received msg from :" + params.getAuthoritativeEngineId() + ", principal : [" + params.getPrincipal() + "]");
        }
        try {
            user = this.getUser(params.getAuthoritativeEngineId(), params.getPrincipal());
        }
        catch (SnmpUsmUserNameException e) {
            if (logger.finestOn()) {
                logger.finest("processIncomingMessage", "SnmpUsmUserNameException");
            }
            this.genExp.genUserNameException(contextEngineId, contextName, msgFlags, params);
        }
        catch (SnmpUsmEngineIdException e) {
            if (logger.finestOn()) {
                logger.finest("processIncomingMessage", "genEngineIdException, unknown engine ID when looking for user [" + params.getPrincipal() + "]");
            }
            this.genExp.genEngineIdException(contextEngineId, contextName, msgFlags, params);
        }
        if ((msgSecurityLevel & 3) == 0) {
            if (logger.finestOn()) {
                logger.finest("processIncomingMessage", "noAuthNoPriv message");
            }
            decryptedPdu.data = data;
            decryptedPdu.contextName = contextName;
            decryptedPdu.contextEngineId = contextEngineId;
            return params;
        }
        if (msgSecurityLevel == 1) {
            if (logger.finestOn()) {
                logger.finest("processIncomingMessage", "authNoPriv message, authModule : " + this.authModule);
            }
            this.authModule.authMsg(this.sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, contextEngineId, contextName, data);
            this.handleTimeliness(params);
            decryptedPdu.data = data;
            decryptedPdu.contextName = contextName;
            decryptedPdu.contextEngineId = contextEngineId;
            return params;
        }
        if (msgSecurityLevel == 3) {
            if (logger.finestOn()) {
                logger.finest("processIncomingMessage", "authPriv message");
            }
            this.authModule.authMsg(this.sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, encryptedPdu);
            this.handleTimeliness(params);
            SnmpDecryptedPdu pdu = this.privModule.decrypt(this.sys, version, params, usmcache, encryptedPdu, msgFlags);
            decryptedPdu.data = pdu.data;
            decryptedPdu.contextName = pdu.contextName;
            decryptedPdu.contextEngineId = pdu.contextEngineId;
        }
        return params;
    }

    private int processOutgoingMessage(SnmpMsgProcessingSubSystem sys, SnmpUsmSecurityParameters params, SnmpUsmSecurityCache usmcache, int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, byte[] contextEngineId, byte[] contextName, byte[] data, int dataLength, byte[] outputBytes, boolean response) throws SnmpUsmException, SnmpStatusException, SnmpTooBigException {
        try {
            int securityLevel = msgFlags & 3;
            boolean workingBuffLen = false;
            switch (securityLevel) {
                case 0: {
                    if (!this.DISCOVERY_USER.equals(params.getPrincipal()) && params.getAuthoritativeEngineId() != null && !response) {
                        try {
                            if (logger.finestOn()) {
                                logger.finest("processOutgoingMessage", "Sending noAuthNoPriv from :" + params.getAuthoritativeEngineId() + ", principal : [" + params.getPrincipal() + "]");
                            }
                            this.lcd.getUser(params.getAuthoritativeEngineId(), params.getPrincipal());
                            if (logger.finestOn()) {
                                logger.finest("processOutgoingMessage", "OK noAuthNoPriv msg");
                            }
                        }
                        catch (SnmpUsmEngineIdException e) {
                            if (logger.finestOn()) {
                                logger.finest("processOutgoingMessage", "SnmpUsmEngineIdException");
                            }
                            throw new SnmpUsmUserNameException("Unknown user :" + params.getPrincipal());
                        }
                    }
                    return sys.encode(version, msgId, msgMaxSize, msgFlags, msgSecurityModel, params, contextEngineId, contextName, data, dataLength, outputBytes);
                }
                case 1: {
                    byte[] hmac = this.authModule.signMsg(sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, contextEngineId, contextName, data, dataLength);
                    params.setAuthParameters(hmac);
                    int len = sys.encode(version, msgId, msgMaxSize, msgFlags, msgSecurityModel, params, contextEngineId, contextName, data, dataLength, outputBytes);
                    return len;
                }
                case 3: {
                    byte[] pduToEncrypte = new byte[msgMaxSize];
                    byte[] authBuff = new byte[msgMaxSize];
                    SnmpDecryptedPdu pdu = new SnmpDecryptedPdu();
                    pdu.data = data;
                    pdu.dataLength = dataLength;
                    pdu.contextEngineId = contextEngineId;
                    pdu.contextName = contextName;
                    if (logger.finestOn()) {
                        logger.finest("processOutgoingMessage", "Flat pdu to encrypt : length : " + pdu.data.length + "Engine Id :" + SnmpTools.binary2ascii(pdu.contextEngineId) + " Contexte name :" + (pdu.contextName == null ? "Unknown context name" : new String(pdu.contextName)));
                    }
                    int length = sys.encode(version, pdu, pduToEncrypte);
                    byte[] encryptedPdu = this.privModule.encrypt(usmcache, params, pduToEncrypte, length);
                    byte[] hmac = this.authModule.signMsg(sys, params, usmcache, version, msgId, msgMaxSize, msgFlags, msgSecurityModel, encryptedPdu);
                    params.setAuthParameters(hmac);
                    int len = sys.encodePriv(version, msgId, msgMaxSize, msgFlags, msgSecurityModel, params, encryptedPdu, outputBytes);
                    return len;
                }
            }
            throw new SnmpUsmException("Bad Security Level.");
        }
        catch (ArrayIndexOutOfBoundsException x) {
            if (logger.finestOn()) {
                logger.finest("processOutgoingMessage", x);
            }
            throw new SnmpTooBigException();
        }
        catch (SnmpUnknownMsgProcModelException x) {
            if (logger.finestOn()) {
                logger.finest("processOutgoingMessage", x);
            }
            throw new SnmpUsmException("unknown MsgProcModel Exception");
        }
    }

    SnmpUsmSecureUser getUser(SnmpEngineId engineId, String user) throws SnmpUsmUserNameException, SnmpUsmEngineIdException {
        SnmpUsmSecureUser secureUser = null;
        if (logger.finestOn()) {
            logger.finest("getUser", "Getting user infos for :" + engineId + ", principal : [" + user + "]");
        }
        secureUser = this.lcd.getUser(engineId, user);
        if (logger.finestOn()) {
            logger.finest("getUser", "OK Found user");
        }
        return secureUser;
    }

    boolean handleEngineIdDiscovery(SnmpUsmSecurityParameters params, byte[] contextEngineId, byte[] contextName) throws SnmpSecurityException, SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("handleEngineIdDiscovery", "principal :" + params.getPrincipal() + ", engine Id" + params.getAuthoritativeEngineId());
        }
        if (params.getAuthoritativeEngineId() == null) {
            if (logger.finerOn()) {
                logger.finer("handleEngineIdDiscovery", "Engine Id Discovery. Will send back :" + this.engine.getEngineId());
            }
            params.setAuthoritativeEngineId(this.engine.getEngineId());
            params.setAuthoritativeEngineTime(0);
            params.setAuthoritativeEngineBoots(0);
            this.genExp.genEngineIdException(contextEngineId, contextName, (byte)4, params);
            return false;
        }
        if (this.DISCOVERY_USER.equals(params.getPrincipal())) {
            if (!this.engine.getEngineId().equals(params.getAuthoritativeEngineId())) {
                if (logger.finerOn()) {
                    logger.finer("handleEngineIdDiscovery", "Engine Id Discovery response : [" + params.getAuthoritativeEngineId());
                }
                this.lcd.addEngine(params.getAuthoritativeEngineId());
                SnmpUsmEnginePeer peer = (SnmpUsmEnginePeer)this.peers.get(params.getAuthoritativeEngineId().toString());
                if (peer == null) {
                    if (logger.finestOn()) {
                        logger.finest("handleEngineIdDiscovery", "Create peer.");
                    }
                    peer = new SnmpUsmEnginePeer(params.getAuthoritativeEngineId());
                    this.peers.put(params.getAuthoritativeEngineId().toString(), peer);
                }
            } else {
                if (logger.finerOn()) {
                    logger.finer("handleEngineIdDiscovery", "Received a response with engine Id == Local One. Throwing exception.");
                }
                SnmpSecurityException e = new SnmpSecurityException("Engine Id discovery failed, Received engine Id [" + params.getAuthoritativeEngineId() + "] is equals to local one!");
                e.status = 247;
                throw e;
            }
            return true;
        }
        return false;
    }

    void handleTimeliness(SnmpUsmSecurityParameters params) throws SnmpSecurityException, SnmpStatusException {
        if (this.engine.getEngineId().equals(params.getAuthoritativeEngineId())) {
            if (logger.finestOn()) {
                logger.finest("handleTimeliness", "Check Request timeliness.");
            }
            this.timeModule.handleTimeliness(this.engine, params);
        } else {
            SnmpUsmEnginePeer peer = (SnmpUsmEnginePeer)this.peers.get(params.getAuthoritativeEngineId().toString());
            if (peer == null) {
                if (logger.finestOn()) {
                    logger.finest("handleTimeliness", "Received an authenticated unconfirmed pdu from an unknown authoritative. Create peer.");
                }
                peer = new SnmpUsmEnginePeer(params.getAuthoritativeEngineId());
                this.peers.put(params.getAuthoritativeEngineId().toString(), peer);
            }
            if (logger.finestOn()) {
                logger.finest("handleTimeliness", "Check Response timeliness.");
            }
            this.timeModule.handleResponseTimeliness(peer, params);
        }
    }

    SnmpUsmSecurityParameters decodeParameters(byte[] params) throws SnmpStatusException {
        SnmpUsmSecurityParameters parameters = this.createUsmSecurityParameters();
        parameters.decode(params);
        return parameters;
    }

    synchronized long incUnsupportedSecLevelsCounter(int n) {
        return unsupportedSecLevelsCounter += n;
    }

    synchronized long incNotInTimeWindowsCounter(int n) {
        return notInTimeWindowsCounter += n;
    }

    synchronized long incUnknownUserNamesCounter(int n) {
        return unknownUserNamesCounter += n;
    }

    synchronized long incUnknownEngineIdsCounter(int n) {
        return unknownEngineIdsCounter += n;
    }

    synchronized long incWrongDigestsCounter(int n) {
        return wrongDigestsCounter += n;
    }

    synchronized long incDecryptionErrorsCounter(int n) {
        return decryptionErrorsCounter += n;
    }
}

