/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.component.factory.basic.GenericFactory;
import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.ViewRootUtil;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.LayoutInsert;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.layout.facelets.DbFactory;
import com.sun.jsftemplating.layout.facelets.NSContext;
import com.sun.jsftemplating.util.FileUtil;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.faces.context.FacesContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutDefinitionManager {
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private static Map<String, LayoutDefinitionManager> _instances = new HashMap<String, LayoutDefinitionManager>(4);
    private static Map<String, LayoutDefinition> _layoutDefinitions = new HashMap<String, LayoutDefinition>();
    private static Map<String, ComponentType> _globalComponentTypes = null;
    private static Map<String, HandlerDefinition> _globalHandlerDefs = null;
    private static final HandlerDefinition NOOP_HD = new HandlerDefinition("_NOOP_");
    private static List<Resource> _globalResources = null;
    private static List<String> _ldmKeys = null;
    public static final String DEFAULT_TYPE = "Object";
    public static final String LAYOUT_DEFINITION_MANAGER_KEY = "LayoutDefinitionManagerImpl";
    public static final String DEBUG_FLAG = "com.sun.jsftemplating.DEBUG";
    private static Boolean _debug = null;
    public static final boolean DEBUG = LayoutDefinitionManager.isDebug();
    public static final String CACHE_PREFIX = "_LDCache";

    protected LayoutDefinitionManager() {
    }

    public abstract LayoutDefinition getLayoutDefinition(String var1) throws LayoutDefinitionException;

    public abstract boolean accepts(String var1);

    public static LayoutDefinition getLayoutDefinition(FacesContext ctx, String key) throws LayoutDefinitionException {
        String cacheKey = FileUtil.cleanUpPath(key.startsWith("/") ? key : FileUtil.getAbsolutePath(ctx, key));
        LayoutDefinition def = LayoutDefinitionManager.getCachedLayoutDefinition(cacheKey);
        if (def == null) {
            def = LayoutDefinitionManager.getLayoutDefinitionManager(ctx, key).getLayoutDefinition(key);
            LayoutDefinitionManager.putCachedLayoutDefinition(cacheKey, def);
        } else {
            def.dispatchInitPageHandlers(ctx, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LayoutComponent getLayoutComponent(FacesContext ctx, String ldKey, String clientId) throws LayoutDefinitionException {
        LayoutElementBase layElt = null;
        if (ldKey != null) {
            layElt = LayoutDefinitionManager.getLayoutDefinition(ctx, ldKey);
            if (layElt == null) {
                throw new LayoutDefinitionException("Unable to find LayoutDefinition ('" + ldKey + "')");
            }
        } else {
            layElt = ViewRootUtil.getLayoutDefinition(FacesContext.getCurrentInstance().getViewRoot());
        }
        Stack<LayoutElement> oldStack = LayoutComposition.getCompositionStack(ctx);
        try {
            LayoutComposition.setCompositionStack(ctx, new Stack<LayoutElement>());
            StringTokenizer tok = new StringTokenizer(clientId, ":");
            String id = null;
            LayoutComponent match = null;
            while (tok.hasMoreTokens()) {
                id = tok.nextToken();
                match = LayoutDefinitionManager.findById(ctx, layElt, id);
                if (match == null) {
                    break;
                }
                layElt = match;
            }
        }
        finally {
            LayoutComposition.setCompositionStack(ctx, oldStack);
        }
        if (layElt instanceof LayoutDefinition) {
            layElt = null;
        }
        return (LayoutComponent)layElt;
    }

    /*
     * Unable to fully structure code
     */
    private static LayoutComponent findById(FacesContext ctx, LayoutElement elt, String id) {
        shouldPop = false;
        if (elt instanceof LayoutComposition) {
            viewId = ((LayoutComposition)elt).getTemplate();
            if (viewId != null) {
                LayoutComposition.push(ctx, elt);
                shouldPop = true;
                try {
                    elt = LayoutDefinitionManager.getLayoutDefinition(ctx, viewId);
                }
                catch (LayoutDefinitionException ex) {
                    if (!((LayoutComposition)elt).isRequired()) ** GOTO lbl16
                    throw ex;
                }
            }
        } else if (elt instanceof LayoutInsert) {
            // empty if block
        }
lbl16:
        // 6 sources

        comp = null;
        for (LayoutElement child : elt.getChildLayoutElements()) {
            if (!child.getId(ctx, null).equals(id) || !(child instanceof LayoutComponent)) continue;
            comp = (LayoutComponent)child;
        }
        if (comp == null) {
            i$ = elt.getChildLayoutElements().iterator();
            while (i$.hasNext() && (comp = LayoutDefinitionManager.findById(ctx, child = i$.next(), id)) == null) {
            }
        }
        if (shouldPop) {
            LayoutComposition.pop(ctx);
        }
        return comp;
    }

    public static LayoutDefinitionManager getLayoutDefinitionManager(FacesContext ctx, String key) throws LayoutDefinitionException {
        List<String> ldms = LayoutDefinitionManager.getLayoutDefinitionManagers(ctx);
        LayoutDefinitionManager mgr = null;
        for (String className : ldms) {
            mgr = LayoutDefinitionManager.getLayoutDefinitionManager(className);
            if (!mgr.accepts(key)) continue;
            return mgr;
        }
        throw new LayoutDefinitionException("No LayoutDefinitionManager available for '" + key + "'.  This may mean the file cannot " + "be found, or is unrecognizable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getLayoutDefinitionManagers(FacesContext ctx) {
        if (_ldmKeys == null) {
            Map initParams;
            ArrayList<String> keys = new ArrayList<String>();
            String def = "";
            if (ctx != null && (initParams = ctx.getExternalContext().getInitParameterMap()).containsKey(LAYOUT_DEFINITION_MANAGER_KEY)) {
                def = ((String)initParams.get(LAYOUT_DEFINITION_MANAGER_KEY)).trim();
                keys.add(def);
            }
            try {
                BufferedReader rdr = null;
                InputStream is = null;
                String line = null;
                Enumeration<URL> urls = Util.getClassLoader(ctx).getResources("META-INF/jsftemplating/FormatDefinition.map");
                while (urls.hasMoreElements()) {
                    try {
                        is = urls.nextElement().openStream();
                        rdr = new BufferedReader(new InputStreamReader(is));
                        line = rdr.readLine();
                        while (line != null) {
                            if ((line = line.trim()).equals("") || line.startsWith("#") || line.equals(def)) continue;
                            keys.add(line);
                            line = rdr.readLine();
                        }
                    }
                    catch (Throwable throwable) {
                        Util.closeStream(is);
                        throw throwable;
                    }
                    Util.closeStream(is);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            _ldmKeys = keys;
        }
        return _ldmKeys;
    }

    public static LayoutDefinitionManager getLayoutDefinitionManager(String className) {
        LayoutDefinitionManager ldm = _instances.get(className);
        if (ldm == null) {
            try {
                ldm = (LayoutDefinitionManager)Util.loadClass(className, className).getMethod("getInstance", null).invoke((Object)null, (Object[])null);
            }
            catch (ClassNotFoundException ex) {
                throw new LayoutDefinitionException("Unable to find LDM: '" + className + "'.", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new LayoutDefinitionException("LDM '" + className + "' does not have a 'getInstance()' method!", ex);
            }
            catch (IllegalAccessException ex) {
                throw new LayoutDefinitionException("Unable to access LDM: '" + className + "'!", ex);
            }
            catch (InvocationTargetException ex) {
                throw new LayoutDefinitionException("Error while attempting to get LDM: '" + className + "'!", ex);
            }
            catch (ClassCastException ex) {
                throw new LayoutDefinitionException("LDM '" + className + "' must extend from '" + LayoutDefinitionManager.class.getName() + " and must " + "be loaded from the same ClassLoader!", ex);
            }
            catch (NullPointerException ex) {
                throw new LayoutDefinitionException(ex);
            }
            _instances.put(className, ldm);
        }
        return ldm;
    }

    public static LayoutDefinition getCachedLayoutDefinition(String key) {
        if (LayoutDefinitionManager.isDebug()) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            if (ctx != null) {
                return (LayoutDefinition)ctx.getExternalContext().getRequestMap().get(CACHE_PREFIX + key);
            }
            return null;
        }
        return _layoutDefinitions.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putCachedLayoutDefinition(String key, LayoutDefinition value) {
        if (LayoutDefinitionManager.isDebug()) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            if (ctx != null) {
                ctx.getExternalContext().getRequestMap().put(CACHE_PREFIX + key, value);
            }
        } else {
            Map<String, LayoutDefinition> map = _layoutDefinitions;
            synchronized (map) {
                _layoutDefinitions.put(key, value);
            }
        }
    }

    public Object getAttribute(String key) {
        return this._attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ComponentType> getGlobalComponentTypes() {
        if (_globalComponentTypes == null) {
            HashMap<String, ComponentType> types = new HashMap<String, ComponentType>();
            try {
                Properties props = null;
                URL url = null;
                String id = null;
                Enumeration<URL> urls = Util.getClassLoader(types).getResources("META-INF/jsftemplating/UIComponentFactory.map");
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    props = new Properties();
                    InputStream is = null;
                    try {
                        is = url.openStream();
                        props.load(is);
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            id = (String)entry.getKey();
                            types.put(id, new ComponentType(id, (String)entry.getValue()));
                        }
                    }
                    finally {
                        Util.closeStream(is);
                    }
                }
                LayoutDefinitionManager.readComponentsFromTaglibXml(types);
                _globalComponentTypes = types;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return _globalComponentTypes;
    }

    private static void readComponentsFromTaglibXml(Map<String, ComponentType> types) throws IOException {
        Enumeration<URL> urls = Util.getClassLoader(types).getResources("META-INF/");
        HashSet<URL> files = new HashSet<URL>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.setDefaultUseCaches(false);
            if (!(conn instanceof JarURLConnection)) continue;
            JarURLConnection jarConn = (JarURLConnection)conn;
            JarFile jarFile = jarConn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith("META-INF") || !entryName.endsWith("taglib.xml")) continue;
                Enumeration<URL> e = Util.getClassLoader(types).getResources(entryName);
                while (e.hasMoreElements()) {
                    files.add(e.nextElement());
                }
            }
        }
        if (files.size() > 0) {
            for (URL url : files) {
                LayoutDefinitionManager.processTaglibXml(url, types);
            }
        }
    }

    private static void processTaglibXml(URL url, Map<String, ComponentType> types) {
        InputStream is = null;
        try {
            is = url.openStream();
            DocumentBuilder builder = DbFactory.getInstance();
            Document document = builder.parse(is);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NSContext ns = new NSContext();
            ns.addNamespace("f", "http://java.sun.com/JSF/Facelet");
            xpath.setNamespaceContext(ns);
            String nameSpace = xpath.evaluate("/f:facelet-taglib/f:namespace", document);
            NodeList nl = (NodeList)xpath.evaluate("/f:facelet-taglib/f:tag", document, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                String tagName = xpath.evaluate("f:tag-name", node);
                String componentType = xpath.evaluate("f:component/f:component-type", node);
                String id = nameSpace + ":" + tagName;
                types.put(id, new ComponentType(id, GenericFactory.class.getName(), (Serializable)((Object)componentType)));
            }
        }
        catch (Exception e) {
            if (LogUtil.severeEnabled()) {
                LogUtil.severe(e.getMessage());
            }
            throw new RuntimeException(e);
        }
        finally {
            Util.closeStream(is);
        }
    }

    public static ComponentType getGlobalComponentType(String typeID) {
        return LayoutDefinitionManager.getGlobalComponentTypes().get(typeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalComponentType(ComponentType type) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalComponentTypes().put(type.getId(), type);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalComponentTypes() {
        _globalComponentTypes = null;
    }

    public static Map<String, HandlerDefinition> getGlobalHandlerDefinitions() {
        return LayoutDefinitionManager.getGlobalHandlerDefinitions("META-INF/jsftemplating/Handler.map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Map<String, HandlerDefinition> getGlobalHandlerDefinitions(String filename) {
        HashMap<String, HandlerDefinition> handlers = null;
        if (_globalHandlerDefs == null) {
            handlers = new HashMap<String, HandlerDefinition>();
        } else {
            if (_globalHandlerDefs.get(filename) != null) {
                return _globalHandlerDefs;
            }
            handlers = new HashMap<String, HandlerDefinition>(_globalHandlerDefs);
        }
        handlers.put(filename, NOOP_HD);
        Properties props = null;
        URL url = null;
        try {
            Enumeration<URL> urls = Util.getClassLoader(filename).getResources(filename);
            InputStream is = null;
            while (urls.hasMoreElements()) {
                try {
                    url = urls.nextElement();
                    props = new Properties();
                    is = url.openStream();
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        if (!((String)entry.getKey()).endsWith(".class")) continue;
                        LayoutDefinitionManager.readGlobalHandlerDefinition(handlers, props, entry);
                    }
                }
                catch (Throwable throwable) {
                    Util.closeStream(is);
                    throw throwable;
                }
                Util.closeStream(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        _globalHandlerDefs = handlers;
        return _globalHandlerDefs;
    }

    private static void readGlobalHandlerDefinition(HashMap<String, HandlerDefinition> hdMap, Map<String, String> props, Map.Entry<Object, Object> entry) {
        String key = (String)entry.getKey();
        key = key.substring(0, key.lastIndexOf(46));
        HandlerDefinition def = new HandlerDefinition(key);
        String value = props.get(key + '.' + "method");
        def.setHandlerMethod((String)entry.getValue(), value);
        def.setInputDefs(LayoutDefinitionManager.readIODefs(props, key, true));
        def.setOutputDefs(LayoutDefinitionManager.readIODefs(props, key, false));
        hdMap.put(key, def);
    }

    private static Map<String, IODescriptor> readIODefs(Map<String, String> map, String key, boolean input) {
        String inOrOut = input ? "input" : "output";
        int count = 0;
        IODescriptor desc = null;
        HashMap<String, IODescriptor> defs = new HashMap<String, IODescriptor>(5);
        String value = map.get(key + "." + inOrOut + "[" + count + "].name");
        while (value != null) {
            String type = map.get(key + "." + inOrOut + "[" + count + "].type");
            if (type == null) {
                type = DEFAULT_TYPE;
            }
            desc = new IODescriptor(value, type);
            defs.put(value, desc);
            if (input) {
                value = map.get(key + "." + inOrOut + "[" + count + "].required");
                if (value != null && Boolean.valueOf(value).booleanValue()) {
                    desc.setRequired(true);
                }
                if ((value = map.get(key + "." + inOrOut + "[" + count + "].defaultValue")) != null && !value.equals("jsfTempNULLString")) {
                    desc.setDefault(value);
                }
            }
            value = map.get(key + "." + inOrOut + "[" + ++count + "].name");
        }
        return defs;
    }

    public static HandlerDefinition getGlobalHandlerDefinition(String id) {
        return LayoutDefinitionManager.getGlobalHandlerDefinitions().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalHandlerDefinition(HandlerDefinition def) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalHandlerDefinitions().put(def.getId(), def);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalHandlerDefinitions() {
        _globalHandlerDefs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalResource(Resource res) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalResources().add(res);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static List<Resource> getGlobalResources() {
        if (_globalResources == null) {
            _globalResources = new ArrayList<Resource>();
        }
        return _globalResources;
    }

    public static void clearGlobalResources() {
        _globalResources = null;
    }

    public static boolean isDebug() {
        FacesContext ctx;
        if (_debug != null) {
            return _debug;
        }
        boolean flag = Boolean.getBoolean(DEBUG_FLAG);
        _debug = flag;
        if (!flag && (ctx = FacesContext.getCurrentInstance()) != null) {
            String initParam = ctx.getExternalContext().getInitParameter(DEBUG_FLAG);
            if (initParam != null) {
                flag = Boolean.parseBoolean(initParam);
                _debug = flag;
            } else {
                _debug = null;
            }
        }
        return flag;
    }

    public static void setDebug(boolean flag) {
        _debug = flag;
    }
}

