/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.xml.parser;

import java.util.Vector;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContentHandler
implements ContentHandler {
    private static final String NAMESPACE_URI = "http://java.sun.com/xml/ns/persistence";
    private static final String ELEMENT_PERSISTENCE_UNIT = "persistence-unit";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ELEMENT_JTA_DATA_SOURCE = "jta-data-source";
    private static final String ELEMENT_NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String ELEMENT_MAPPING_FILE = "mapping-file";
    private static final String ELEMENT_JAR_FILE = "jar-file";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_TRANSACTION_TYPE = "transaction-type";
    private SEPersistenceUnitInfo persistenceUnitInfo;
    private Vector<SEPersistenceUnitInfo> persistenceUnits;
    private StringBuffer stringBuffer = new StringBuffer();
    private boolean readCharacters = false;

    public PersistenceContentHandler() {
        this.persistenceUnits = new Vector();
    }

    public Vector<SEPersistenceUnitInfo> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (NAMESPACE_URI.equals(string)) {
            if (ELEMENT_PERSISTENCE_UNIT.equals(string2)) {
                this.persistenceUnitInfo = new SEPersistenceUnitInfo();
                this.persistenceUnitInfo.setPersistenceUnitName(attributes.getValue(ATTRIBUTE_NAME));
                String string4 = attributes.getValue(ATTRIBUTE_TRANSACTION_TYPE);
                if (string4 != null) {
                    this.persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.valueOf((String)string4));
                }
                return;
            }
            if (ELEMENT_PROPERTY.equals(string2)) {
                String string5 = attributes.getValue(ATTRIBUTE_NAME);
                String string6 = attributes.getValue(ATTRIBUTE_VALUE);
                this.persistenceUnitInfo.getProperties().setProperty(string5, string6);
            } else {
                if (ELEMENT_PROVIDER.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_JTA_DATA_SOURCE.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_NON_JTA_DATA_SOURCE.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_MAPPING_FILE.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_JAR_FILE.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_EXCLUDE_UNLISTED_CLASSES.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
                if (ELEMENT_CLASS.equals(string2)) {
                    this.readCharacters = true;
                    return;
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.stringBuffer.toString().trim();
        this.stringBuffer.delete(0, this.stringBuffer.length());
        this.readCharacters = false;
        if (NAMESPACE_URI.equals(string)) {
            if (ELEMENT_PROVIDER.equals(string2)) {
                this.persistenceUnitInfo.setPersistenceProviderClassName(string4);
                return;
            }
            if (ELEMENT_JTA_DATA_SOURCE.equals(string2)) {
                this.persistenceUnitInfo.setJtaDataSource(new DataSourceImpl(string4, null, null, null));
                return;
            }
            if (ELEMENT_NON_JTA_DATA_SOURCE.equals(string2)) {
                this.persistenceUnitInfo.setNonJtaDataSource(new DataSourceImpl(string4, null, null, null));
                return;
            }
            if (ELEMENT_MAPPING_FILE.equals(string2)) {
                this.persistenceUnitInfo.getMappingFileNames().add(string4);
                return;
            }
            if (ELEMENT_JAR_FILE.equals(string2)) {
                this.persistenceUnitInfo.getJarFiles().add(string4);
                return;
            }
            if (ELEMENT_CLASS.equals(string2)) {
                this.persistenceUnitInfo.getManagedClassNames().add(string4);
                return;
            }
            if (ELEMENT_EXCLUDE_UNLISTED_CLASSES.equals(string2)) {
                if (string4.equals("true") || string4.equals("1")) {
                    this.persistenceUnitInfo.setExcludeUnlistedClasses(true);
                } else {
                    this.persistenceUnitInfo.setExcludeUnlistedClasses(false);
                }
                return;
            }
            if (ELEMENT_PERSISTENCE_UNIT.equals(string2) && this.persistenceUnitInfo != null) {
                this.persistenceUnits.add(this.persistenceUnitInfo);
                this.persistenceUnitInfo = null;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.readCharacters) {
            this.stringBuffer.append(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }
}

