/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureParameterMetadata
extends ORMetadata {
    private Class m_type;
    private Enum m_direction;
    private Integer m_jdbcType;
    private String m_jdbcTypeName;
    private String m_name;
    private String m_queryParameter;
    private String m_typeName;

    public StoredProcedureParameterMetadata() {
        super("<stored-procedure-parameter>");
    }

    public StoredProcedureParameterMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_direction = (Enum)MetadataHelper.invokeMethod("direction", annotation);
        this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
        this.m_queryParameter = (String)MetadataHelper.invokeMethod("queryParameter", annotation);
        this.m_type = (Class)MetadataHelper.invokeMethod("type", annotation);
        this.m_jdbcType = (Integer)MetadataHelper.invokeMethod("jdbcType", annotation);
        this.m_jdbcTypeName = (String)MetadataHelper.invokeMethod("jdbcTypeName", annotation);
    }

    public boolean equals(Object object) {
        if (object instanceof StoredProcedureParameterMetadata) {
            StoredProcedureParameterMetadata storedProcedureParameterMetadata = (StoredProcedureParameterMetadata)object;
            if (!this.valuesMatch(this.m_type, storedProcedureParameterMetadata.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_direction, storedProcedureParameterMetadata.getDirection())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcType, storedProcedureParameterMetadata.getJdbcType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcTypeName, storedProcedureParameterMetadata.getJdbcTypeName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, storedProcedureParameterMetadata.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_queryParameter, storedProcedureParameterMetadata.getQueryParameter());
        }
        return false;
    }

    public Enum getDirection() {
        return this.m_direction;
    }

    public Integer getJdbcType() {
        return this.m_jdbcType;
    }

    public String getJdbcTypeName() {
        return this.m_jdbcTypeName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public Class getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    protected boolean hasJdbcType() {
        return this.m_jdbcType != null && this.m_jdbcType.equals(-1);
    }

    protected boolean hasJdbcTypeName() {
        return this.m_jdbcTypeName != null && !this.m_jdbcTypeName.equals("");
    }

    protected boolean hasType() {
        return this.m_type != Void.TYPE;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_type = this.initXMLClassName(this.m_typeName);
    }

    public List<String> process(StoredProcedureCall storedProcedureCall) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string = this.m_name.equals("") ? this.m_queryParameter : this.m_name;
        if (this.m_direction == null || this.m_direction.name().equals(Direction.IN.name())) {
            if (this.hasType()) {
                storedProcedureCall.addNamedArgument(string, this.m_queryParameter, this.m_type);
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                storedProcedureCall.addNamedArgument(string, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                storedProcedureCall.addNamedArgument(string, this.m_queryParameter, this.m_jdbcType.intValue());
            } else {
                storedProcedureCall.addNamedArgument(string, this.m_queryParameter);
            }
            arrayList.add(this.m_queryParameter);
        } else if (this.m_direction.name().equals(Direction.OUT.name())) {
            if (this.hasType()) {
                storedProcedureCall.addNamedOutputArgument(string, this.m_queryParameter, this.m_type);
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                storedProcedureCall.addNamedOutputArgument(string, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                storedProcedureCall.addNamedOutputArgument(string, this.m_queryParameter, this.m_jdbcType.intValue());
            } else {
                storedProcedureCall.addNamedOutputArgument(string, this.m_queryParameter);
            }
        } else if (this.m_direction.name().equals(Direction.IN_OUT.name())) {
            if (this.hasType()) {
                storedProcedureCall.addNamedInOutputArgument(string, this.m_queryParameter, this.m_queryParameter, this.m_type);
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                storedProcedureCall.addNamedInOutputArgument(string, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
            } else if (this.hasJdbcType()) {
                storedProcedureCall.addNamedInOutputArgument(string, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue());
            } else {
                storedProcedureCall.addNamedInOutputArgument(string, this.m_queryParameter);
            }
            arrayList.add(this.m_queryParameter);
        } else if (this.m_direction.name().equals(Direction.OUT_CURSOR.name())) {
            storedProcedureCall.useNamedCursorOutputAsResultSet(this.m_queryParameter);
        }
        return arrayList;
    }

    public void setDirection(Enum enum_) {
        this.m_direction = enum_;
    }

    public void setJdbcType(Integer n) {
        this.m_jdbcType = n;
    }

    public void setJdbcTypeName(String string) {
        this.m_jdbcTypeName = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setQueryParameter(String string) {
        this.m_queryParameter = string;
    }

    public void setType(Class clazz) {
        this.m_type = clazz;
    }

    public void setTypeName(String string) {
        this.m_typeName = string;
    }
}

