/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JavaModuleNamingProxy
implements NamedNamingObjectProxy,
PostConstruct {
    @Inject
    Habitat habitat;
    private InitialContext ic;
    private static final String JAVA_MODULE_CONTEXT = "java:module/";

    public void postConstruct() {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException("JavaModuleNamingProxy InitialContext creation failure", ne);
        }
    }

    public Object handle(String name) throws NamingException {
        if (name.startsWith(JAVA_MODULE_CONTEXT)) {
            return this.getJavaModuleObject(name);
        }
        return null;
    }

    private Object getJavaModuleObject(String name) throws NamingException {
        ComponentEnvManager namingMgr;
        String newName = null;
        if (this.habitat != null && (namingMgr = (ComponentEnvManager)this.habitat.getComponent(ComponentEnvManager.class)) != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            EjbBundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)env;
            }
            if (bd != null) {
                Application app = bd.getApplication();
                String appName = null;
                if (!app.isVirtual() && !app.isPackagedAsSingleModule()) {
                    appName = app.getRegistrationName();
                }
                String moduleName = null;
                if (appName == null) {
                    moduleName = app.getRegistrationName();
                } else {
                    String archiveUri = bd.getModuleDescriptor().getArchiveUri();
                    int length = archiveUri.length();
                    moduleName = archiveUri.substring(0, length - 4);
                }
                StringBuffer javaGlobalName = new StringBuffer("java:global/");
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append("/");
                }
                javaGlobalName.append(moduleName);
                javaGlobalName.append("/");
                int javaModuleLength = JAVA_MODULE_CONTEXT.length();
                javaGlobalName.append(name.substring(javaModuleLength));
                newName = javaGlobalName.toString();
            }
        }
        if (newName == null) {
            throw new NamingException("Invalid Java EE environment context for " + name);
        }
        return this.ic.lookup(newName);
    }
}

