/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.config.Property;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="admin-object-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.admin.object")
public class AdminObjectManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AdminObjectManager.class);
    private String resType = null;
    private String raName = null;
    private String enabled = Boolean.TRUE.toString();
    private String jndiName = null;
    private String description = null;

    public String getResourceType() {
        return "admin-object-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attrList, final Properties props, Server targetServer) throws Exception {
        this.setParams(attrList);
        if (this.jndiName == null) {
            String msg = localStrings.getLocalString("create.admin.object.noJndiName", "No JNDI name defined for administered object.");
            return new ResourceStatus(1, msg);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof AdminObjectResource) || !((AdminObjectResource)resource).getJndiName().equals(this.jndiName)) continue;
            String msg = localStrings.getLocalString("create.admin.object.duplicate", "An administered object named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    AdminObjectResource newResource = (AdminObjectResource)param.createChild(AdminObjectResource.class);
                    newResource.setJndiName(AdminObjectManager.this.jndiName);
                    if (AdminObjectManager.this.description != null) {
                        newResource.setDescription(AdminObjectManager.this.description);
                    }
                    newResource.setResAdapter(AdminObjectManager.this.raName);
                    newResource.setResType(AdminObjectManager.this.resType);
                    newResource.setEnabled(AdminObjectManager.this.enabled.toString());
                    if (props != null) {
                        for (Map.Entry<Object, Object> e : props.entrySet()) {
                            Property prop = (Property)newResource.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.admin.object.fail", "Unable to create administered object {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg);
        }
        String msg = localStrings.getLocalString("create.admin.object.success", "Administered object {0} created.", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    public void setParams(HashMap attrList) {
        this.resType = (String)attrList.get("res-type");
        this.enabled = (String)attrList.get("enabled");
        this.jndiName = (String)attrList.get("jndi-name");
        this.description = (String)attrList.get(DESCRIPTION);
        this.raName = (String)attrList.get("res-adapter");
    }

    private boolean isResTypeValid(String raName) {
        boolean isResTypeValid = true;
        return isResTypeValid;
    }
}

