/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.OrderingOrderingDescriptor;
import com.sun.enterprise.deployment.WebFragmentDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingDescriptor
extends Descriptor {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(OrderingDescriptor.class);
    OrderingOrderingDescriptor after = null;
    OrderingOrderingDescriptor before = null;

    public OrderingOrderingDescriptor getAfter() {
        return this.after;
    }

    public void setAfter(OrderingOrderingDescriptor after) {
        this.after = after;
        this.validate();
    }

    public OrderingOrderingDescriptor getBefore() {
        return this.before;
    }

    public void setBefore(OrderingOrderingDescriptor before) {
        this.before = before;
        this.validate();
    }

    public void validate() {
        boolean valid = true;
        if (this.after != null && this.before != null) {
            if (this.after.containsOthers() && this.before.containsOthers()) {
                valid = false;
            }
            if (valid) {
                for (String name : this.after.getNames()) {
                    if (!this.before.containsName(name)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (!valid) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioninvalidordering", "The ordering is not valid as it contains the same name and/or others in both before and after."));
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.after != null) {
            builder.append("after: " + this.after + ", ");
        }
        if (this.before != null) {
            builder.append("before: " + this.before);
        }
        return builder.toString();
    }

    public static void sort(List<WebFragmentDescriptor> wfs) {
        if (wfs == null || wfs.size() == 1) {
            return;
        }
        int size = wfs.size();
        OrderingDescriptor.processOthers(wfs);
        OrderingDescriptor.enhanceOrderingData(wfs);
        WebFragmentDescriptor[] wfarr = wfs.toArray(new WebFragmentDescriptor[size]);
        int maxSwap = (size + 1) * size + 1;
        int numSwap = 0;
        boolean swap = false;
        boolean startCheck = false;
        int k = -1;
        while (numSwap < maxSwap) {
            if (swap) {
                k = 0;
                swap = false;
                startCheck = false;
            } else {
                ++k;
                if (startCheck) break;
                if (k == size - 1) {
                    k = 0;
                    startCheck = true;
                }
            }
            int i = 1;
            while (i < size - k) {
                if (OrderingDescriptor.isAfter(wfarr[k], wfarr[k + i])) {
                    int j;
                    WebFragmentDescriptor temp;
                    OrderingDescriptor od = wfarr[k + i].getOrderingDescriptor();
                    if (od != null && od.getAfter() != null && od.getAfter().containsOthers()) {
                        temp = wfarr[k];
                        for (j = 0; j < i; ++j) {
                            wfarr[k + j] = wfarr[k + j + 1];
                        }
                        wfarr[k + i] = temp;
                    } else {
                        temp = wfarr[k + i];
                        for (j = k + i; j > k; --j) {
                            wfarr[j] = wfarr[j - 1];
                        }
                        wfarr[k] = temp;
                        ++k;
                    }
                    ++numSwap;
                    swap = true;
                    continue;
                }
                ++i;
            }
        }
        if (numSwap >= maxSwap) {
            throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioninvalidwebfragmentordering", "The web fragment ordering is not valid and possibly has cycling conflicts."));
        }
        if (wfs != null && wfs.size() > 1) {
            wfs.clear();
            for (WebFragmentDescriptor wf : wfarr) {
                wfs.add(wf);
            }
        }
    }

    private static void processOthers(List<WebFragmentDescriptor> wfs) {
        int i = 0;
        int beforeOthersInd = 0;
        int afterOthersInd = wfs.size();
        while (i < afterOthersInd) {
            WebFragmentDescriptor wf = wfs.get(i);
            OrderingDescriptor od = wf.getOrderingDescriptor();
            if (od != null && od.getBefore() != null && od.getBefore().containsOthers()) {
                if (i > 0) {
                    wfs.remove(i);
                    wfs.add(beforeOthersInd, wf);
                }
                ++beforeOthersInd;
                ++i;
                continue;
            }
            if (i < afterOthersInd - 1 && od != null && od.getAfter() != null && od.getAfter().containsOthers()) {
                wfs.remove(i);
                wfs.add(wf);
                --afterOthersInd;
                continue;
            }
            ++i;
        }
    }

    private static void enhanceOrderingData(List<WebFragmentDescriptor> wfs) {
        TreeMap<String, WebFragmentDescriptor> name2WfMap = new TreeMap<String, WebFragmentDescriptor>();
        for (WebFragmentDescriptor wf : wfs) {
            String name = wf.getName();
            if (name == null || name.length() <= 0) continue;
            name2WfMap.put(name, wf);
        }
        for (WebFragmentDescriptor wf : wfs) {
            String[] afterNames;
            OrderingOrderingDescriptor after;
            OrderingOrderingDescriptor otherBefore;
            String wfName = wf.getName();
            OrderingDescriptor od = wf.getOrderingDescriptor();
            if (od == null || wfName == null || wfName.length() <= 0) continue;
            OrderingOrderingDescriptor before = od.getBefore();
            if (before != null) {
                String[] beforeNames;
                Set<String> beforeNamesSet = before.getNames();
                for (String beforeName : beforeNames = beforeNamesSet.toArray(new String[beforeNamesSet.size()])) {
                    OrderingOrderingDescriptor otherAfter;
                    WebFragmentDescriptor otherWf = (WebFragmentDescriptor)name2WfMap.get(beforeName);
                    OrderingDescriptor otherOd = otherWf.getOrderingDescriptor();
                    if (otherOd == null) {
                        otherOd = new OrderingDescriptor();
                        otherWf.setOrderingDescriptor(otherOd);
                    }
                    if ((otherAfter = otherOd.getAfter()) == null) {
                        otherAfter = new OrderingOrderingDescriptor();
                        otherOd.setAfter(otherAfter);
                    }
                    otherAfter.addName(wfName);
                    otherBefore = otherOd.getBefore();
                    if (otherBefore == null) continue;
                    before.getNames().addAll(otherBefore.getNames());
                    if (!otherBefore.containsName(wfName)) continue;
                    throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioncyclicdependenyinwebfragmentordering", "There is a cyclic dependencies on name [{0}] in web fragment relative ordering.", new Object[]{wfName}));
                }
            }
            if ((after = od.getAfter()) == null) continue;
            Set<String> afterNamesSet = after.getNames();
            for (String afterName : afterNames = afterNamesSet.toArray(new String[afterNamesSet.size()])) {
                WebFragmentDescriptor otherWf = (WebFragmentDescriptor)name2WfMap.get(afterName);
                OrderingDescriptor otherOd = otherWf.getOrderingDescriptor();
                if (otherOd == null) {
                    otherOd = new OrderingDescriptor();
                    otherWf.setOrderingDescriptor(otherOd);
                }
                if ((otherBefore = otherOd.getBefore()) == null) {
                    otherBefore = new OrderingOrderingDescriptor();
                    otherOd.setBefore(otherBefore);
                }
                otherBefore.addName(wfName);
                OrderingOrderingDescriptor otherAfter = otherOd.getAfter();
                if (otherAfter == null) continue;
                after.getNames().addAll(otherAfter.getNames());
                if (!otherAfter.containsName(wfName)) continue;
                throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.exceptioncyclicdependenyinwebfragmentordering", "There is a cyclic dependencies for name [{0}] in web fragment relative ordering.", new Object[]{wfName}));
            }
        }
    }

    private static boolean isAfter(WebFragmentDescriptor wf1, WebFragmentDescriptor wf2) {
        String name1 = wf1.getName();
        String name2 = wf2.getName();
        OrderingDescriptor od1 = wf1.getOrderingDescriptor();
        OrderingDescriptor od2 = wf2.getOrderingDescriptor();
        return od1 != null && od1.getAfter() != null && od1.getAfter().containsName(name2) || od2 != null && od2.getBefore() != null && od2.getBefore().containsName(name1);
    }
}

