/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarInputStreamURLArchive
implements Archive {
    private URL url;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public JarInputStreamURLArchive(URL uRL) throws IOException {
        this(uRL, Logger.global);
    }

    public JarInputStreamURLArchive(URL uRL, Logger logger) throws IOException {
        logger.entering("JarInputStreamURLArchive", "JarInputStreamURLArchive", new Object[]{uRL});
        this.logger = logger;
        this.url = uRL;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(this.url.openStream()));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = jarInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                this.entries.add(zipEntry.getName());
            }
        }
        finally {
            jarInputStream.close();
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String string) throws IOException {
        ZipEntry zipEntry;
        if (!this.entries.contains(string)) {
            return null;
        }
        JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(this.url.openStream()));
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(string)) continue;
            return jarInputStream;
        }
        assert (false);
        return null;
    }

    @Override
    public URL getEntryAsURL(String string) throws IOException {
        URL uRL;
        uRL = this.entries.contains(string) ? (uRL = new URL("jar:" + this.url + "!/" + string)) : null;
        return uRL;
    }

    @Override
    public URL getRootURL() {
        return this.url;
    }
}

