/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEPersistenceUnitInfo
implements PersistenceUnitInfo {
    protected String persistenceUnitName;
    protected String persistenceProviderClassName;
    protected DataSource jtaDataSource;
    protected DataSource nonJtaDataSource;
    protected PersistenceUnitTransactionType persistenceUnitTransactionType;
    protected List<String> mappingFiles;
    private Collection<String> jarFiles = new ArrayList<String>();
    protected List<URL> jarFileUrls;
    protected List<String> managedClassNames;
    protected URL persistenceUnitRootUrl;
    protected boolean excludeUnlistedClasses = true;
    protected Properties properties;
    protected ClassLoader tempClassLoader;
    protected ClassLoader realClassLoader;

    public SEPersistenceUnitInfo() {
        this.mappingFiles = new ArrayList<String>();
        this.managedClassNames = new ArrayList<String>();
        this.properties = new Properties();
        this.persistenceUnitTransactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String string) {
        this.persistenceUnitName = string;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setPersistenceProviderClassName(String string) {
        this.persistenceProviderClassName = string;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.persistenceUnitTransactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType persistenceUnitTransactionType) {
        this.persistenceUnitTransactionType = persistenceUnitTransactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource dataSource) {
        this.jtaDataSource = dataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource dataSource) {
        this.nonJtaDataSource = dataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFiles;
    }

    public void setMappingFileNames(List<String> list) {
        this.mappingFiles = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getJarFileUrls() {
        if (this.jarFileUrls == null) {
            ArrayList<URL> arrayList = new ArrayList<URL>(this.jarFiles.size());
            for (String string : this.jarFiles) {
                try {
                    URL uRL = new URL(this.persistenceUnitRootUrl, string);
                    arrayList.add(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }
            SEPersistenceUnitInfo sEPersistenceUnitInfo = this;
            synchronized (sEPersistenceUnitInfo) {
                this.jarFileUrls = arrayList;
            }
        }
        return Collections.unmodifiableList(this.jarFileUrls);
    }

    public void setJarFileUrls(List<URL> list) {
        this.jarFileUrls = list;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setPersistenceUnitRootUrl(URL uRL) {
        this.persistenceUnitRootUrl = uRL;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void setManagedClassNames(List<String> list) {
        this.managedClassNames = list;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean bl) {
        this.excludeUnlistedClasses = bl;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ClassLoader getClassLoader() {
        return this.realClassLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return this.tempClassLoader;
    }

    public void setNewTempClassLoader(ClassLoader classLoader) {
        this.tempClassLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.realClassLoader = classLoader;
    }

    public Collection<String> getJarFiles() {
        return this.jarFiles;
    }
}

