/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class MetadataHelper {
    public static final String JPA_ORM_FILE = "META-INF/orm.xml";
    public static final String ECLIPSELINK_ORM_FILE = "META-INF/eclipselink-orm.xml";

    static Class getClassForName(String string, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.unableToLoadClass((String)string, (Exception)privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName((String)string, (boolean)true, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.unableToLoadClass((String)string, (Exception)classNotFoundException);
        }
    }

    static Object getClassInstance(Class clazz) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.errorInstantiatingClass((Class)clazz, (Exception)privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass((Class)clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ValidationException.errorInstantiatingClass((Class)clazz, (Exception)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw ValidationException.errorInstantiatingClass((Class)clazz, (Exception)instantiationException);
        }
    }

    static Object getClassInstance(String string, ClassLoader classLoader) {
        return MetadataHelper.getClassInstance(MetadataHelper.getClassForName(string, classLoader));
    }

    public static String getName(String string, String string2, String string3, MetadataLogger metadataLogger, Object object) {
        if (string != null && !string.equals("")) {
            return string;
        }
        if (string2 == null || string2.equals("")) {
            return "";
        }
        metadataLogger.logConfigMessage(string3, object, (Object)string2);
        return string2;
    }

    public static Integer getValue(Integer n, Integer n2) {
        if (n == null) {
            return n2;
        }
        return n;
    }

    public static String getValue(String string, String string2) {
        if (string != null && !string.equals("")) {
            return string;
        }
        return string2;
    }

    static Object invokeMethod(String string, Object object) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(object.getClass(), (String)string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)object, (Exception)noSuchMethodException);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)object);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)object, (Exception)exception);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)method, (Object)object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)object, (Exception)invocationTargetException);
            }
        }
        return null;
    }
}

