/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAccessor
extends MappingAccessor {
    private List<AssociationOverrideMetadata> m_associationOverrides;
    private List<AttributeOverrideMetadata> m_attributeOverrides;

    public EmbeddedAccessor() {
        super("<embedded>");
    }

    protected EmbeddedAccessor(String string) {
        super(string);
    }

    public EmbeddedAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object t;
        Object object;
        this.m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        Object t2 = this.getAnnotation(AttributeOverrides.class);
        if (t2 != null) {
            object = (Annotation[])MetadataHelper.invokeMethod("value", t2);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                Object t3 = object[i];
                this.m_attributeOverrides.add(new AttributeOverrideMetadata((Annotation)t3, metadataAccessibleObject));
            }
        }
        if ((object = this.getAnnotation(AttributeOverride.class)) != null) {
            this.m_attributeOverrides.add(new AttributeOverrideMetadata((Annotation)object, metadataAccessibleObject));
        }
        this.m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
        Object t4 = this.getAnnotation(AssociationOverrides.class);
        if (t4 != null) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", t4)) {
                this.m_associationOverrides.add(new AssociationOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if ((t = this.getAnnotation(AssociationOverride.class)) != null) {
            this.m_associationOverrides.add(new AssociationOverrideMetadata((Annotation)t, metadataAccessibleObject));
        }
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_associationOverrides, metadataAccessibleObject);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void process() {
        AggregateObjectMapping aggregateObjectMapping = new AggregateObjectMapping();
        aggregateObjectMapping.setIsReadOnly(false);
        aggregateObjectMapping.setIsNullAllowed(true);
        aggregateObjectMapping.setReferenceClassName(this.getReferenceClassName());
        aggregateObjectMapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods((DatabaseMapping)aggregateObjectMapping);
        this.processAttributeOverrides(aggregateObjectMapping);
        this.processAssociationOverrides((EmbeddableMapping)aggregateObjectMapping);
        this.processReturnInsertAndUpdate();
        this.addMapping((DatabaseMapping)aggregateObjectMapping);
    }

    protected void processAssociationOverrides(EmbeddableMapping embeddableMapping) {
        for (AssociationOverrideMetadata associationOverrideMetadata : this.processAssociationOverrides(this.m_associationOverrides).values()) {
            this.processAssociationOverride(associationOverrideMetadata, embeddableMapping, this.getReferenceDescriptor().getMappingForAttributeName(associationOverrideMetadata.getName()), this.getOwningDescriptor().getPrimaryTable(), this.getReferenceDescriptor());
        }
    }

    protected void processAttributeOverrides(AggregateObjectMapping aggregateObjectMapping) {
        for (AttributeOverrideMetadata attributeOverrideMetadata : this.processAttributeOverrides(this.m_attributeOverrides).values()) {
            String string = attributeOverrideMetadata.getName();
            DatabaseMapping databaseMapping = this.getReferenceDescriptor().getMappingForAttributeName(string);
            if (databaseMapping == null) {
                throw ValidationException.embeddableAttributeOverrideNotFound((Class)this.getReferenceDescriptor().getJavaClass(), (String)string, (Class)this.getJavaClass(), (String)this.getAttributeName());
            }
            if (!databaseMapping.isDirectToFieldMapping()) {
                throw ValidationException.invalidEmbeddableAttributeForAttributeOverride((Class)this.getReferenceDescriptor().getJavaClass(), (String)string, (Class)this.getJavaClass(), (String)this.getAttributeName());
            }
            this.addFieldNameTranslation((EmbeddableMapping)aggregateObjectMapping, string, attributeOverrideMetadata.getColumn().getDatabaseField(), databaseMapping);
        }
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> list) {
        this.m_associationOverrides = list;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_attributeOverrides = list;
    }
}

