/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.EntityResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ColumnResult;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.FieldResult;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLResultSetMappingMetadata
extends ORMetadata {
    private List<String> m_columnResults = new ArrayList<String>();
    private List<EntityResultMetadata> m_entityResults = new ArrayList<EntityResultMetadata>();
    private String m_name;

    public SQLResultSetMappingMetadata() {
        super("<sql-result-set-mapping>");
    }

    public SQLResultSetMappingMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("entities", annotation)) {
            this.m_entityResults.add(new EntityResultMetadata(annotation2, metadataAccessibleObject));
        }
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("columns", annotation)) {
            this.m_columnResults.add((String)MetadataHelper.invokeMethod("name", annotation2));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SQLResultSetMappingMetadata) {
            SQLResultSetMappingMetadata sQLResultSetMappingMetadata = (SQLResultSetMappingMetadata)object;
            if (!this.valuesMatch(this.m_name, sQLResultSetMappingMetadata.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnResults, sQLResultSetMappingMetadata.getColumnResults())) {
                return false;
            }
            return this.valuesMatch(this.m_entityResults, sQLResultSetMappingMetadata.getEntityResults());
        }
        return false;
    }

    public List<String> getColumnResults() {
        return this.m_columnResults;
    }

    public List<EntityResultMetadata> getEntityResults() {
        return this.m_entityResults;
    }

    @Override
    public String getIdentifier() {
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_entityResults, metadataAccessibleObject);
    }

    public void process(AbstractSession abstractSession, ClassLoader classLoader) {
        SQLResultSetMapping sQLResultSetMapping = new SQLResultSetMapping(this.getName());
        for (EntityResultMetadata object : this.m_entityResults) {
            EntityResult entityResult = new EntityResult(MetadataHelper.getClassForName(object.getEntityClass().getName(), classLoader));
            if (object.hasFieldResults()) {
                for (FieldResultMetadata fieldResultMetadata : object.getFieldResults()) {
                    entityResult.addFieldResult(new FieldResult(fieldResultMetadata.getName(), fieldResultMetadata.getColumn()));
                }
            }
            entityResult.setDiscriminatorColumn(object.getDiscriminatorColumn());
            sQLResultSetMapping.addResult((SQLResult)entityResult);
        }
        for (String string : this.m_columnResults) {
            sQLResultSetMapping.addResult((SQLResult)new ColumnResult(string));
        }
        abstractSession.getProject().addSQLResultSetMapping(sQLResultSetMapping);
    }

    protected void setColumnResults(List<String> list) {
        this.m_columnResults = list;
    }

    public void setEntityResults(List<EntityResultMetadata> list) {
        this.m_entityResults = list;
    }

    public void setName(String string) {
        this.m_name = string;
    }
}

