/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.stats;

import com.sun.ejb.base.stats.StatsImpl;
import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;
import com.sun.enterprise.admin.monitor.stats.AverageRangeStatistic;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableAverageRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StatefulSessionStoreStats;
import org.glassfish.j2ee.statistics.BoundedRangeStatistic;
import org.glassfish.j2ee.statistics.CountStatistic;
import org.glassfish.j2ee.statistics.RangeStatistic;

public class StatefulSessionStoreStatsImpl
extends StatsImpl
implements StatefulSessionStoreStats {
    private MonitorableSFSBStoreManager provider;
    private MutableBoundedRangeStatisticImpl currentSize;
    private MutableCountStatisticImpl activationCount;
    private MutableCountStatisticImpl activationSuccessCount;
    private MutableCountStatisticImpl activationErrorCount;
    private MutableCountStatisticImpl passivationCount;
    private MutableCountStatisticImpl passivationSuccessCount;
    private MutableCountStatisticImpl passivationErrorCount;
    private MutableCountStatisticImpl expiredSessionCount;
    private MutableAverageRangeStatisticImpl activationSize;
    private MutableAverageRangeStatisticImpl activationTime;
    private MutableAverageRangeStatisticImpl passivationSize;
    private MutableAverageRangeStatisticImpl passivationTime;
    private Object currentSizeLock = new Object();
    private Object activationCountLock = new Object();
    private Object activationSizeLock = new Object();
    private Object activationTimeLock = new Object();
    private Object passivationCountLock = new Object();
    private Object passivationSizeLock = new Object();
    private Object passivationTimeLock = new Object();
    private Object expiredSessionCountLock = new Object();
    private long activationCountVal;
    private long activationSuccessCountVal;
    private long activationErrorCountVal;
    private long passivationCountVal;
    private long passivationSuccessCountVal;
    private long passivationErrorCountVal;
    private long expiredSessionCountVal;

    public StatefulSessionStoreStatsImpl(MonitorableSFSBStoreManager provider) {
        this.provider = provider;
        super.initialize("com.sun.enterprise.admin.monitor.stats.StatefulSessionStoreStats");
        this.initialize();
    }

    protected StatefulSessionStoreStatsImpl(MonitorableSFSBStoreManager provider, String intfName) {
        this.provider = provider;
        super.initialize(intfName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        long now = System.currentTimeMillis();
        Object object = this.currentSizeLock;
        synchronized (object) {
            this.currentSize = new MutableBoundedRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L, "CurrentSize", "bytes", "Number of sessions in store", now, now));
        }
        object = this.activationCountLock;
        synchronized (object) {
            this.activationCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ActivationCount"));
            this.activationSuccessCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ActivationSuccessCount"));
            this.activationErrorCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ActivationErrorCount"));
        }
        object = this.activationSizeLock;
        synchronized (object) {
            this.activationSize = new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L, "ActivationSize", "bytes", "Number of bytes activated", now, now));
        }
        object = this.passivationSizeLock;
        synchronized (object) {
            this.passivationSize = new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L, "PassivationSize", "bytes", "Number of bytes passivated", now, now));
        }
        object = this.passivationCountLock;
        synchronized (object) {
            this.passivationCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("PassivationCount"));
            this.passivationSuccessCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("PassivationSuccessCount"));
            this.passivationErrorCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("PassivationErrorCount"));
        }
        object = this.expiredSessionCountLock;
        synchronized (object) {
            this.expiredSessionCount = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ExpiredSessionCount"));
        }
        object = this.activationTimeLock;
        synchronized (object) {
            this.activationTime = new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L, "ActivationTime", "millis", "Time spent on activation", now, now));
        }
        object = this.passivationTimeLock;
        synchronized (object) {
            this.passivationTime = new MutableAverageRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L, "PassivationTime", "millis", "Time spent on passivation", now, now));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangeStatistic getCurrentSize() {
        Object object = this.currentSizeLock;
        synchronized (object) {
            this.currentSize.setCount(this.provider.getCurrentStoreSize());
            return (RangeStatistic)this.currentSize.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getActivationCount() {
        Object object = this.activationCountLock;
        synchronized (object) {
            this.activationCount.setCount(this.activationCountVal);
            return (CountStatistic)this.activationCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getActivationSuccessCount() {
        Object object = this.activationCountLock;
        synchronized (object) {
            this.activationSuccessCount.setCount(this.activationSuccessCountVal);
            return (CountStatistic)this.activationSuccessCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getActivationErrorCount() {
        Object object = this.activationCountLock;
        synchronized (object) {
            this.activationErrorCount.setCount(this.activationErrorCountVal);
            return (CountStatistic)this.activationErrorCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getPassivationCount() {
        Object object = this.passivationCountLock;
        synchronized (object) {
            this.passivationCount.setCount(this.passivationCountVal);
            return (CountStatistic)this.passivationSuccessCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getPassivationSuccessCount() {
        Object object = this.passivationCountLock;
        synchronized (object) {
            this.passivationSuccessCount.setCount(this.passivationSuccessCountVal);
            return (CountStatistic)this.passivationSuccessCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getPassivationErrorCount() {
        Object object = this.passivationCountLock;
        synchronized (object) {
            this.passivationErrorCount.setCount(this.passivationErrorCountVal);
            return (CountStatistic)this.passivationSuccessCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStatistic getExpiredSessionCount() {
        Object object = this.expiredSessionCountLock;
        synchronized (object) {
            this.expiredSessionCount.setCount(this.expiredSessionCountVal);
            return (CountStatistic)this.expiredSessionCount.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageRangeStatistic getActivatedBeanSize() {
        Object object = this.activationSizeLock;
        synchronized (object) {
            return (AverageRangeStatistic)this.activationSize.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageRangeStatistic getActivationTime() {
        Object object = this.activationTimeLock;
        synchronized (object) {
            return (AverageRangeStatistic)this.activationTime.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageRangeStatistic getPassivatedBeanSize() {
        Object object = this.passivationSizeLock;
        synchronized (object) {
            return (AverageRangeStatistic)this.passivationSize.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AverageRangeStatistic getPassivationTime() {
        Object object = this.passivationTimeLock;
        synchronized (object) {
            return (AverageRangeStatistic)this.passivationTime.unmodifiableView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementActivationCount(boolean success) {
        Object object = this.activationCountLock;
        synchronized (object) {
            ++this.activationCountVal;
            if (success) {
                ++this.activationSuccessCountVal;
            } else {
                ++this.activationErrorCountVal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementPassivationCount(boolean success) {
        Object object = this.passivationCountLock;
        synchronized (object) {
            ++this.passivationCountVal;
            if (success) {
                ++this.passivationSuccessCountVal;
            } else {
                ++this.passivationErrorCountVal;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActivationSize(long val) {
        Object object = this.activationSizeLock;
        synchronized (object) {
            this.activationSize.setCount(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActivationTime(long val) {
        Object object = this.activationTimeLock;
        synchronized (object) {
            this.activationTime.setCount(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPassivationSize(long val) {
        Object object = this.passivationSizeLock;
        synchronized (object) {
            this.passivationSize.setCount(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPassivationTime(long val) {
        Object object = this.passivationTimeLock;
        synchronized (object) {
            this.passivationTime.setCount(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementExpiredSessionCountVal(long val) {
        Object object = this.expiredSessionCountLock;
        synchronized (object) {
            this.expiredSessionCountVal += val;
        }
    }

    protected void appendStats(StringBuffer sbuf) {
        sbuf.append("currentSize=").append(this.provider.getCurrentStoreSize()).append("; ").append("ActivationCount=").append(this.activationCountVal).append("; ").append("ActivationSuccessCount=").append(this.activationSuccessCountVal).append("; ").append("ActivationErrorCount=").append(this.activationErrorCountVal).append("; ").append("PassivationCount=").append(this.passivationCountVal).append("; ").append("PassivationSuccessCount=").append(this.passivationSuccessCountVal).append("; ").append("PassivationErrorCount=").append(this.passivationErrorCountVal).append("; ").append("ExpiredSessionsRemoved=").append(this.expiredSessionCountVal).append("; ");
        StatefulSessionStoreStatsImpl.appendTimeStatistic(sbuf, "ActivationSize", this.activationSize);
        StatefulSessionStoreStatsImpl.appendTimeStatistic(sbuf, "ActivationTime", this.activationTime);
        StatefulSessionStoreStatsImpl.appendTimeStatistic(sbuf, "PassivationSize", this.passivationSize);
        StatefulSessionStoreStatsImpl.appendTimeStatistic(sbuf, "PassivationTime", this.passivationTime);
    }

    protected static void appendTimeStatistic(StringBuffer sbuf, String name, MutableAverageRangeStatisticImpl stat) {
        sbuf.append(name).append("(").append("min=").append(stat.getLowWaterMark()).append(", ").append("max=").append(stat.getHighWaterMark()).append(", ").append("avg=").append(stat.getAverage()).append("); ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumExpiredSessionCount() {
        Object object = this.expiredSessionCountLock;
        synchronized (object) {
            return (int)this.expiredSessionCountVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumPassivationCount() {
        Object object = this.passivationCountLock;
        synchronized (object) {
            return (int)this.passivationCountVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumPassivationSuccessCount() {
        Object object = this.passivationCountLock;
        synchronized (object) {
            return (int)this.passivationSuccessCountVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumPassivationErrorCount() {
        Object object = this.passivationCountLock;
        synchronized (object) {
            return (int)this.passivationErrorCountVal;
        }
    }
}

