/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandModel {
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";

    public abstract String getCommandName();

    public abstract I18n getI18n();

    public abstract ParamModel getModelFor(String var1);

    public abstract Collection<String> getParametersNames();

    public Collection<ParamModel> getParameters() {
        ArrayList<ParamModel> copy = new ArrayList<ParamModel>();
        for (String name : this.getParametersNames()) {
            copy.add(this.getModelFor(name));
        }
        return copy;
    }

    public String getParamName(Param param, AnnotatedElement annotated) {
        if (param.name().equals("")) {
            if (annotated instanceof Field) {
                return ((Field)annotated).getName();
            }
            if (annotated instanceof Method) {
                return ((Method)annotated).getName().substring(3).toLowerCase();
            }
        } else {
            if (param.password()) {
                return ASADMIN_CMD_PREFIX + param.name().toUpperCase();
            }
            return param.name();
        }
        return "";
    }

    public boolean unknownOptionsAreOperands() {
        return false;
    }

    public abstract class ParamModel {
        public abstract String getName();

        public abstract Param getParam();

        public abstract I18n getI18n();

        public abstract Class getType();

        public boolean isParamId(String key) {
            if (this.getParam().primary()) {
                return "DEFAULT".equals(key) || this.getName().equals(key);
            }
            if (this.getParam().password()) {
                return key.startsWith(CommandModel.ASADMIN_CMD_PREFIX);
            }
            return this.getName().equals(key) || this.getParam().shortName().equals(key);
        }
    }
}

