/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandFactory;
import com.sun.enterprise.cli.framework.CommandLineParser;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandValidator;
import com.sun.enterprise.cli.framework.HelpException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.InvalidCommandException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.SearchCommands;
import com.sun.enterprise.cli.framework.StringEditDistance;
import com.sun.enterprise.cli.framework.ValidCommand;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIMain {
    private static final String HelpCommandAndOptions = "help|--help|-[?]";
    private static final String VERSION_OPTION = "-V";
    private static final String VERSION_COMMAND = "version";
    private static final int MAX_COMMANDS_TO_DISPLAY = 75;

    public static void invokeCLI(String cmdline, InputsAndOutputs io) throws CommandException, CommandValidationException, InvalidCommandException {
        InputsAndOutputs.setInstance(io);
        String[] args = CLIMain.splitStringToArray(cmdline);
        new CLIMain().invokeCommand(args);
    }

    public static void main(String[] args) {
        long startTime = 0L;
        boolean time = false;
        if (System.getProperty("com.sun.appserv.cli.timing") != null) {
            time = true;
            startTime = System.currentTimeMillis();
        }
        try {
            new CLIMain().invokeCommand(args);
            if (time) {
                CLILogger.getInstance().printDebugMessage("Command execution time: " + (System.currentTimeMillis() - startTime) + " ms");
            }
            System.exit(0);
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.getLocalizedMessage());
            System.exit(1);
        }
    }

    public void invokeCommand(String[] args) throws CommandException, CommandValidationException, InvalidCommandException {
        this.invokeCommand(args, null);
    }

    public void invokeCommand(String[] args, Object caller) throws CommandException, CommandValidationException, InvalidCommandException {
        ValidCommand validCommand = null;
        try {
            CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
            if (args.length < 1) {
                cliDescriptorsReader.setSerializeDescriptorsProperty(0);
                validCommand = cliDescriptorsReader.getCommand(null);
                args = new String[]{cliDescriptorsReader.getDefaultCommand()};
            } else {
                if (args[0].equals(VERSION_OPTION)) {
                    args[0] = VERSION_COMMAND;
                }
                cliDescriptorsReader.setSerializeDescriptorsProperty(1);
                validCommand = cliDescriptorsReader.getCommand(args[0]);
            }
            this.setCommandLocalizedProperty(cliDescriptorsReader.getProperties());
            if (args[0].matches(HelpCommandAndOptions)) {
                throw new HelpException(args);
            }
            this.checkValidCommand(validCommand, args[0]);
            CommandLineParser clp = new CommandLineParser(args, validCommand);
            Command command = CommandFactory.createCommand(validCommand, clp.getOptionsMap(), clp.getOperands());
            new CommandValidator().validateCommandAndOptions(validCommand, command.getOptions(), command.getOperands());
            command.setCaller(caller);
            command.runCommand();
            return;
        }
        catch (HelpException he) {
            this.invokeHelpClass(he.getHelpClassName(), he.getCommandName(), he.getUsageText(), he.isShell());
        }
        catch (CommandValidationException cve) {
            throw new CommandValidationException(this.getUsageTextFromValidCommand(validCommand) + "\n" + cve.getLocalizedMessage());
        }
    }

    private void invokeHelpClass(String helpClassName, String helpCommandName, String commandUsageText, boolean isShell) throws InvalidCommandException {
        try {
            Command helpCommand = null;
            Class<?> helpClass = Class.forName(helpClassName);
            helpCommand = (Command)helpClass.newInstance();
            helpCommand.setName(helpCommandName);
            if (helpCommandName != null) {
                helpCommand.setOperands(new Vector<String>(Arrays.asList(helpCommandName)));
            }
            if (isShell) {
                helpCommand.setOption("isMultiMode", "true");
                String interactiveVal = (String)CommandEnvironment.getInstance().getEnvironments().get("interactive");
                helpCommand.setOption("interactive", interactiveVal == null ? "true" : interactiveVal);
            }
            helpCommand.runCommand();
        }
        catch (Exception e) {
            if (commandUsageText == null) {
                throw new InvalidCommandException(helpCommandName);
            }
            CLILogger.getInstance().printMessage(CLIMain.getLocalizedString("Usage", new Object[]{commandUsageText}));
        }
    }

    public static void displayClosestMatch(String commandName, Map<String, String> moreCommands, String msg) throws InvalidCommandException {
        block7: {
            try {
                int beginIndex = 0;
                int endIndex = commandName.length();
                if (commandName.startsWith("*")) {
                    beginIndex = 1;
                }
                if (commandName.endsWith("*")) {
                    endIndex = commandName.length() - 1;
                }
                String trimmedCommandName = commandName.substring(beginIndex, endIndex);
                String[] matchedCommands = SearchCommands.getMatchedCommands(".*" + trimmedCommandName + ".*", moreCommands);
                if (matchedCommands.length > 0 && matchedCommands.length < 75) {
                    System.out.println(msg == null ? CLIMain.getLocalizedString("ClosestMatchedCommands", null) : msg);
                    for (String eachCommand : matchedCommands) {
                        System.out.println("    " + eachCommand);
                    }
                    break block7;
                }
                String[] allCommands = SearchCommands.getAllCommands();
                String nearestString = StringEditDistance.findNearest(commandName, allCommands);
                if (StringEditDistance.editDistance(commandName, nearestString) < 5) {
                    System.out.println(msg == null ? CLIMain.getLocalizedString("ClosestMatchedCommands", null) : msg);
                    System.out.println("    " + nearestString);
                    break block7;
                }
                throw new InvalidCommandException(commandName);
            }
            catch (Exception e) {
                throw new InvalidCommandException(commandName);
            }
        }
    }

    private String getUsageTextFromValidCommand(ValidCommand validCommand) {
        if (validCommand != null && validCommand.getUsageText() != null) {
            return CLIMain.getLocalizedString("Usage", new Object[]{validCommand.getUsageText()});
        }
        return "";
    }

    private void checkValidCommand(ValidCommand validCommand, String commandName) throws InvalidCommandException, CommandException {
        if (validCommand == null) {
            throw new InvalidCommandException(commandName);
        }
    }

    private void setCommandLocalizedProperty(Iterator<Properties> localizePropertiesIter) throws CommandValidationException {
        LocalStringsManagerFactory.setCommandLocalStringsManagerProperties(localizePropertiesIter);
    }

    private static String getLocalizedString(String key, Object[] toInsert) {
        try {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            if (toInsert == null) {
                return lsm.getString(key);
            }
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return "Key not found";
        }
    }

    private static String[] splitStringToArray(String line) throws CommandException {
        CLITokenizer cliTokenizer = new CLITokenizer(line, " ");
        String[] strArray = new String[cliTokenizer.countTokens()];
        int ii = 0;
        while (cliTokenizer.hasMoreTokens()) {
            strArray[ii++] = cliTokenizer.nextTokenWithoutEscapeAndQuoteChars();
            CLILogger.getInstance().printDebugMessage("CLIToken = [" + strArray[ii - 1] + "]");
        }
        return strArray;
    }
}

