/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterTxnInquiryInfo {
    protected Logger logger = Globals.getLogger();
    private Long transactionID = null;
    private BrokerAddress txnhome = null;
    private Long replyXid = null;
    private GPacket pkt = null;

    private ClusterTxnInquiryInfo(Long l, BrokerAddress brokerAddress, Long l2) {
        this.transactionID = l;
        this.txnhome = brokerAddress;
        this.replyXid = l2;
    }

    private ClusterTxnInquiryInfo(GPacket gPacket) {
        this.pkt = gPacket;
    }

    public static ClusterTxnInquiryInfo newInstance(Long l, BrokerAddress brokerAddress, Long l2) {
        return new ClusterTxnInquiryInfo(l, brokerAddress, null);
    }

    public static ClusterTxnInquiryInfo newInstance(GPacket gPacket) {
        return new ClusterTxnInquiryInfo(gPacket);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)47);
        gPacket.putProp((Object)"transactionID", (Object)this.transactionID);
        gPacket.setBit(1, true);
        if (this.replyXid != null) {
            gPacket.putProp((Object)"X", (Object)this.replyXid);
        }
        if (this.txnhome != null) {
            gPacket.putProp((Object)"transactionHome", (Object)this.txnhome.toProtocolString());
        }
        return gPacket;
    }

    public Long getTransactionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"transactionID");
    }

    public BrokerAddress getTransactionHome() {
        assert (this.pkt != null);
        String string = (String)this.pkt.getProp((Object)"transactionHome");
        if (string == null) {
            return null;
        }
        try {
            return Globals.getMyAddress().fromProtocolString(string);
        }
        catch (Exception exception) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to get transaction home broker address for TID=" + this.getTransactionID() + ":" + exception.getMessage());
            return null;
        }
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public String toString() {
        if (this.pkt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\n\tTransactionID = ").append(this.transactionID);
            if (this.txnhome != null) {
                stringBuffer.append("\n\tTransactionHome = ").append(this.txnhome.toProtocolString());
            }
            if (this.replyXid != null) {
                stringBuffer.append("\n\tXID = ").append(this.replyXid);
            }
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getTransactionID() != null) {
            stringBuffer.append("\n\tTransactionID = ").append(this.getTransactionID());
        }
        if (this.pkt.getProp((Object)"transactionHome") != null) {
            stringBuffer.append("\n\tTransactionHome = ").append((String)this.pkt.getProp((Object)"transactionHome"));
        }
        if (this.pkt.getProp((Object)"X") != null) {
            stringBuffer.append("\n\tXID = ").append(this.pkt.getProp((Object)"X"));
        }
        return stringBuffer.toString();
    }
}

