/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDROutputStreamBase;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;

public class IDLJavaSerializationOutputStream
extends CDROutputStreamBase {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private ByteBuffer byteBuffer;
    private IDLObjectOutputStream os;
    private IDLByteArrayOutputStream bos;
    private BufferManagerWrite bufferManager;
    private boolean directWrite;
    private boolean useDirectByteBuffer;
    private ByteBuffer pooledByteBuffer;
    static final int DIRECT_RW_LENGTH = 16;
    private boolean debug;
    protected ORBUtilSystemException wrapper;
    private static final List<IDLByteArrayOutputStream> outputStreamPool = new LinkedList<IDLByteArrayOutputStream>();

    void printBuffer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    IDLJavaSerializationOutputStream(boolean directWrite) {
        this.directWrite = directWrite;
    }

    @Override
    public void init(ORB orb, boolean littleEndian, BufferManagerWrite bufferManager, byte streamFormatVersion, boolean useDirectByteBuffer) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
        this.bufferManager = bufferManager;
        this.bos = IDLJavaSerializationOutputStream.getOrCreateByteArrayOutputStream(this.orb);
        this.wrapper = ((com.sun.corba.ee.spi.orb.ORB)orb).getLogWrapperTable().get_RPC_ENCODING_ORBUtil();
        if (!this.directWrite) {
            this.initObjectOutputStream();
        }
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.debug = ((com.sun.corba.ee.spi.orb.ORB)orb).transportDebugFlag;
        if (this.debug) {
            ORBUtility.dprint(this, "IDLJavaSerializationOutputStream init");
        }
    }

    private static IDLByteArrayOutputStream getOrCreateByteArrayOutputStream(com.sun.corba.ee.spi.orb.ORB orb) {
        IDLByteArrayOutputStream bos = null;
        bos = IDLJavaSerializationOutputStream.getOutputStreamObjectFromPool();
        if (bos == null) {
            return new IDLByteArrayOutputStream(orb.getORBData().getGIOPBufferSize());
        }
        return bos;
    }

    private void initObjectOutputStream() {
        if (this.os != null) {
            throw this.wrapper.javaStreamInitFailed();
        }
        try {
            this.os = this.bos.getParent();
            if (this.os != null) {
                this.os.reset();
                this.os.setOrb(this.orb);
                return;
            }
            byte[] tmpArray = null;
            if (this.directWrite) {
                tmpArray = this.bos.toByteArray();
            }
            this.os = new IDLObjectOutputStream(this.bos, this.orb);
            this.os.flush();
            this.bos.reset(this.orb.getORBData().getGIOPBufferSize());
            if (this.directWrite) {
                this.bos.write(tmpArray, 0, tmpArray.length);
            }
            this.os.reset();
            this.bos.setParent(this.os);
        }
        catch (Exception e) {
            throw this.wrapper.javaStreamInitFailed(e);
        }
    }

    @Override
    public final void write_boolean(boolean value) {
        try {
            this.os.writeBoolean(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_boolean");
        }
    }

    @Override
    public final void write_char(char value) {
        try {
            this.os.writeChar(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_char");
        }
    }

    @Override
    public final void write_wchar(char value) {
        this.write_char(value);
    }

    @Override
    public final void write_octet(byte value) {
        try {
            if (this.directWrite && this.bos.size() < 16) {
                this.bos.write(value);
                if (this.bos.size() == 16) {
                    this.initObjectOutputStream();
                }
                return;
            }
            this.os.writeByte(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_octet");
        }
    }

    @Override
    public final void write_short(short value) {
        try {
            this.os.writeShort(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_short");
        }
    }

    @Override
    public final void write_ushort(short value) {
        this.write_short(value);
    }

    @Override
    public final void write_long(int value) {
        try {
            if (this.directWrite && this.bos.size() < 16) {
                this.bos.write((byte)(value >>> 24 & 0xFF));
                this.bos.write((byte)(value >>> 16 & 0xFF));
                this.bos.write((byte)(value >>> 8 & 0xFF));
                this.bos.write((byte)(value >>> 0 & 0xFF));
                if (this.bos.size() == 16) {
                    this.initObjectOutputStream();
                } else if (this.bos.size() > 16) {
                    this.wrapper.javaSerializationException("write_long");
                }
                return;
            }
            this.os.writeInt(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_long");
        }
    }

    @Override
    public final void write_ulong(int value) {
        this.write_long(value);
    }

    @Override
    public final void write_longlong(long value) {
        try {
            this.os.writeLong(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_longlong");
        }
    }

    @Override
    public final void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    @Override
    public final void write_float(float value) {
        try {
            this.os.writeFloat(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_float");
        }
    }

    @Override
    public final void write_double(double value) {
        try {
            this.os.writeDouble(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_double");
        }
    }

    @Override
    public final void write_string(String value) {
        try {
            this.os.writeUTF(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_string");
        }
    }

    @Override
    public final void write_wstring(String value) {
        try {
            this.os.writeObject(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_wstring");
        }
    }

    @Override
    public final void write_boolean_array(boolean[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_boolean(value[offset + i]);
        }
    }

    @Override
    public final void write_char_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_char(value[offset + i]);
        }
    }

    @Override
    public final void write_wchar_array(char[] value, int offset, int length) {
        this.write_char_array(value, offset, length);
    }

    @Override
    public final void write_octet_array(byte[] value, int offset, int length) {
        try {
            this.os.write(value, offset, length);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_octet_array");
        }
    }

    @Override
    public final void write_short_array(short[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_short(value[offset + i]);
        }
    }

    @Override
    public final void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    @Override
    public final void write_long_array(int[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_long(value[offset + i]);
        }
    }

    @Override
    public final void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    @Override
    public final void write_longlong_array(long[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_longlong(value[offset + i]);
        }
    }

    @Override
    public final void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    @Override
    public final void write_float_array(float[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_float(value[offset + i]);
        }
    }

    @Override
    public final void write_double_array(double[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_double(value[offset + i]);
        }
    }

    @Override
    public final void write_Object(Object value) {
        if (value == null) {
            IOR nullIOR = IORFactories.makeIOR(this.orb);
            nullIOR.write(this.parent);
            return;
        }
        if (value instanceof LocalObject) {
            throw this.wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
        }
        IOR ior = this.orb.getIOR(value, true);
        ior.write(this.parent);
    }

    @Override
    public final void write_TypeCode(TypeCode tc) {
        if (tc == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl tci = tc instanceof TypeCodeImpl ? (TypeCodeImpl)tc : new TypeCodeImpl(this.orb, tc);
        tci.write_value(this.parent);
    }

    @Override
    public final void write_any(Any any) {
        if (any == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this.parent);
    }

    @Override
    public final void write_Principal(Principal p) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final void write_fixed(BigDecimal bigDecimal) {
        this.write_value(bigDecimal);
    }

    @Override
    public final ORB orb() {
        return this.orb;
    }

    @Override
    public final void write_value(Serializable value) {
        this.write_value(value, (String)null);
    }

    @Override
    public final void write_value(Serializable value, Class clz) {
        this.write_value(value);
    }

    @Override
    public final void write_value(Serializable value, String repository_id) {
        try {
            this.os.writeObject(value);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_value");
        }
    }

    @Override
    public final void write_value(Serializable value, BoxedValueHelper factory) {
        this.write_value(value, (String)null);
    }

    @Override
    public final void write_abstract_interface(java.lang.Object obj) {
        boolean isCorbaObject = false;
        Object theCorbaObject = null;
        if (obj != null && obj instanceof Object) {
            theCorbaObject = (Object)obj;
            isCorbaObject = true;
        }
        this.write_boolean(isCorbaObject);
        if (isCorbaObject) {
            this.write_Object(theCorbaObject);
        } else {
            try {
                this.write_value((Serializable)obj);
            }
            catch (ClassCastException cce) {
                if (obj instanceof Serializable) {
                    throw cce;
                }
                ORBUtility.throwNotSerializableForCorba(obj.getClass().getName());
            }
        }
    }

    @Override
    public final void start_block() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final void end_block() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final void putEndian() {
        this.write_boolean(false);
    }

    @Override
    public void writeTo(OutputStream s) throws IOException {
        try {
            this.os.flush();
            this.bos.writeTo(s);
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"writeTo");
        }
    }

    @Override
    public final byte[] toByteArray() {
        try {
            this.os.flush();
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"toByteArray");
        }
        return this.bos.toByteArray();
    }

    @Override
    public final void write_Abstract(java.lang.Object value) {
        this.write_abstract_interface(value);
    }

    @Override
    public final void write_Value(Serializable value) {
        this.write_value(value);
    }

    @Override
    public final void write_any_array(Any[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_any(value[offset + i]);
        }
    }

    @Override
    public final String[] _truncatable_ids() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final int getSize() {
        try {
            this.os.flush();
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"write_boolean");
        }
        return this.bos.size();
    }

    @Override
    public final int getIndex() {
        return this.getSize();
    }

    protected int getRealIndex(int index) {
        return this.getSize();
    }

    @Override
    public final void setIndex(int value) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final ByteBuffer getByteBuffer() {
        ByteBufferWithInfo bbwi = this.getByteBufferWithInfo();
        return bbwi.getByteBuffer();
    }

    @Override
    public final void setByteBuffer(ByteBuffer byteBuffer) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final boolean isLittleEndian() {
        return false;
    }

    @Override
    public ByteBufferWithInfo getByteBufferWithInfo() {
        ByteBuffer byteBuffer;
        try {
            this.os.flush();
        }
        catch (Exception e) {
            throw this.wrapper.javaSerializationException(e, (java.lang.Object)"getByteBufferWithInfo");
        }
        if (!this.directWrite || !this.useDirectByteBuffer) {
            byteBuffer = ByteBuffer.wrap(this.bos.toByteArray());
        } else {
            this.pooledByteBuffer = byteBuffer = this.orb.getByteBufferPool().getByteBuffer(this.bos.size());
            this.bos.writeTo(byteBuffer);
        }
        return new ByteBufferWithInfo((ORB)this.orb, byteBuffer, this.bos.size());
    }

    @Override
    public void setByteBufferWithInfo(ByteBufferWithInfo bbwi) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public final BufferManagerWrite getBufferManager() {
        return this.bufferManager;
    }

    @Override
    public final void write_fixed(BigDecimal bigDecimal, short digits, short scale) {
        String fractionPart;
        String integerPart;
        int dotIndex;
        String string = bigDecimal.toString();
        if (string.charAt(0) == '-' || string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if ((dotIndex = string.indexOf(46)) == -1) {
            integerPart = string;
            fractionPart = null;
        } else if (dotIndex == 0) {
            integerPart = null;
            fractionPart = string;
        } else {
            integerPart = string.substring(0, dotIndex);
            fractionPart = string.substring(dotIndex + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(digits);
        if (fractionPart != null) {
            stringBuffer.append(fractionPart);
        }
        while (stringBuffer.length() < scale) {
            stringBuffer.append('0');
        }
        if (integerPart != null) {
            stringBuffer.insert(0, integerPart);
        }
        while (stringBuffer.length() < digits) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    private void write_fixed(String string, int signum) {
        char ch;
        int i;
        int stringLength = string.length();
        byte doubleDigit = 0;
        int numDigits = 0;
        for (i = 0; i < stringLength; ++i) {
            ch = string.charAt(i);
            if (ch == '-' || ch == '+' || ch == '.') continue;
            ++numDigits;
        }
        for (i = 0; i < stringLength; ++i) {
            ch = string.charAt(i);
            if (ch == '-' || ch == '+' || ch == '.') continue;
            byte digit = (byte)Character.digit(ch, 10);
            if (digit == -1) {
                throw this.wrapper.badDigitInFixed(CompletionStatus.COMPLETED_MAYBE);
            }
            if (numDigits % 2 == 0) {
                doubleDigit = (byte)(doubleDigit | digit);
                this.write_octet(doubleDigit);
                doubleDigit = 0;
            } else {
                doubleDigit = (byte)(doubleDigit | digit << 4);
            }
            --numDigits;
        }
        doubleDigit = signum == -1 ? (byte)((byte)(doubleDigit | 0xD)) : (byte)((byte)(doubleDigit | 0xC));
        this.write_octet(doubleDigit);
    }

    @Override
    public final void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream s) {
        this.bos.writeTo(s);
    }

    @Override
    public final GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    @Override
    public final void writeIndirection(int tag, int posIndirectedTo) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    void freeInternalCaches() {
    }

    @Override
    public void alignOnBoundary(int octetBoundary) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void setHeaderPadding(boolean headerPadding) {
    }

    @Override
    public void start_value(String rep_id) {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void end_value() {
        throw this.wrapper.giopVersionError();
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.bos == null) {
            return;
        }
        if (this.pooledByteBuffer != null) {
            this.orb.getByteBufferPool().releaseByteBuffer(this.pooledByteBuffer);
        }
        try {
            if (this.os != null) {
                this.os.flush();
            }
            this.bos.reset(this.orb.getORBData().getGIOPBufferSize());
        }
        catch (IOException e) {
            return;
        }
        IDLJavaSerializationOutputStream.putOutputStreamObjectToPool(this.bos);
        this.bos = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putOutputStreamObjectToPool(IDLByteArrayOutputStream value) {
        List<IDLByteArrayOutputStream> list = outputStreamPool;
        synchronized (list) {
            outputStreamPool.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDLByteArrayOutputStream getOutputStreamObjectFromPool() {
        List<IDLByteArrayOutputStream> list = outputStreamPool;
        synchronized (list) {
            if (outputStreamPool.size() != 0) {
                return outputStreamPool.remove(0);
            }
        }
        return null;
    }

    static final class IDLByteArrayOutputStream
    extends OutputStream {
        private byte[] buf;
        private LinkedList<byte[]> bufQ;
        private int index;
        private int count;
        private IDLObjectOutputStream parent;

        IDLByteArrayOutputStream(int capacity) {
            this.buf = new byte[capacity];
            this.bufQ = new LinkedList();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.index + len > this.buf.length) {
                int available = this.buf.length - this.index;
                System.arraycopy(b, off, this.buf, this.index, available);
                this.bufQ.addLast(this.buf);
                this.count += this.buf.length;
                this.buf = new byte[Math.max(this.buf.length << 1, len - available)];
                System.arraycopy(b, off + available, this.buf, 0, len - available);
                this.index = len - available;
            } else {
                System.arraycopy(b, off, this.buf, this.index, len);
                this.index += len;
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.index + 1 > this.buf.length) {
                this.bufQ.addLast(this.buf);
                this.count += this.buf.length;
                this.buf = new byte[this.buf.length << 1];
            }
            this.buf[this.index] = (byte)b;
            ++this.index;
        }

        int size() {
            return this.count + this.index;
        }

        void writeTo(ByteBuffer bb) {
            for (byte[] b : this.bufQ) {
                bb.put(b, 0, b.length);
            }
            bb.put(this.buf, 0, this.index);
        }

        void writeTo(OutputStream s) throws IOException {
            for (byte[] b : this.bufQ) {
                s.write(b, 0, b.length);
            }
            s.write(this.buf, 0, this.index);
        }

        void writeTo(org.omg.CORBA.portable.OutputStream s) {
            s.write_long(this.size());
            for (byte[] b : this.bufQ) {
                s.write_octet_array(b, 0, b.length);
            }
            s.write_octet_array(this.buf, 0, this.index);
        }

        byte[] toByteArray() {
            int off = 0;
            byte[] tmpBuf = new byte[this.size()];
            for (byte[] b : this.bufQ) {
                System.arraycopy(b, 0, tmpBuf, off, b.length);
                off += b.length;
            }
            System.arraycopy(this.buf, 0, tmpBuf, off, this.index);
            return tmpBuf;
        }

        void setParent(IDLObjectOutputStream os) {
            this.parent = os;
        }

        IDLObjectOutputStream getParent() {
            return this.parent;
        }

        void reset(int capacity) {
            if (this.buf.length != capacity) {
                this.buf = new byte[capacity];
            }
            this.bufQ.clear();
            this.index = 0;
            this.count = 0;
        }
    }

    static final class IDLObjectOutputStream
    extends ObjectOutputStream {
        private com.sun.corba.ee.spi.orb.ORB orb;

        IDLObjectOutputStream(OutputStream os, com.sun.corba.ee.spi.orb.ORB orb) throws IOException {
            super(os);
            this.orb = orb;
            AccessController.doPrivileged(new PrivilegedAction<java.lang.Object>(){

                @Override
                public java.lang.Object run() {
                    IDLObjectOutputStream.this.enableReplaceObject(true);
                    return null;
                }
            });
        }

        @Override
        protected final java.lang.Object replaceObject(java.lang.Object obj) throws IOException {
            try {
                if (obj instanceof Remote && !StubAdapter.isStub(obj)) {
                    return Utility.autoConnect(obj, (ORB)this.orb, true);
                }
            }
            catch (Exception e) {
                IOException ie = new IOException("replaceObject failed");
                ie.initCause(e);
                throw ie;
            }
            return obj;
        }

        void setOrb(com.sun.corba.ee.spi.orb.ORB orb) {
            this.orb = orb;
        }
    }
}

