/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.ServerTableEntry;
import java.util.Iterator;
import java.util.Map;

public class ProcessMonitorThread
extends Thread {
    private Map<Integer, ServerTableEntry> serverTable;
    private int sleepTime;
    private static ProcessMonitorThread instance = null;

    private ProcessMonitorThread(Map<Integer, ServerTableEntry> ServerTable, int SleepTime) {
        this.serverTable = ServerTable;
        this.sleepTime = SleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                break;
            }
            Map<Integer, ServerTableEntry> map = this.serverTable;
            synchronized (map) {
                Iterator<ServerTableEntry> serverList = this.serverTable.values().iterator();
                this.checkServerHealth(serverList);
            }
        }
    }

    private void checkServerHealth(Iterator serverList) {
        while (serverList.hasNext()) {
            ServerTableEntry entry = (ServerTableEntry)serverList.next();
            entry.checkProcessHealth();
        }
    }

    static void start(Map<Integer, ServerTableEntry> serverTable) {
        int sleepTime = 1000;
        String pollingTime = System.getProperties().getProperty("com.sun.corba.ee.activation.ServerPollingTime");
        if (pollingTime != null) {
            try {
                sleepTime = Integer.parseInt(pollingTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        instance = new ProcessMonitorThread(serverTable, sleepTime);
        instance.setDaemon(true);
        instance.start();
    }

    static void interruptThread() {
        instance.interrupt();
    }
}

