/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import org.omg.CORBA.ORB;

public class ByteBufferWithInfo {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private boolean debug;
    private ByteBuffer byteBuffer;
    private int needed;
    private boolean fragmented;

    public ByteBufferWithInfo(ORB orb, ByteBuffer byteBuffer, int index) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
        this.debug = this.orb.transportDebugFlag;
        this.setByteBuffer(byteBuffer);
        this.position(index);
        this.setNumberOfBytesNeeded(0);
        this.setFragmented(false);
    }

    public ByteBufferWithInfo(ORB orb, ByteBuffer byteBuffer) {
        this(orb, byteBuffer, 0);
    }

    public ByteBufferWithInfo(ORB orb, BufferManagerWrite bufferManager) {
        this(orb, bufferManager, true);
    }

    public ByteBufferWithInfo(ORB orb, BufferManagerWrite bufferManager, boolean usePooledByteBuffers) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
        this.debug = this.orb.transportDebugFlag;
        int bufferSize = bufferManager.getBufferSize();
        if (usePooledByteBuffers) {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            this.setByteBuffer(byteBufferPool.getByteBuffer(bufferSize));
            if (this.debug) {
                int bbAddress = System.identityHashCode(this.getByteBuffer());
                StringBuffer sb = new StringBuffer(80);
                sb.append("constructor (ORB, BufferManagerWrite) - got ").append("ByteBuffer id (").append(bbAddress).append(") from ByteBufferPool.");
                String msgStr = sb.toString();
                this.dprint(msgStr);
            }
        } else {
            this.setByteBuffer(ByteBuffer.allocate(bufferSize));
        }
        this.position(0);
        this.setLength(bufferSize);
        this.setNumberOfBytesNeeded(0);
        this.setFragmented(false);
    }

    public ByteBufferWithInfo(ByteBufferWithInfo bbwi) {
        this.orb = bbwi.orb;
        this.debug = bbwi.debug;
        this.setByteBuffer(bbwi.getByteBuffer().duplicate());
        this.setLength(bbwi.getLength());
        this.position(bbwi.position());
        this.setNumberOfBytesNeeded(bbwi.getNumberOfBytesNeeded());
        this.setFragmented(bbwi.isFragmented());
    }

    public int getSize() {
        return this.position();
    }

    public int getCapacity() {
        return this.getByteBuffer().capacity();
    }

    public int getLength() {
        return this.getByteBuffer().limit();
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    private int getNumberOfBytesNeeded() {
        return this.needed;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int position() {
        return this.getByteBuffer().position();
    }

    public void position(int newPosition) {
        this.getByteBuffer().position(newPosition);
    }

    public void flip() {
        this.getByteBuffer().flip();
    }

    public void setLength(int theLength) {
        this.getByteBuffer().limit(theLength);
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    public void setNumberOfBytesNeeded(int needed) {
        this.needed = needed;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void growBuffer(com.sun.corba.ee.spi.orb.ORB orb) {
        StringBuffer sb;
        int newLength;
        for (newLength = this.getLength() * 2; this.position() + this.getNumberOfBytesNeeded() >= newLength; newLength *= 2) {
        }
        ByteBufferPool byteBufferPool = orb.getByteBufferPool();
        ByteBuffer newBB = byteBufferPool.getByteBuffer(newLength);
        if (this.debug) {
            int newbbAddress = System.identityHashCode(newBB);
            sb = new StringBuffer(80);
            sb.append("growBuffer() - got ByteBuffer id (");
            sb.append(newbbAddress).append(") from ByteBufferPool.");
            String msgStr = sb.toString();
            this.dprint(msgStr);
        }
        this.flip();
        newBB.put(this.getByteBuffer());
        if (this.debug) {
            int bbAddress = System.identityHashCode(this.getByteBuffer());
            sb = new StringBuffer(80);
            sb.append("growBuffer() - releasing ByteBuffer id (");
            sb.append(bbAddress).append(") to ByteBufferPool.");
            String msgStr2 = sb.toString();
            this.dprint(msgStr2);
        }
        byteBufferPool.releaseByteBuffer(this.getByteBuffer());
        this.setByteBuffer(newBB);
        this.setLength(newLength);
    }

    public String toString() {
        StringBuffer str = new StringBuffer("ByteBufferWithInfo:");
        str.append(" length = " + this.getLength());
        str.append(" position = " + this.position());
        str.append(" needed = " + this.getNumberOfBytesNeeded());
        str.append(" byteBuffer = " + (this.getByteBuffer() == null ? "null" : "not null"));
        str.append(" fragmented = " + this.isFragmented());
        return str.toString();
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("ByteBufferWithInfo", msg);
    }
}

