/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.CorbaMessageMediatorImpl;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.CorbaClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoList;
import com.sun.corba.ee.spi.transport.CorbaOutboundConnectionCache;
import java.nio.ByteBuffer;

public abstract class CorbaContactInfoBase
implements CorbaContactInfo {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected IOR effectiveTargetIOR;
    protected short addressingDisposition;
    protected CorbaOutboundConnectionCache connectionCache;

    @Override
    public ORB getBroker() {
        return this.orb;
    }

    @Override
    public CorbaContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    @Override
    public CorbaClientRequestDispatcher getClientRequestDispatcher() {
        int scid = this.getEffectiveProfile().getObjectKeyTemplate().getSubcontractId();
        RequestDispatcherRegistry scr = this.orb.getRequestDispatcherRegistry();
        return scr.getClientRequestDispatcher(scid);
    }

    @Override
    public void setConnectionCache(CorbaOutboundConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public CorbaOutboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    @Override
    public CorbaMessageMediator createMessageMediator(ORB broker, CorbaContactInfo contactInfo, CorbaConnection connection, String methodName, boolean isOneWay) {
        CorbaMessageMediatorImpl messageMediator = new CorbaMessageMediatorImpl(broker, contactInfo, connection, GIOPVersion.chooseRequestVersion(broker, this.effectiveTargetIOR), this.effectiveTargetIOR, connection.getNextRequestId(), this.getAddressingDisposition(), methodName, isOneWay);
        return messageMediator;
    }

    @Override
    public CorbaMessageMediator createMessageMediator(ORB broker, CorbaConnection conn) {
        ORB orb = broker;
        CorbaConnection connection = conn;
        if (orb.transportDebugFlag) {
            this.dprint(".createMessageMediator: waiting for message on connection: " + connection);
        }
        MessageBase msg = MessageBase.readGIOPMessage(orb, connection);
        ByteBuffer byteBuffer = msg.getByteBuffer();
        msg.setByteBuffer(null);
        CorbaMessageMediatorImpl messageMediator = new CorbaMessageMediatorImpl(orb, connection, msg, byteBuffer);
        return messageMediator;
    }

    @Override
    public CDROutputObject createOutputObject(CorbaMessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = messageMediator;
        CDROutputObject outputObject = new CDROutputObject(this.orb, messageMediator, corbaMessageMediator.getRequestHeader(), corbaMessageMediator.getStreamFormatVersion());
        messageMediator.setOutputObject(outputObject);
        return outputObject;
    }

    @Override
    public CDRInputObject createInputObject(ORB broker, CorbaMessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = messageMediator;
        return new CDRInputObject(broker, messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    @Override
    public short getAddressingDisposition() {
        return this.addressingDisposition;
    }

    @Override
    public void setAddressingDisposition(short addressingDisposition) {
        this.addressingDisposition = addressingDisposition;
    }

    @Override
    public IOR getTargetIOR() {
        return this.contactInfoList.getTargetIOR();
    }

    @Override
    public IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    @Override
    public IIOPProfile getEffectiveProfile() {
        return this.effectiveTargetIOR.getProfile();
    }

    public String toString() {
        return "CorbaContactInfoBase[]";
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaContactInfoBase", msg);
    }
}

