/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.CorbaAcceptorBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.Selector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SocketOrChannelAcceptorImpl
extends CorbaAcceptorBase {
    protected ServerSocketChannel serverSocketChannel;
    protected ServerSocket serverSocket;
    private Class<?> lastExceptionClassSeen = null;

    public SocketOrChannelAcceptorImpl(ORB orb, int port, String name, String type) {
        super(orb, port, name, type);
    }

    @Override
    public synchronized boolean initialize() {
        if (this.initialized) {
            return false;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".initialize: " + this);
        }
        InetSocketAddress inetSocketAddress = null;
        String host = "all interfaces";
        try {
            if (this.orb.getORBData().getListenOnAllInterfaces()) {
                inetSocketAddress = new InetSocketAddress(this.port);
            } else {
                host = this.orb.getORBData().getORBServerHost();
                inetSocketAddress = new InetSocketAddress(host, this.port);
            }
            this.serverSocket = this.orb.getORBData().getSocketFactory().createServerSocket(this.type, inetSocketAddress);
            this.internalInitialize();
            if (this.orb.getORBData().showInfoMessages()) {
                this.wrapper.infoCreateListenerSucceeded(host, Integer.toString(this.port));
            }
        }
        catch (Throwable t) {
            throw this.wrapper.createListenerFailed(t, (Object)host, (Object)Integer.toString(this.port));
        }
        this.initialized = true;
        return true;
    }

    protected void internalInitialize() throws Exception {
        this.port = this.serverSocket.getLocalPort();
        this.orb.getCorbaTransportManager().getInboundConnectionCache(this);
        this.serverSocketChannel = this.serverSocket.getChannel();
        if (this.serverSocketChannel != null) {
            this.setUseSelectThreadToWait(this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
            this.serverSocketChannel.configureBlocking(!this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
        } else {
            this.setUseSelectThreadToWait(false);
        }
        this.setUseWorkerThreadForEvent(this.orb.getORBData().acceptorSocketUseWorkerThreadForEvent());
    }

    @Override
    public Socket getAcceptedSocket() {
        SocketChannel socketChannel = null;
        Socket socket = null;
        try {
            if (this.serverSocketChannel == null) {
                socket = this.serverSocket.accept();
            } else {
                socketChannel = this.serverSocketChannel.accept();
                socket = socketChannel.socket();
            }
            this.orb.getORBData().getSocketFactory().setAcceptedSocketOptions(this, this.serverSocket, socket);
            this.lastExceptionClassSeen = null;
        }
        catch (IOException e) {
            if (e.getClass() == this.lastExceptionClassSeen) {
                this.wrapper.ioexceptionInAcceptFine(e);
            } else {
                this.lastExceptionClassSeen = e.getClass();
                this.wrapper.ioexceptionInAccept(e);
            }
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.orb.getTransportManager().getSelector(0).registerForEvent(this);
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".accept: " + (this.serverSocketChannel == null ? this.serverSocket.toString() : this.serverSocketChannel.toString()));
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close->:");
            }
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.unregisterForEvent(this);
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close:", e);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-:");
            }
        }
    }

    @Override
    public SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    protected void accept() {
        this.processSocket(this.getAcceptedSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if (this.selectionKey.isAcceptable()) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        SocketOrChannelAcceptorImpl.this.accept();
                        return null;
                    }
                });
            } else if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ! selectionKey.isAcceptable: " + this);
            }
        }
        catch (SecurityException se) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring SecurityException: " + se + " " + this);
            }
            String permissionStr = ORBUtility.getClassSecurityInfo(this.getClass());
            this.wrapper.securityExceptionInAccept(se, (Object)permissionStr);
        }
        catch (Exception ex) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Exception: " + ex + " " + this);
            }
            this.wrapper.exceptionInAccept(ex);
        }
        catch (Throwable t) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + t + " " + this);
            }
        }
        finally {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.registerInterestOps(this);
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-:" + this);
            }
        }
    }

    @Override
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }
}

