/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.net;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarURIPattern {
    public static List<String> getJarEntries(URI uri, Pattern pattern) {
        ArrayList<String> results = new ArrayList<String>();
        File file = null;
        try {
            file = new File(uri);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (file == null || file.isDirectory()) {
            return results;
        }
        String fileName = file.getName();
        if (fileName != null && fileName.endsWith(".jar")) {
            ZipFile jarFile = null;
            try {
                jarFile = new JarFile(new File(uri));
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!pattern.matcher(entryName).matches()) continue;
                    results.add(entryName);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return results;
    }
}

