/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public abstract class AppClientInfo {
    public static final String USER_CODE_IS_SIGNED_PROPERTYNAME = "com.sun.aas.user.code.signed";
    private static final String SIGNED_USER_CODE_PERMISSION_TEMPLATE_NAME = "jwsclientSigned.policy";
    private static final String UNSIGNED_USER_CODE_PERMISSION_TEMPLATE_NAME = "jwsclientUnsigned.policy";
    private static final String CODE_BASE_PLACEHOLDER_NAME = "com.sun.aas.jws.client.codeBase";
    protected Logger _logger;
    @Inject
    protected Habitat habitat;
    private Archivist archivist = null;
    protected String mainClassFromCommandLine;
    protected String mainClassNameToRun = null;
    private ClassLoader classLoader = null;
    protected boolean isJWS = false;
    private ApplicationClientDescriptor acDesc = null;
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(AppClientInfo.class);
    protected static final boolean _keepExplodedDir = Boolean.getBoolean("appclient.keep.exploded.dir");

    public AppClientInfo(boolean isJWS, Logger logger, String mainClassFromCommandLine) {
        this.isJWS = isJWS;
        this._logger = logger;
        this.mainClassFromCommandLine = mainClassFromCommandLine;
    }

    protected void setDescriptor(ApplicationClientDescriptor acDesc) {
        this.acDesc = acDesc;
    }

    protected ApplicationClientDescriptor getDescriptor() {
        return this.acDesc;
    }

    protected void completeInit() throws Exception {
    }

    protected ApplicationClientDescriptor getAppClient() {
        return this.getAppClient(this.archivist);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected File createTmpArchiveDir(File forArchive) throws IOException {
        String name = forArchive.getName();
        File tmpDir = File.createTempFile("acc-" + name, "");
        tmpDir.delete();
        tmpDir.mkdirs();
        if (!_keepExplodedDir) {
            tmpDir.deleteOnExit();
        }
        return tmpDir;
    }

    protected void close() throws IOException {
    }

    protected boolean deleteAppClientDir() {
        return !_keepExplodedDir;
    }

    protected String getLocalString(String key, String defaultMessage, Object ... args) {
        String result = localStrings.getLocalString(this.getClass(), key, defaultMessage, args);
        return result;
    }

    protected void handlePersistenceUnitDependency() throws URISyntaxException, MalformedURLException {
    }

    private ClassLoader createClassLoader(ReadableArchive archive, URL[] persistenceURLs) throws IOException {
        int i;
        List<String> paths = this.getClassPaths(archive);
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        ASURLClassLoader loader = new ASURLClassLoader(parent);
        int LIST_SZ = paths.size();
        for (i = 0; i < LIST_SZ; ++i) {
            String path = paths.get(i);
            loader.appendURL(new File(path));
        }
        if (this._logger.isLoggable(Level.FINE)) {
            for (i = 0; i < paths.size(); ++i) {
                this._logger.fine("Added path to classloader ==> " + paths.get(i));
            }
        }
        for (URL url : persistenceURLs) {
            loader.appendURL(url);
            this._logger.fine("Added path to classloader ==> " + url);
        }
        return loader;
    }

    private void deleteFile(File f) {
        if (f.isDirectory()) {
            for (File subFile : f.listFiles()) {
                this.deleteFile(subFile);
            }
        }
        f.delete();
    }

    protected boolean descriptorContainsPURefcs(ApplicationClientDescriptor descr) {
        return !descr.getEntityManagerFactoryReferenceDescriptors().isEmpty();
    }

    protected static URL getEntryAsUrl(File moduleLocation, String uri) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url != null) {
            return url;
        }
        if (moduleLocation != null) {
            if (moduleLocation.isFile()) {
                url = AppClientInfo.createJarUrl(moduleLocation, uri);
            } else {
                String path = uri.replace('/', File.separatorChar);
                url = new File(moduleLocation, path).toURI().toURL();
            }
        }
        return url;
    }

    private static URL createJarUrl(File jarFile, String entry) throws MalformedURLException, IOException {
        return new URL("jar:" + jarFile.toURI().toURL() + "!/" + entry);
    }

    protected ApplicationClientDescriptor getAppClient(Archivist archivist) {
        return (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(archivist.getDescriptor());
    }

    protected String getAppClientRoot(ReadableArchive archive, ApplicationClientDescriptor descriptor) {
        return archive.getURI().toASCIIString();
    }

    protected void massageDescriptor() throws IOException, AnnotationProcessorException {
    }

    protected List<String> getClassPaths(ReadableArchive archive) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(archive.getURI().toASCIIString());
        return paths;
    }

    protected String getMainClassNameToRun(ApplicationClientDescriptor acDescr) {
        if (this.mainClassNameToRun == null) {
            if (this.mainClassFromCommandLine != null) {
                this.mainClassNameToRun = this.mainClassFromCommandLine;
                this._logger.fine("Main class is " + this.mainClassNameToRun + " from command line");
            } else {
                this.mainClassNameToRun = this.getAppClient().getMainClassName();
                this._logger.fine("Main class is " + this.mainClassNameToRun + " from descriptor");
            }
        }
        return this.mainClassNameToRun;
    }

    protected boolean classContainsAnnotation(String entry, AnnotationDetector detector, ReadableArchive archive, ApplicationClientDescriptor descriptor) throws FileNotFoundException, IOException {
        return detector.containsAnnotation(archive, entry);
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName() + ": " + lineSep);
        result.append("  isJWS: " + this.isJWS);
        result.append("  archivist type: " + this.archivist.getClass().getName() + lineSep);
        result.append("  main class to be run: " + this.mainClassNameToRun + lineSep);
        result.append("  class loader type: " + this.classLoader.getClass().getName() + lineSep);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApplicationInfoImpl {
        private AppClientInfo outer;
        private ApplicationClientDescriptor appClient;

        public ApplicationInfoImpl(AppClientInfo outer) {
            this.outer = outer;
            this.appClient = outer.getAppClient();
        }

        public Application getApplication(Habitat habitat) {
            Application application = this.appClient.getApplication();
            if (application == null) {
                application = Application.createApplication((Habitat)habitat, (String)this.appClient.getModuleID(), (ModuleDescriptor)this.appClient.getModuleDescriptor());
            }
            return application;
        }

        public InstrumentableClassLoader getClassLoader() {
            return (InstrumentableClassLoader)this.outer.getClassLoader();
        }

        public Collection<? extends PersistenceUnitDescriptor> getReferencedPUs() {
            return this.appClient.findReferencedPUs();
        }

        public Collection<? extends EntityManagerFactory> getEntityManagerFactories() {
            HashSet emfs = new HashSet();
            if (this.appClient.getApplication() != null) {
                emfs.addAll(this.appClient.getApplication().getEntityManagerFactories());
            }
            emfs.addAll(this.appClient.getEntityManagerFactories());
            return emfs;
        }
    }
}

