/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.security.appclient.integration.AppClientSecurityInfo;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.common.ClientSecurityContext;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class HttpAuthenticator
extends Authenticator {
    public static final boolean debug = false;
    private static Logger _logger = Logger.getLogger(HttpAuthenticator.class.getName());
    private final AppClientSecurityInfo.CredentialType loginType;
    private final AppClientSecurityInfo securityInfo;

    public HttpAuthenticator(AppClientSecurityInfo secInfo, AppClientSecurityInfo.CredentialType loginType) {
        this.securityInfo = secInfo;
        this.loginType = loginType;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        ClientSecurityContext cont;
        String user = null;
        String password = null;
        Subject subject = null;
        String scheme = this.getRequestingScheme();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("scheme=" + scheme);
            _logger.fine("requesting prompt=" + this.getRequestingPrompt());
            _logger.fine("requesting protocol=" + this.getRequestingProtocol());
        }
        subject = (cont = ClientSecurityContext.getCurrent()) != null ? cont.getSubject() : null;
        user = this.getUserName(subject);
        password = this.getPassword(subject);
        if (user == null || password == null) {
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Initiating login again...");
                }
                this.securityInfo.doClientLogin(this.loginType);
                cont = ClientSecurityContext.getCurrent();
                subject = cont.getSubject();
                user = this.getUserName(subject);
                password = this.getPassword(subject);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Exception " + e.toString(), e);
                return null;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Username:" + user);
        }
        return new PasswordAuthentication(user, password.toCharArray());
    }

    private String getUserName(Subject s) {
        String user = null;
        if (s == null) {
            return null;
        }
        Set<Principal> principalSet = s.getPrincipals();
        Iterator<Principal> itr = principalSet.iterator();
        if (itr.hasNext()) {
            Principal p = itr.next();
            user = p.getName();
        }
        return user;
    }

    private String getPassword(Subject s) {
        Object o;
        String password = null;
        if (s == null) {
            return null;
        }
        Set<Object> credentials = s.getPrivateCredentials();
        Iterator<Object> credIter = credentials.iterator();
        if (credIter.hasNext() && (o = credIter.next()) instanceof PasswordCredential) {
            PasswordCredential pc = (PasswordCredential)o;
            password = pc.getPassword();
        }
        return password;
    }
}

