/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AbstractThreadPool;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncThreadPool
extends AbstractThreadPool {
    protected int threadsCounter;
    protected int currentPoolSize;
    protected int activeThreadsCount;
    private final Queue<Runnable> workQueue;
    protected int maxQueuedTasks = -1;
    private final AtomicLong completedTasksCount = new AtomicLong();
    private int largestThreadPoolSize;
    protected final Object statelock = new Object();
    protected boolean running = true;
    protected final Map<AbstractThreadPool.Worker, Long> workers = new HashMap<AbstractThreadPool.Worker, Long>();

    public SyncThreadPool() {
        this("Grizzly", DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, null);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, threadFactory, new LinkedList<Runnable>(), -1);
    }

    public SyncThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, Queue<Runnable> workQueue, int maxQueuedTasks) {
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeUnit == null");
        }
        this.setPoolSizes(corePoolsize, maxPoolSize);
        this.keepAliveTime = TimeUnit.MILLISECONDS.convert(keepAliveTime, timeUnit);
        this.name = name;
        if (this.threadFactory == null) {
            this.threadFactory = new SyncWorkerThreadFactory();
        }
        this.workQueue = workQueue;
        this.maxQueuedTasks = maxQueuedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.statelock;
        synchronized (object) {
            while (this.currentPoolSize < this.corePoolSize) {
                this.startWorker(new SyncThreadWorker(true));
            }
        }
    }

    public void stop() {
        this.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        Object object = this.statelock;
        synchronized (object) {
            boolean isCore;
            if (!this.running) {
                throw new RejectedExecutionException("ThreadPool is not running");
            }
            int idleThreadsNumber = this.currentPoolSize - this.activeThreadsCount;
            if (this.maxQueuedTasks >= 0 && this.workQueue.size() >= this.maxQueuedTasks || !this.workQueue.offer(task)) {
                this.onTaskQueueOverflow();
                throw new RejectedExecutionException("ThreadPool is full");
            }
            this.onTaskQueued(task);
            boolean bl = isCore = this.currentPoolSize < this.corePoolSize;
            if (isCore || this.currentPoolSize < this.maxPoolSize && idleThreadsNumber == 0) {
                this.startWorker(new SyncThreadWorker(isCore));
            } else if (idleThreadsNumber == 0) {
                this.onMaxNumberOfThreadsReached();
            } else {
                this.statelock.notify();
            }
        }
    }

    protected void startWorker(AbstractThreadPool.Worker wt) {
        wt.t = this.threadFactory.newThread(wt);
        this.workers.put(wt, System.currentTimeMillis());
        wt.t.start();
        ++this.currentPoolSize;
        ++this.activeThreadsCount;
        if (this.currentPoolSize > this.largestThreadPoolSize) {
            this.largestThreadPoolSize = this.currentPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Object object = this.statelock;
        synchronized (object) {
            ArrayList<Runnable> drained = new ArrayList<Runnable>();
            if (this.running) {
                this.running = false;
                drained.addAll(this.workQueue);
                this.workQueue.clear();
                for (Runnable task : drained) {
                    this.onTaskDequeued(task);
                }
                this.poisonAll();
                for (AbstractThreadPool.Worker w : this.workers.keySet()) {
                    w.t.interrupt();
                }
            }
            return drained;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.statelock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                this.poisonAll();
                this.statelock.notifyAll();
            }
        }
    }

    private void poisonAll() {
        int size = Math.max(this.maxPoolSize, this.currentPoolSize) * 4 / 3;
        while (size-- > 0) {
            this.workQueue.offer(poison);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.statelock;
        synchronized (object) {
            return !this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.statelock;
        synchronized (object) {
            return !this.running && this.workers.isEmpty();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Object object = this.statelock;
        synchronized (object) {
            return this.activeThreadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskCount() {
        Object object = this.statelock;
        synchronized (object) {
            return this.workQueue.size();
        }
    }

    @Override
    public long getCompletedTaskCount() {
        return this.completedTasksCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLargestPoolSize() {
        Object object = this.statelock;
        synchronized (object) {
            return this.largestThreadPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        Object object = this.statelock;
        synchronized (object) {
            return this.currentPoolSize;
        }
    }

    @Override
    public Queue<Runnable> getQueue() {
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        Object object = this.statelock;
        synchronized (object) {
            return this.workQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxQueuedTasksCount() {
        Object object = this.statelock;
        synchronized (object) {
            return this.maxQueuedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxQueuedTasksCount(int maxQueuedTasks) {
        Object object = this.statelock;
        synchronized (object) {
            this.maxQueuedTasks = maxQueuedTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPoolSizes(int corePoolSize, int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolSize(corePoolSize, maxPoolSize);
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onWorkerExit(AbstractThreadPool.Worker worker) {
        super.onWorkerExit(worker);
        Object object = this.statelock;
        synchronized (object) {
            --this.currentPoolSize;
            --this.activeThreadsCount;
            this.workers.remove(worker);
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ((WorkerThreadImpl)t).createByteBuffer(false);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ((WorkerThreadImpl)Thread.currentThread()).reset();
        this.completedTasksCount.incrementAndGet();
        super.afterExecute(r, t);
    }

    @Override
    protected String nextThreadId() {
        return Integer.toString(this.threadsCounter++);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("SyncThreadPool[");
        this.injectToStringAttributes(builder);
        builder.append(']');
        return builder.toString();
    }

    protected void injectToStringAttributes(StringBuilder sb) {
        sb.append("name=").append(this.name);
        sb.append(", min-threads=").append(this.getCorePoolSize());
        sb.append(", max-threads=").append(this.getMaximumPoolSize());
        sb.append(", max-queue-size=").append(this.getMaxQueuedTasksCount());
        sb.append(", is-shutdown=").append(this.isShutdown());
    }

    protected class SyncThreadWorker
    extends AbstractThreadPool.Worker {
        private final boolean core;

        public SyncThreadWorker(boolean core) {
            this.core = core;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Runnable getTask() throws InterruptedException {
            Object object = SyncThreadPool.this.statelock;
            synchronized (object) {
                try {
                    --SyncThreadPool.this.activeThreadsCount;
                    if (!this.core && SyncThreadPool.this.currentPoolSize > SyncThreadPool.this.maxPoolSize) {
                        Runnable runnable = null;
                        return runnable;
                    }
                    Runnable r = (Runnable)SyncThreadPool.this.workQueue.poll();
                    while (r == null) {
                        SyncThreadPool.this.statelock.wait(SyncThreadPool.this.keepAliveTime);
                        r = (Runnable)SyncThreadPool.this.workQueue.poll();
                        if (this.core) continue;
                    }
                    Runnable runnable = r;
                    return runnable;
                }
                finally {
                    ++SyncThreadPool.this.activeThreadsCount;
                }
            }
        }
    }

    private class SyncWorkerThreadFactory
    implements ThreadFactory {
        private SyncWorkerThreadFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Thread newThread(Runnable r) {
            Object object = SyncThreadPool.this.statelock;
            synchronized (object) {
                WorkerThreadImpl thread = new WorkerThreadImpl(SyncThreadPool.this, SyncThreadPool.this.name + "-WorkerThread(" + SyncThreadPool.this.nextThreadId() + ")", r, SyncThreadPool.this.initialByteBufferSize);
                thread.setUncaughtExceptionHandler(SyncThreadPool.this);
                thread.setPriority(SyncThreadPool.this.priority);
                return thread;
            }
        }
    }
}

