/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.SelectorFilter;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;

public class QBrowseHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public ArrayList getQBrowseList(Destination destination, String string) throws BrokerException, SelectorFormatException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection collection = null;
        if (string == null) {
            collection = destination.getAll(null).values();
        } else {
            object4 = new SelectorFilter(string);
            object3 = destination.getAll((Filter)object4);
            collection = object3.values();
        }
        object4 = new ArrayList(collection);
        Collections.sort(object4, new RefCompare());
        object3 = Globals.getTransactionList();
        Iterator iterator = ((ArrayList)object4).iterator();
        while (iterator.hasNext()) {
            object2 = (PacketReference)iterator.next();
            if (((PacketReference)object2).isExpired()) {
                iterator.remove();
            }
            if (((PacketReference)object2).getTransactionID() != null && (object = ((TransactionList)object3).retrieveState(((PacketReference)object2).getTransactionID())) != null && ((TransactionState)object).getState() != 6) {
                iterator.remove();
            }
            if (((PacketReference)object2).checkLock(false) != null) continue;
            iterator.remove();
        }
        object2 = new ArrayList();
        iterator = ((ArrayList)object4).iterator();
        while (iterator.hasNext()) {
            object = (PacketReference)iterator.next();
            if (object == null) continue;
            ((ArrayList)object2).add(((PacketReference)object).getSysMessageID());
        }
        return object2;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        int n;
        byte[] byArray;
        Hashtable<String, Object> hashtable;
        Packet packet2;
        int n2;
        block23: {
            block22: {
                String string;
                block21: {
                    n2 = 200;
                    string = null;
                    packet2 = new Packet(iMQConnection.useDirectBuffers());
                    packet2.setConsumerID(packet.getConsumerID());
                    packet2.setPacketType(27);
                    hashtable = new Hashtable<String, Object>();
                    ConsumerUID consumerUID = new ConsumerUID();
                    hashtable.put("JMQConsumerID", new Long(consumerUID.longValue()));
                    Hashtable hashtable2 = null;
                    byArray = null;
                    String string2 = null;
                    String string3 = null;
                    n = 0;
                    try {
                        hashtable2 = packet.getProperties();
                        string2 = (String)hashtable2.get("JMQDestination");
                        n = 1;
                        string3 = (String)hashtable2.get("JMQSelector");
                        if (DEBUG) {
                            this.logger.log(4, "QBrowse request: destination =  " + string2 + "  selector = " + string3);
                        }
                        Destination destination = Destination.getDestination(string2, DestType.isQueue(n));
                        Boolean bl = (Boolean)hashtable2.get("JMQMetrics");
                        if (destination == null) {
                            n2 = 404;
                            string = "Destination " + string2 + " not found";
                            this.logger.log(16, "B2080", string2 == null ? "unknown" : string2);
                            break block21;
                        }
                        if (bl != null && bl == Boolean.TRUE) {
                            this.logger.log(8, "Getting destination metrics on " + destination);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            try {
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                objectOutputStream.writeObject(destination.getMetrics());
                                objectOutputStream.close();
                                byArray = byteArrayOutputStream.toByteArray();
                            }
                            catch (Exception exception) {
                                this.logger.log(32, "B3100", this.getClass().getName() + " : Got exception writing metrics to browse reply message:\n" + exception);
                            }
                            hashtable.put("JMQMetrics", bl);
                            break block21;
                        }
                        this.logger.log(4, "QueueBrowser created: destination =  " + string2 + "  selector = " + string3);
                        ArrayList arrayList = this.getQBrowseList(destination, string3);
                        if (DEBUG) {
                            this.logger.log(4, "QBrowse request: current queue size is " + arrayList.size());
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            SysMessageID sysMessageID = (SysMessageID)arrayList.get(i);
                            if (DEBUG) {
                                this.logger.log(4, "\t[" + i + "] id = " + sysMessageID);
                            }
                            sysMessageID.writeID(new DataOutputStream(byteArrayOutputStream));
                        }
                        byteArrayOutputStream.flush();
                        byArray = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {
                        this.logger.logStack(32, "B3100", "Unable to verify destination - no properties", (Throwable)iOException);
                        string = iOException.getMessage();
                        n2 = 500;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.logger.logStack(32, "B3100", "Unable to verify destination -bad class", (Throwable)classNotFoundException);
                        string = classNotFoundException.getMessage();
                        n2 = 500;
                    }
                    catch (SelectorFormatException selectorFormatException) {
                        string = selectorFormatException.getMessage();
                        n2 = 400;
                        this.logger.log(16, "B2016", string3, (Throwable)selectorFormatException);
                    }
                    catch (BrokerException brokerException) {
                        string = brokerException.getMessage();
                        n2 = brokerException.getStatusCode();
                        this.logger.log(16, "B2015", (Object)(string2 == null ? "unknown" : string2), (Throwable)brokerException);
                    }
                    catch (SecurityException securityException) {
                        string = securityException.getMessage();
                        n2 = 403;
                        this.logger.logStack(4, "B3100", " access to destination " + string2 + " is forbidden ", (Throwable)securityException);
                        string = securityException.getMessage();
                    }
                }
                hashtable.put("JMQStatus", new Integer(n2));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block22;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block23;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        if (n2 == 404) {
            hashtable.put("JMQCanCreate", Destination.canAutoCreate(DestType.isQueue(n)));
        }
        packet2.setProperties(hashtable);
        if (byArray != null) {
            packet2.setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage(packet2);
        return true;
    }
}

