/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueue;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueReader;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.OperationResult;
import com.sun.grizzly.util.FutureImpl;
import com.sun.grizzly.util.LinkedTransferQueue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsyncQueueReader
implements AsyncQueueReader {
    protected SelectorHandler selectorHandler;
    private AsyncQueue<SelectableChannel, AsyncQueueReadUnit> readQueue;

    public AbstractAsyncQueueReader(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        this.readQueue = new AsyncQueue();
    }

    @Override
    public Future<AsyncQueueReadUnit> read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        return this.read(key, buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        return this.read(key, buffer, callbackHandler, condition, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> read(SelectionKey key, ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        if (key == null) {
            throw new IOException("SelectionKey is null! Probably key was cancelled or connection was closed?");
        }
        FutureImpl<AsyncQueueReadUnit> future = new FutureImpl<AsyncQueueReadUnit>();
        SelectableChannel channel = key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.obtainAsyncQueueEntry(channel);
        channelEntry.totalElementsCount.incrementAndGet();
        AsyncQueueReadUnit record = new AsyncQueueReadUnit();
        LinkedTransferQueue<AsyncQueueReadUnit> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        int holdState = lock.getHoldCount();
        try {
            block24: {
                try {
                    OperationResult dstResult = channelEntry.tmpResult;
                    boolean isDirectReadCompleted = false;
                    if (currentElement.get() == null && lock.tryLock()) {
                        if (currentElement.compareAndSet(null, record)) {
                            do {
                                dstResult = this.doRead((ReadableByteChannel)((Object)channel), buffer, readPostProcessor, dstResult);
                                channelEntry.processedDataSize.addAndGet(dstResult.bytesProcessed);
                                if (dstResult.address == null || buffer.hasRemaining() && (condition == null || !condition.checkAsyncReadCompleted(key, dstResult.address, buffer))) continue;
                                isDirectReadCompleted = true;
                                break;
                            } while (dstResult.address != null);
                        } else {
                            lock.unlock();
                        }
                    }
                    if (!isDirectReadCompleted && buffer.hasRemaining()) {
                        channelEntry.queuedElementsCount.incrementAndGet();
                        record.set(buffer, callbackHandler, condition, readPostProcessor, future);
                        boolean isRegisterForReading = false;
                        if (currentElement.get() != record) {
                            queue.offer(record);
                            if (!lock.isLocked()) {
                                isRegisterForReading = true;
                            }
                        } else {
                            isRegisterForReading = true;
                            lock.unlock();
                        }
                        if (isRegisterForReading) {
                            this.registerForReading(key);
                        }
                        break block24;
                    }
                    boolean isReregister = false;
                    channelEntry.processedElementsCount.incrementAndGet();
                    if (lock.isHeldByCurrentThread()) {
                        AsyncQueueReadUnit nextRecord = queue.poll();
                        if (nextRecord != null) {
                            currentElement.set(nextRecord);
                            lock.unlock();
                            isReregister = true;
                        } else {
                            currentElement.set(null);
                            lock.unlock();
                            if (queue.peek() != null) {
                                isReregister = true;
                            }
                        }
                    }
                    record.set(buffer, callbackHandler, condition, readPostProcessor, future);
                    future.setResult(record);
                    if (callbackHandler != null) {
                        callbackHandler.onReadCompleted(key, dstResult.address, record);
                    }
                    if (!isReregister) break block24;
                    this.registerForReading(key);
                }
                catch (Exception e) {
                    if (record.callbackHandler != null) {
                        record.callbackHandler.onException(e, key, buffer, queue);
                    }
                    this.onClose(channel);
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new IOException(e.getMessage());
                }
            }
            Object var19_20 = null;
            if (lock.isHeldByCurrentThread() && holdState < lock.getHoldCount()) {
                lock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            if (lock.isHeldByCurrentThread() && holdState < lock.getHoldCount()) {
                lock.unlock();
            }
            throw throwable;
        }
        return future;
    }

    @Override
    public boolean isReady(SelectionKey key) {
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.getAsyncQueueEntry(key.channel());
        return channelEntry != null && (channelEntry.currentElement.get() != null || channelEntry.queue != null && !channelEntry.queue.isEmpty());
    }

    @Override
    public AsyncQueue.AsyncQueueEntry getAsyncQueue(SelectionKey key) {
        return this.readQueue.getAsyncQueueEntry(key.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onRead(SelectionKey key) throws IOException {
        SelectableChannel channel = key.channel();
        AsyncQueue.AsyncQueueEntry channelEntry = this.readQueue.obtainAsyncQueueEntry(channel);
        LinkedTransferQueue<AsyncQueueReadUnit> queue = channelEntry.queue;
        AtomicReference currentElement = channelEntry.currentElement;
        ReentrantLock lock = channelEntry.queuedActionLock;
        if (currentElement.get() == null) {
            AsyncQueueReadUnit nextRecord = (AsyncQueueReadUnit)queue.peek();
            if (nextRecord == null || !lock.tryLock()) return;
            if (!queue.isEmpty() && currentElement.compareAndSet(null, nextRecord)) {
                queue.remove();
            }
        } else if (!lock.tryLock()) {
            return;
        }
        try {
            OperationResult dstResult = channelEntry.tmpResult;
            while (currentElement.get() != null) {
                AsyncQueueReadUnit queueRecord = (AsyncQueueReadUnit)currentElement.get();
                ByteBuffer byteBuffer = queueRecord.byteBuffer;
                AsyncQueueDataProcessor readPostProcessor = queueRecord.readPostProcessor;
                try {
                    this.doRead((ReadableByteChannel)((Object)channel), byteBuffer, readPostProcessor, dstResult);
                    channelEntry.processedDataSize.addAndGet(dstResult.bytesProcessed);
                }
                catch (Exception e) {
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onException(e, key, byteBuffer, queue);
                    } else {
                        Controller.logger().log(Level.SEVERE, "Exception occured when executing asynchronous queue reading", e);
                    }
                    this.onClose(channel);
                }
                AsyncReadCondition condition = queueRecord.condition;
                if (!byteBuffer.hasRemaining() || condition != null && condition.checkAsyncReadCompleted(key, dstResult.address, byteBuffer)) {
                    currentElement.set(queue.poll());
                    ((FutureImpl)queueRecord.future).setResult(queueRecord);
                    channelEntry.processedElementsCount.incrementAndGet();
                    if (queueRecord.callbackHandler != null) {
                        queueRecord.callbackHandler.onReadCompleted(key, dstResult.address, queueRecord);
                    }
                    if (currentElement.get() != null) continue;
                    lock.unlock();
                    AsyncQueueReadUnit nextRecord = queue.peek();
                    if (nextRecord == null || !lock.tryLock()) break;
                    if (queue.isEmpty() || !currentElement.compareAndSet(null, nextRecord)) continue;
                    queue.remove();
                    continue;
                }
                lock.unlock();
                this.registerForReading(key);
                break;
            }
            Object var14_14 = null;
            if (!lock.isHeldByCurrentThread()) return;
            channelEntry.queuedActionLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!lock.isHeldByCurrentThread()) throw throwable;
            channelEntry.queuedActionLock.unlock();
            throw throwable;
        }
    }

    @Override
    public void onClose(SelectableChannel channel) {
        this.readQueue.removeEntry(channel);
    }

    @Override
    public void close() {
        this.readQueue.clear();
        this.readQueue = null;
    }

    protected abstract OperationResult doRead(ReadableByteChannel var1, ByteBuffer var2, AsyncQueueDataProcessor var3, OperationResult var4) throws IOException;

    private void registerForReading(SelectionKey key) {
        this.selectorHandler.register(key, 1);
    }
}

