/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-jms-host")
@Scoped(value=PerLookup.class)
@I18n(value="create.jms.host")
public class CreateJMSHost
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSHost.class);
    @Param(name="mqhost", defaultValue="localhost")
    String mqhost;
    @Param(name="mqport", defaultValue="7676")
    String mqport;
    @Param(name="mquser", defaultValue="admin")
    String mquser;
    @Param(name="mqpassword", defaultValue="admin")
    String mqpassword;
    @Param(optional=true)
    String target = "server";
    @Param(name="jms_host_name", primary=true)
    String jmsHostName;
    @Inject
    Configs configs;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        String configRef = targetServer.getConfigRef();
        if (this.jmsHostName == null) {
            report.setMessage(localStrings.getLocalString("create.jms.host.noJmsHost", "No JMS Host name specified."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JmsService jmsservice = null;
        for (Config c : this.configs.getConfig()) {
            if (!configRef.equals(c.getName())) continue;
            jmsservice = c.getJmsService();
        }
        for (JmsHost jmsHost : jmsservice.getJmsHost()) {
            if (!this.jmsHostName.equals(jmsHost.getName())) continue;
            report.setMessage(localStrings.getLocalString("create.jms.host.duplicate", "A JMS Host named {0} already exists.", new Object[]{this.jmsHostName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<JmsService>(){

                @Override
                public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                    JmsHost jmsHost = (JmsHost)param.createChild(JmsHost.class);
                    jmsHost.setAdminPassword(CreateJMSHost.this.mqpassword);
                    jmsHost.setAdminUserName(CreateJMSHost.this.mquser);
                    jmsHost.setName(CreateJMSHost.this.jmsHostName);
                    jmsHost.setHost(CreateJMSHost.this.mqhost);
                    jmsHost.setPort(CreateJMSHost.this.mqport);
                    param.getJmsHost().add(jmsHost);
                    return jmsHost;
                }
            }, jmsservice);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.jms.host.fail", "Unable to create jms host {0}.", new Object[]{this.jmsHostName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("create.jms.host.success", "Jms Host {0} created.", new Object[]{this.jmsHostName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

