/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.jms.system.ActiveJmsResourceAdapter;
import com.sun.enterprise.connectors.jms.system.MQAddressList;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.resource.spi.ResourceAdapter;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.CreateJMSDestination;
import org.glassfish.jms.admin.cli.JMSAdminException;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;

public abstract class JMSDestination {
    static Logger logger = LogDomains.getLogger(JMSDestination.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSDestination.class);
    public static final String JMS_DEST_TYPE_TOPIC = "topic";
    public static final String JMS_DEST_TYPE_QUEUE = "queue";
    public static final String DEFAULT_MAX_ACTIVE_CONSUMERS = "-1";
    public static final String MAX_ACTIVE_CONSUMERS_ATTRIBUTE = "MaxNumActiveConsumers";
    public static final String MAX_ACTIVE_CONSUMERS_PROPERTY = "maxNumActiveConsumers";
    public static final String JMXSERVICEURLLIST = "JMXServiceURLList";
    public static final String JMXCONNECTORENV = "JMXConnectorEnv";
    private static final boolean USE_JMX = true;
    protected static final String MBEAN_DOMAIN_NAME = "com.sun.messaging.jms.server";
    protected static final String DESTINATION_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=DestinationManager,subtype=Config";
    protected static final String DESTINATION_TYPE_QUEUE = "q";
    protected static final String DESTINATION_TYPE_TOPIC = "t";

    protected void validateJMSDestName(String destName) {
        if (destName == null || destName.length() <= 0) {
            throw new IllegalArgumentException(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_destname", destName));
        }
    }

    protected void validateJMSDestType(String destType) {
        if (destType == null || destType.length() <= 0) {
            throw new IllegalArgumentException(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_desttype", destType));
        }
        if (!destType.equals(JMS_DEST_TYPE_QUEUE) && !destType.equals(JMS_DEST_TYPE_TOPIC)) {
            throw new IllegalArgumentException(localStrings.getLocalString("admin.mbeans.rmb.invalid_jms_desttype", destType));
        }
    }

    protected MQJMXConnectorInfo getMQJMXConnectorInfo(String target, Configs configs, ServerContext serverContext, Domain domain, ConnectorRuntime connectorRuntime) throws Exception {
        logger.log(Level.FINE, "getMQJMXConnectorInfo for " + target);
        MQJMXConnectorInfo mcInfo = null;
        try {
            MQJMXConnectorInfo[] cInfo = this.getMQJMXConnectorInfos(target, configs, serverContext, domain, connectorRuntime);
            if (cInfo == null || cInfo.length < 1) {
                throw new Exception(localStrings.getLocalString("admin.mbeans.rmb.error_obtaining_jms", "Error obtaining JMS Info"));
            }
            mcInfo = cInfo[0];
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return mcInfo;
    }

    protected MQJMXConnectorInfo[] getMQJMXConnectorInfos(final String target, final Configs configs, final ServerContext serverContext, final Domain domain, ConnectorRuntime connectorRuntime) throws ConnectorRuntimeException {
        try {
            Config config = (Config)configs.getConfig().get(0);
            final JmsService jmsService = config.getJmsService();
            ActiveJmsResourceAdapter air = this.getMQAdapter(connectorRuntime);
            final Class<?> mqRAClassName = air.getResourceAdapter().getClass();
            MQJMXConnectorInfo mqjmxForServer = (MQJMXConnectorInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!JMSDestination.this.isClustered()) {
                        logger.log(Level.FINE, "Getting JMX connector for standalone target " + target);
                        return JMSDestination.this._getMQJMXConnectorInfo(target, jmsService, mqRAClassName, serverContext, configs, domain);
                    }
                    logger.log(Level.FINE, "Getting JMX connector for cluster target " + target);
                    return JMSDestination.this._getMQJMXConnectorInfoForCluster(target, jmsService, mqRAClassName, serverContext);
                }
            });
            return new MQJMXConnectorInfo[]{mqjmxForServer};
        }
        catch (Exception e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    protected MQJMXConnectorInfo _getMQJMXConnectorInfo(String targetName, JmsService jmsService, Class mqRAClassName, ServerContext serverContext, Configs configs, Domain domain) throws ConnectorRuntimeException {
        try {
            String connectionURL = null;
            boolean isDAS = this.isDAS(targetName);
            if (isDAS) {
                connectionURL = this.getDefaultAddressList(jmsService).toString();
            } else {
                logger.log(Level.FINE, "not in DAS");
                logger.log(Level.FINE, " _getMQJMXConnectorInfo - NOT in DAS");
                String domainurl = serverContext.getServerConfigURL();
                JmsService serverJmsService = this.getJmsServiceOfStandaloneServerInstance(targetName, configs, domain);
                MQAddressList mqadList = new MQAddressList(serverJmsService, targetName);
                mqadList.setup();
                connectionURL = mqadList.toString();
            }
            logger.log(Level.FINE, " _getMQJMXConnectorInfo - connection URL " + connectionURL);
            String adminUserName = null;
            String adminPassword = null;
            JmsHost jmsHost = this.getDefaultJmsHost(jmsService);
            if (jmsHost != null) {
                adminUserName = jmsHost.getAdminUserName();
                adminPassword = jmsHost.getAdminPassword();
            } else {
                logger.log(Level.FINE, " _getMQJMXConnectorInfo, using default jms admin user and password ");
            }
            ResourceAdapter raInstance = this.getConfiguredRA(mqRAClassName, connectionURL, adminUserName, adminPassword);
            String jmxServiceURL = null;
            String jmxServiceURLList = null;
            Map jmxConnectorEnv = null;
            Method[] methds = raInstance.getClass().getMethods();
            for (int i = 0; i < methds.length; ++i) {
                Method m = methds[i];
                if (m.getName().equalsIgnoreCase("getJMXServiceURLList")) {
                    jmxServiceURLList = (String)m.invoke((Object)raInstance, new Object[0]);
                    continue;
                }
                if (!m.getName().equalsIgnoreCase("getJMXConnectorEnv")) continue;
                jmxConnectorEnv = (Map)m.invoke((Object)raInstance, new Object[0]);
            }
            logger.log(Level.FINE, " _getMQJMXConnectorInfo - jmxServiceURLList " + jmxServiceURLList);
            logger.log(Level.FINE, " _getMQJMXConnectorInfo - jmxConnectorEnv " + jmxConnectorEnv);
            jmxServiceURL = this.getFirstJMXServiceURL(jmxServiceURLList);
            MQJMXConnectorInfo mqInfo = new MQJMXConnectorInfo(targetName, ActiveJmsResourceAdapter.getBrokerInstanceName((JmsService)jmsService), jmsService.getType(), jmxServiceURL, jmxConnectorEnv);
            return mqInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    protected MQJMXConnectorInfo _getMQJMXConnectorInfoForCluster(String target, JmsService jmsService, Class mqRAClassName, ServerContext serverContext) throws ConnectorRuntimeException {
        ResourceAdapter raInstance = null;
        try {
            MQAddressList list = null;
            if (jmsService.getType().equalsIgnoreCase("REMOTE")) {
                list = this.getDefaultAddressList(jmsService);
            } else {
                String domainurl = serverContext.getServerConfigURL();
                HashMap hostMap = new HashMap();
                if (hostMap.size() == 0) {
                    String msg = localStrings.getLocalString("mqjmx.no_jms_hosts", "No JMS Hosts Configured");
                    throw new ConnectorRuntimeException(msg);
                }
                list = new MQAddressList();
                for (JmsHost host : hostMap.values()) {
                    list.addMQUrl(host);
                }
            }
            String connectionUrl = list.toString();
            String adminUserName = null;
            String adminPassword = null;
            JmsHost jmsHost = this.getDefaultJmsHost(jmsService);
            if (jmsHost != null) {
                adminUserName = jmsHost.getAdminUserName();
                adminPassword = jmsHost.getAdminPassword();
            } else {
                logger.log(Level.FINE, " _getMQJMXConnectorInfo, using default jms admin user and password ");
            }
            raInstance = this.getConfiguredRA(mqRAClassName, connectionUrl, adminUserName, adminPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
        try {
            String jmxServiceURL = null;
            String jmxServiceURLList = null;
            Map jmxConnectorEnv = null;
            Method[] methds = raInstance.getClass().getMethods();
            for (int i = 0; i < methds.length; ++i) {
                Method m = methds[i];
                if (m.getName().equalsIgnoreCase("getJMXServiceURLList")) {
                    jmxServiceURLList = (String)m.invoke((Object)raInstance, new Object[0]);
                    if (jmxServiceURLList == null || jmxServiceURLList.trim().equals("")) continue;
                    jmxServiceURL = this.getFirstJMXServiceURL(jmxServiceURLList);
                    continue;
                }
                if (!m.getName().equalsIgnoreCase("getJMXConnectorEnv")) continue;
                jmxConnectorEnv = (Map)m.invoke((Object)raInstance, new Object[0]);
            }
            MQJMXConnectorInfo mqInfo = new MQJMXConnectorInfo(target, ActiveJmsResourceAdapter.getBrokerInstanceName((JmsService)jmsService), jmsService.getType(), jmxServiceURL, jmxConnectorEnv);
            return mqInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    protected boolean isAConfig(String targetName, Configs configs) throws Exception {
        List configsList = configs.getConfig();
        for (int i = 0; i < configsList.size(); ++i) {
            Config config = (Config)configsList.get(i);
            if (!targetName.equals(config.getName())) continue;
            return true;
        }
        return false;
    }

    protected JmsHost getDefaultJmsHost(JmsService jmsService) {
        String defaultJmsHost = jmsService.getDefaultJmsHost();
        JmsHost jmsHost = null;
        if (defaultJmsHost == null || defaultJmsHost.equals("")) {
            try {
                jmsHost = (JmsHost)jmsService.getJmsHost().get(0);
            }
            catch (Exception e) {}
        } else {
            for (JmsHost defaultHost : jmsService.getJmsHost()) {
                if (!defaultJmsHost.equals(defaultHost.getName())) continue;
                jmsHost = defaultHost;
            }
        }
        return jmsHost;
    }

    protected ResourceAdapter getConfiguredRA(Class mqRAclassname, String connectionURL, String adminuser, String adminpasswd) throws Exception {
        ResourceAdapter raInstance = (ResourceAdapter)mqRAclassname.newInstance();
        Method setConnectionURL = mqRAclassname.getMethod("setConnectionURL", String.class);
        setConnectionURL.invoke((Object)raInstance, connectionURL);
        logger.log(Level.FINE, " getConfiguredRA - set connectionURL as " + connectionURL);
        if (adminuser != null) {
            Method setAdminUser = mqRAclassname.getMethod("setAdminUsername", String.class);
            setAdminUser.invoke((Object)raInstance, adminuser);
            logger.log(Level.FINE, " getConfiguredRA - set admin user as " + adminuser);
        }
        if (adminpasswd != null) {
            Method setAdminPasswd = mqRAclassname.getMethod("setAdminPassword", String.class);
            setAdminPasswd.invoke((Object)raInstance, adminpasswd);
            logger.log(Level.FINE, " getConfiguredRA - set admin passwd as *****  ");
        }
        return raInstance;
    }

    private JmsService getJmsServiceOfStandaloneServerInstance(String target, Configs configs, Domain domain) throws Exception {
        logger.log(Level.FINE, "getJMSServiceOfSI LL " + target);
        Server targetServer = domain.getServerNamed(target);
        String configRef = targetServer.getConfigRef();
        Config cfg = null;
        if (this.isAConfig(target, configs)) {
            cfg = configs.getConfigByName(target);
        } else {
            for (Config config : configs.getConfig()) {
                if (!configRef.equals(config.getName())) continue;
                cfg = config;
            }
        }
        logger.log(Level.FINE, "cfg " + cfg);
        JmsService jmsService = cfg.getJmsService();
        logger.log(Level.FINE, "jmsservice " + jmsService);
        return jmsService;
    }

    protected String getFirstJMXServiceURL(String jmxServiceURLList) {
        if (jmxServiceURLList == null || "".equals(jmxServiceURLList)) {
            return jmxServiceURLList;
        }
        StringTokenizer tokenizer = new StringTokenizer(jmxServiceURLList, " ");
        return tokenizer.nextToken();
    }

    protected boolean isClustered() {
        return false;
    }

    protected ActiveJmsResourceAdapter getMQAdapter(final ConnectorRuntime connectorRuntime) throws Exception {
        ActiveJmsResourceAdapter air = (ActiveJmsResourceAdapter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                String module = "jmsra";
                String loc = ConnectorsUtil.getSystemModuleLocation((String)module);
                connectorRuntime.createActiveResourceAdapter(loc, module, null);
                return (ActiveJmsResourceAdapter)ConnectorRegistry.getInstance().getActiveResourceAdapter(module);
            }
        });
        return air;
    }

    private boolean isDAS(String targetName) {
        return true;
    }

    protected MQAddressList getDefaultAddressList(JmsService jmsService) throws Exception {
        MQAddressList list = new MQAddressList(jmsService);
        list.setup();
        return list;
    }

    protected void logAndHandleException(Exception e, String errorMsg) throws JMSAdminException {
        StringWriter s = new StringWriter();
        e.getCause().printStackTrace(new PrintWriter(s));
        logger.log(Level.WARNING, s.toString());
        JMSAdminException je = new JMSAdminException(localStrings.getLocalString(errorMsg, ""));
        if (e.getCause() != null && e.getCause().getCause() != null) {
            je.initCause(e.getCause().getCause().getCause());
        }
        this.handleException(je);
    }

    protected void handleException(Exception e) throws JMSAdminException {
        if (e instanceof JMSAdminException) {
            throw (JMSAdminException)e;
        }
        String msg = e.getMessage();
        JMSAdminException jae = msg == null ? new JMSAdminException() : new JMSAdminException(msg);
        throw jae;
    }

    protected AttributeList convertProp2Attrs(Properties destProps) {
        AttributeList destAttrs = new AttributeList();
        String propName = null;
        String propValue = null;
        Enumeration<?> e = destProps.propertyNames();
        while (e.hasMoreElements()) {
            boolean b;
            propName = (String)e.nextElement();
            if (propName.equals("AutoCreateQueueMaxNumActiveConsumers")) {
                destAttrs.add(new Attribute("AutoCreateQueueMaxNumActiveConsumers", Integer.valueOf(destProps.getProperty("AutoCreateQueueMaxNumActiveConsumers"))));
                continue;
            }
            if (propName.equals(MAX_ACTIVE_CONSUMERS_PROPERTY)) {
                destAttrs.add(new Attribute(MAX_ACTIVE_CONSUMERS_ATTRIBUTE, Integer.valueOf(destProps.getProperty(MAX_ACTIVE_CONSUMERS_PROPERTY))));
                continue;
            }
            if (propName.equals(MAX_ACTIVE_CONSUMERS_ATTRIBUTE)) {
                destAttrs.add(new Attribute(MAX_ACTIVE_CONSUMERS_ATTRIBUTE, Integer.valueOf(destProps.getProperty(MAX_ACTIVE_CONSUMERS_ATTRIBUTE))));
                continue;
            }
            if (propName.equals("AutoCreateQueueMaxNumBackupConsumers")) {
                destAttrs.add(new Attribute("AutoCreateQueueMaxNumBackupConsumers", Integer.valueOf(destProps.getProperty("AutoCreateQueueMaxNumBackupConsumers"))));
                continue;
            }
            if (propName.equals("AutoCreateQueues")) {
                b = false;
                propValue = destProps.getProperty("AutoCreateQueues");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("AutoCreateQueues", b));
                continue;
            }
            if (propName.equals("AutoCreateTopics")) {
                b = false;
                propValue = destProps.getProperty("AutoCreateTopics");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("AutoCreateTopics", b));
                continue;
            }
            if (propName.equals("DMQTruncateBody")) {
                b = false;
                propValue = destProps.getProperty("DMQTruncateBody");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("DMQTruncateBody", b));
                continue;
            }
            if (propName.equals("LogDeadMsgs")) {
                b = false;
                propValue = destProps.getProperty("LogDeadMsgs");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("LogDeadMsgs", b));
                continue;
            }
            if (propName.equals("MaxBytesPerMsg")) {
                destAttrs.add(new Attribute("MaxBytesPerMsg", Long.valueOf(destProps.getProperty("MaxBytesPerMsg"))));
                continue;
            }
            if (propName.equals("MaxNumMsgs")) {
                destAttrs.add(new Attribute("MaxNumMsgs", Long.valueOf(destProps.getProperty("MaxNumMsgs"))));
                continue;
            }
            if (propName.equals("MaxTotalMsgBytes")) {
                destAttrs.add(new Attribute("MaxTotalMsgBytes", Long.valueOf(destProps.getProperty("MaxTotalMsgBytes"))));
                continue;
            }
            if (!propName.equals("NumDestinations")) continue;
            destAttrs.add(new Attribute("NumDestinations", Integer.valueOf(destProps.getProperty("NumDestinations"))));
        }
        return destAttrs;
    }
}

