/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Upload;
import com.sun.webui.jsf.renderkit.html.FieldRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.fileupload.FileUploadBase;

public class UploadRenderer
extends FieldRenderer {
    private static final boolean DEBUG = false;

    public void decode(FacesContext context, UIComponent component) {
        Upload upload = (Upload)component;
        String id = component.getClientId(context).concat("_com.sun.webui.jsf.upload");
        Map map = context.getExternalContext().getRequestMap();
        if (map.containsKey(id)) {
            upload.setSubmittedValue(id);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Upload)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Upload.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Upload.renderer", params);
            throw new FacesException(message);
        }
        Theme theme = ThemeUtilities.getTheme(context);
        Map map = context.getExternalContext().getRequestMap();
        Object error = map.get("upload_error_key");
        if (error != null && error instanceof Throwable) {
            if (error instanceof FileUploadBase.SizeLimitExceededException) {
                String maxSize = (String)map.get("file_size_key");
                Object[] detailArgs = new String[]{maxSize};
                String summaryMsg = theme.getMessage("FileUpload.noFile");
                String detailMsg = theme.getMessage("Upload.error", detailArgs);
                FacesMessage fmsg = new FacesMessage(summaryMsg, detailMsg);
                context.addMessage(((Upload)component).getClientId(context), fmsg);
            } else {
                String summaryMsg = theme.getMessage("FileUpload.noFile");
                FacesException fe = new FacesException(summaryMsg);
                fe.initCause((Throwable)error);
                throw fe;
            }
        }
        boolean spanRendered = super.renderField(context, (Upload)component, "file", this.getStyles(context));
        String id = component.getClientId(context);
        StringBuilder jsString = new StringBuilder(256);
        jsString.append(JavaScriptUtilities.getModuleName("upload.setEncodingType"));
        jsString.append("('");
        jsString.append(id);
        jsString.append("');\n");
        ResponseWriter writer = context.getResponseWriter();
        JavaScriptUtilities.renderJavaScript(component, writer, jsString.toString());
        if (!spanRendered) {
            String param = id.concat("_com.sun.webui.jsf.uploadParam");
            RenderingUtilities.renderHiddenField(component, writer, param, id);
        }
    }
}

