/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.SystemEnvironment;

class LinuxSystemEnvironment
extends SystemEnvironment {
    private String dmiInfo = null;
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;

    LinuxSystemEnvironment() {
        this.setHostId(this.getLinuxHostId());
        this.setSystemModel(this.getCommandOutput("/bin/uname", "-i"));
        this.setSystemManufacturer(this.getLinuxSystemManufacturer());
        this.setCpuManufacturer(this.getLinuxCpuManufacturer());
        this.setSerialNumber(this.getLinuxSN());
    }

    private String getLinuxHostId() {
        String output = this.getCommandOutput("/usr/bin/hostid");
        if (output.startsWith("0x")) {
            output = output.substring(2);
        }
        return output;
    }

    private String getLinuxCpuManufacturer() {
        String tmp = this.getLinuxPSNInfo(3);
        if (tmp.length() > 0) {
            return tmp;
        }
        String contents = this.getFileContent("/proc/cpuinfo");
        for (String line : contents.split("\n")) {
            String[] ss;
            if (!line.contains("vendor_id") || (ss = line.split(":", 2)).length <= 1) continue;
            return ss[1].trim();
        }
        return this.getLinuxDMIInfo("dmi type 4", "manufacturer");
    }

    private String getLinuxSystemManufacturer() {
        String tmp = this.getLinuxPSNInfo(2);
        if (tmp.length() > 0) {
            return tmp;
        }
        return this.getLinuxDMIInfo("dmi type 1", "manufacturer");
    }

    private String getLinuxSN() {
        String tmp = this.getLinuxPSNInfo(1);
        if (tmp.length() > 0) {
            return tmp;
        }
        return this.getLinuxDMIInfo("dmi type 1", "serial number");
    }

    private String getLinuxPSNInfo(int target) {
        String contents = this.getFileContent("/var/run/psn");
        String[] ss = contents.split("\n");
        if (target <= ss.length) {
            return ss[target - 1];
        }
        return "";
    }

    private synchronized String getLinuxDMIInfo(String dmiType, String target) {
        if (this.dmiInfo == null) {
            Thread dmidecodeThread = new Thread(){

                public void run() {
                    LinuxSystemEnvironment.this.dmiInfo = LinuxSystemEnvironment.this.getCommandOutput("/usr/sbin/dmidecode");
                }
            };
            dmidecodeThread.start();
            try {
                dmidecodeThread.join(2000L);
                if (dmidecodeThread.isAlive()) {
                    dmidecodeThread.interrupt();
                    this.dmiInfo = "";
                }
            }
            catch (InterruptedException ie) {
                dmidecodeThread.interrupt();
            }
        }
        if (this.dmiInfo.length() == 0) {
            return "";
        }
        boolean dmiFlag = false;
        for (String s : this.dmiInfo.split("\n")) {
            String line = s.toLowerCase();
            if (dmiFlag) {
                if (!line.contains(target)) continue;
                String key = target + ":";
                int indx = line.indexOf(key) + key.length();
                if (line.contains(key) && indx < line.length()) {
                    return line.substring(indx).trim();
                }
                String[] ss = line.split(":");
                return ss[ss.length - 1];
            }
            if (!line.contains(dmiType)) continue;
            dmiFlag = true;
        }
        return "";
    }
}

