/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo.impl;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceElementCollection;
import com.sun.jdo.api.persistence.model.jdo.impl.PersistenceElementImpl;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.beans.PropertyVetoException;

public class PersistenceClassElementImpl
extends PersistenceElementImpl
implements PersistenceClassElement.Impl {
    private boolean _isModified;
    private int _objectIdentityType;
    private String _keyClass;
    private PersistenceElementCollection _fields;
    private PersistenceElementCollection _groups;

    public PersistenceClassElementImpl() {
        this(null);
    }

    public PersistenceClassElementImpl(String name) {
        super(name);
        if (name != null) {
            this._keyClass = name + ".Oid";
        }
        this._objectIdentityType = 0;
        this._fields = new PersistenceElementCollection(this, "fields", new PersistenceFieldElement[0]);
        this._groups = new PersistenceElementCollection(this, "groups", new ConcurrencyGroupElement[0]);
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        boolean noChange = o != null && n != null && o.equals(n);
        super.firePropertyChange(name, o, n);
        if (!"modified".equals(name) && !noChange) {
            this.setModified(true);
        }
    }

    protected final void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        boolean noChange = o != null && n != null && o.equals(n);
        super.fireVetoableChange(name, o, n);
        if (!"modified".equals(name) && !noChange) {
            this.fireVetoableChange("modified", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean flag) {
        boolean oldFlag = this.isModified();
        if (flag != oldFlag) {
            this._isModified = flag;
            this.firePropertyChange("modified", JavaTypeHelper.valueOf(oldFlag), JavaTypeHelper.valueOf(flag));
        }
    }

    public int getObjectIdentityType() {
        return this._objectIdentityType;
    }

    public void setObjectIdentityType(int type) throws ModelException {
        Integer old = new Integer(this.getObjectIdentityType());
        Integer newType = new Integer(type);
        try {
            this.fireVetoableChange("identity", old, newType);
            this._objectIdentityType = type;
            this.firePropertyChange("identity", old, newType);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public String getKeyClass() {
        return 0 == this.getObjectIdentityType() ? this._keyClass : null;
    }

    public void setKeyClass(String name) throws ModelException {
        String old = this.getKeyClass();
        try {
            this.fireVetoableChange("keyClass", old, name);
            this._keyClass = name;
            this.firePropertyChange("keyClass", old, name);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public void changeFields(PersistenceFieldElement[] fields, int action) throws ModelException {
        this._fields.changeElements(fields, action);
    }

    public PersistenceFieldElement[] getFields() {
        return (PersistenceFieldElement[])this._fields.getElements();
    }

    public PersistenceFieldElement getField(String name) {
        return (PersistenceFieldElement)this._fields.getElement(name);
    }

    public void changeConcurrencyGroups(ConcurrencyGroupElement[] groups, int action) throws ModelException {
        this._groups.changeElements(groups, action);
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        return (ConcurrencyGroupElement[])this._groups.getElements();
    }

    public ConcurrencyGroupElement getConcurrencyGroup(String name) {
        return (ConcurrencyGroupElement)this._groups.getElement(name);
    }

    public PersistenceElementCollection getFieldCollection() {
        return this._fields;
    }

    public void setFieldCollection(PersistenceElementCollection collection) {
        this._fields = collection;
    }

    public PersistenceElementCollection getGroupCollection() {
        return this._groups;
    }

    public void setGroupCollection(PersistenceElementCollection collection) {
        this._groups = collection;
    }
}

