/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.store;

import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTxStoreManager
implements SFSBTxStoreManager {
    private static final Level TRACE_LEVEL = Level.FINE;
    protected static final Logger _logger = LogDomains.getLogger(FileTxStoreManager.class, (String)"javax.enterprise.system.container.ejb");

    public void checkpointSave(SFSBBeanState[] beanStates) throws SFSBStoreManagerException {
        int sz = beanStates.length;
        for (int i = 0; i < sz; ++i) {
            SFSBStoreManager manager = beanStates[i].getSFSBStoreManager();
            try {
                if (manager == null) {
                    _logger.log(Level.WARNING, "StoreManager is null. Cannot checkpoint");
                    continue;
                }
                manager.checkpointSave(beanStates[i]);
                if (!_logger.isLoggable(TRACE_LEVEL)) continue;
                _logger.log(TRACE_LEVEL, "Successfully txCheckpointed " + beanStates.length + " beans...");
                continue;
            }
            catch (SFSBStoreManagerException smEx) {
                _logger.log(Level.WARNING, "StoreManagerException during checkpointSave", smEx);
                continue;
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "Exception during checkpointSave", th);
            }
        }
    }
}

