/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.BrokerServiceCObj;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class BrokerServicePropsDialog
extends AdminDialog
implements ActionListener {
    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private BrokerServiceCObj svcCObj;
    private JLabel svcName;
    private JRadioButton dynamicPortButton;
    private JRadioButton staticPortButton;
    private JLabel dynamicPortLabel;
    private IntegerField staticPortIF;
    private JLabel svcState;
    private IntegerField minThreads;
    private IntegerField maxThreads;
    private JLabel numConnections;
    private JLabel allocatedThreads;
    private JPanel lvp;
    private LabelledComponent[] items;
    private ServiceInfo svcInfo;
    private LabelledComponent svcPortComponent;

    public BrokerServicePropsDialog(Frame frame) {
        super(frame, acr.getString("A1409"), 81);
        this.setHelpId("service_properties");
    }

    public JPanel createWorkPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        LabelledComponent[] labelledComponentArray = new LabelledComponent[3];
        this.svcName = new JLabel();
        LabelledComponent labelledComponent = new LabelledComponent(ar.getString("A1420") + ":", this.svcName);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        labelledComponentArray[0] = labelledComponent;
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.dynamicPortButton = new JRadioButton();
        this.dynamicPortButton.addActionListener(this);
        gridBagLayout2.setConstraints(this.dynamicPortButton, gridBagConstraints2);
        jPanel2.add(this.dynamicPortButton);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        this.staticPortButton = new JRadioButton();
        this.staticPortButton.addActionListener(this);
        gridBagLayout2.setConstraints(this.staticPortButton, gridBagConstraints2);
        jPanel2.add(this.staticPortButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.dynamicPortButton);
        buttonGroup.add(this.staticPortButton);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        JLabel jLabel = new JLabel(acr.getString("A1451") + ":");
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel2.add(jLabel);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        JLabel jLabel2 = new JLabel(acr.getString("A1452") + ":");
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints2);
        jPanel2.add(jLabel2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.dynamicPortLabel = new JLabel();
        gridBagLayout2.setConstraints(this.dynamicPortLabel, gridBagConstraints2);
        jPanel2.add(this.dynamicPortLabel);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.staticPortIF = new IntegerField(0L, Integer.MAX_VALUE, 15);
        this.staticPortIF.setEnabled(false);
        gridBagLayout2.setConstraints(this.staticPortIF, gridBagConstraints2);
        jPanel2.add(this.staticPortIF);
        labelledComponent = new LabelledComponent(ar.getString("A1421") + ":", (JComponent)jPanel2, 0);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        labelledComponentArray[1] = labelledComponent;
        this.svcPortComponent = labelledComponentArray[1];
        this.svcState = new JLabel();
        labelledComponent = new LabelledComponent(ar.getString("A1422") + ":", this.svcState);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        labelledComponentArray[2] = labelledComponent;
        LabelValuePanel labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 0);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        gridBagConstraints.gridy = 1;
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 2;
        labelledComponentArray = new LabelledComponent[2];
        this.allocatedThreads = new JLabel();
        labelledComponent = new LabelledComponent(ar.getString("A1425") + ":", this.allocatedThreads);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        labelledComponentArray[0] = labelledComponent;
        this.numConnections = new JLabel();
        labelledComponent = new LabelledComponent(ar.getString("A1426") + ":", this.numConnections);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        labelledComponentArray[1] = labelledComponent;
        labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 0);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        gridBagConstraints.gridy = 3;
        jSeparator = new JSeparator();
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 4;
        labelledComponentArray = new LabelledComponent[2];
        this.minThreads = new IntegerField(0L, Integer.MAX_VALUE, 15);
        this.minThreads.addActionListener(this);
        labelledComponent = new LabelledComponent(ar.getString("A1423") + ":", this.minThreads);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        jPanel.add(labelledComponent);
        labelledComponentArray[0] = labelledComponent;
        this.maxThreads = new IntegerField(0L, Integer.MAX_VALUE, 15);
        this.maxThreads.addActionListener(this);
        labelledComponent = new LabelledComponent(ar.getString("A1424") + ":", this.maxThreads);
        gridBagLayout.setConstraints(labelledComponent, gridBagConstraints);
        labelledComponentArray[1] = labelledComponent;
        labelValuePanel = new LabelValuePanel(labelledComponentArray, 4, 0);
        gridBagLayout.setConstraints(labelValuePanel, gridBagConstraints);
        jPanel.add(labelValuePanel);
        return jPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doOK() {
        Object object;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (this.staticPortButton.isSelected()) {
            object = this.staticPortIF.getText();
            if ("".equals(object)) {
                JOptionPane.showOptionDialog(this, acr.getString("A3044"), acr.getString("A1409") + ": " + acr.getString("A1218", "A3044"), 0, 0, null, close, close[0]);
                return;
            }
            n = Integer.parseInt((String)object);
        } else if (this.dynamicPortButton.isSelected()) {
            n = this.svcInfo.port == -1 ? -1 : 0;
        }
        n2 = Integer.parseInt(this.minThreads.getText());
        n3 = Integer.parseInt(this.maxThreads.getText());
        object = new BrokerAdminEvent(this, 6);
        ((BrokerAdminEvent)object).setPort(n);
        ((BrokerAdminEvent)object).setMinThreads(n2);
        ((BrokerAdminEvent)object).setMaxThreads(n3);
        ((BrokerAdminEvent)object).setOKAction(true);
        this.fireAdminEventDispatched((AdminEvent)object);
    }

    public void doApply() {
    }

    public void doReset() {
    }

    public void doCancel() {
        this.hide();
    }

    public void doClose() {
        this.hide();
        this.doClear();
    }

    public void doClear() {
        this.svcName.setText(" ");
        this.dynamicPortButton.setSelected(true);
        this.staticPortButton.setSelected(false);
        this.dynamicPortLabel.setText(" ");
        this.staticPortIF.setText("");
        this.svcState.setText(" ");
        this.minThreads.setText("0");
        this.maxThreads.setText("0");
        this.allocatedThreads.setText("0");
        this.numConnections.setText("0");
        this.svcPortComponent.setEnabled(true);
    }

    public void show(ServiceInfo serviceInfo) {
        this.svcInfo = serviceInfo;
        if (serviceInfo == null) {
            this.doClear();
            return;
        }
        this.svcName.setText(serviceInfo.name);
        if (serviceInfo.port == -1) {
            this.enableServicePort(false);
        } else {
            this.enableServicePort(true);
            if (serviceInfo.dynamicPort) {
                this.dynamicPortButton.setSelected(true);
                this.staticPortIF.setEnabled(false);
                this.staticPortIF.setText("");
                switch (serviceInfo.state) {
                    case -1: {
                        this.dynamicPortLabel.setText(" ");
                        break;
                    }
                    default: {
                        this.dynamicPortLabel.setText(new Integer(serviceInfo.port).toString());
                        break;
                    }
                }
            } else {
                this.staticPortButton.setSelected(true);
                this.staticPortIF.setEnabled(true);
                this.staticPortIF.setText(new Integer(serviceInfo.port).toString());
                this.dynamicPortLabel.setText(" ");
            }
        }
        this.svcState.setText(BrokerAdminUtil.getServiceState(serviceInfo.state));
        this.minThreads.setText(new Integer(serviceInfo.minThreads).toString());
        this.maxThreads.setText(new Integer(serviceInfo.maxThreads).toString());
        this.allocatedThreads.setText(new Integer(serviceInfo.currentThreads).toString());
        this.numConnections.setText(new Integer(serviceInfo.nConnections).toString());
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dynamicPortButton) {
            this.doDynamicPortButton();
        } else if (object == this.staticPortButton) {
            this.doStaticPortButton();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void doDynamicPortButton() {
        this.staticPortIF.setEnabled(false);
    }

    private void doStaticPortButton() {
        this.staticPortIF.setEnabled(true);
    }

    private void enableServicePort(boolean bl) {
        this.svcPortComponent.setEnabled(bl);
        if (!bl) {
            this.dynamicPortButton.setSelected(true);
            this.staticPortButton.setSelected(false);
            this.dynamicPortLabel.setText(" ");
            this.staticPortIF.setText("");
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

