/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.DigestParameterGenerator;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.digest.impl.HttpAlgorithmParameterImpl;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.security.jmac.config.HttpServletHelper;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.logging.LogDomains;
import com.sun.web.security.HttpRequestWrapper;
import com.sun.web.security.HttpResponseWrapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import sun.security.x509.X500Name;

@Service
@Scoped(value=PerLookup.class)
public class RealmAdapter
extends RealmBase
implements RealmInitializer,
PostConstruct {
    private static final String UNCONSTRAINED = "unconstrained";
    private static final Logger _logger = LogDomains.getLogger(RealmAdapter.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = _logger.getResourceBundle();
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static final String SERVER_AUTH_CONTEXT = "__javax.security.auth.message.ServerAuthContext";
    private static final String MESSAGE_INFO = "__javax.security.auth.message.MessageInfo";
    private static WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static final String SYSTEM_HTTPSERVLET_SECURITY_PROVIDER = "system_httpservlet_security_provider";
    private SecurityRoleMapper mapper = null;
    private WebBundleDescriptor webDesc = null;
    private HashMap runAsPrincipals = null;
    private String _realmName = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String CONTEXT_ID = null;
    private Container virtualServer;
    protected volatile WebSecurityManager webSecurityManager = null;
    protected WebSecurityManagerFactory webSecurityManagerFactory = null;
    protected boolean isCurrentURIincluded = false;
    private ArrayList roles = null;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean contextEvaluated = false;
    private String loginPage = null;
    private String errorPage = null;
    private static SecurityConstraint[] emptyConstraints = new SecurityConstraint[0];
    private static String defaultSystemProviderID = RealmAdapter.getDefaultSystemProviderID();
    private String appID;
    private boolean isSystemApp;
    private String jmacProviderRegisID = null;
    private HttpServletHelper helper = null;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Habitat habitat;
    private static String PROXY_AUTH_TYPE = "PLUGGABLE_PROVIDER";

    public RealmAdapter() {
    }

    public RealmAdapter(String realmName) {
        this._realmName = realmName;
    }

    public void destroy() {
        super.destroy();
        if (this.helper != null) {
            this.helper.disable();
        }
    }

    public void setVirtualServer(Object container) {
        this.virtualServer = (Container)container;
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager getWebSecurityManager(boolean logNull) {
        if (this.webSecurityManager == null) {
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                this.webSecurityManager = this.webSecurityManagerFactory.getManager(this.CONTEXT_ID, null, false);
            }
            if (this.webSecurityManager == null && logNull) {
                _logger.log(Level.WARNING, "realmAdapter.noWebSecMgr", this.CONTEXT_ID);
            }
        }
        return this.webSecurityManager;
    }

    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        String servletName = this.getCanonicalName(request);
        boolean isGranted = secMgr.hasRoleRefPermission(servletName, role, principal);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Checking if servlet " + servletName + " with principal " + principal + " has role " + role + " isGranted: " + isGranted);
        }
        return isGranted;
    }

    public boolean hasRole(String servletName, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        return secMgr.hasRoleRefPermission(servletName, role, principal);
    }

    public void logout() {
        this.setSecurityContext(null);
    }

    public Principal authenticate(HttpServletRequest hreq) {
        try {
            DigestParameterGenerator generator = DigestParameterGenerator.getInstance((String)"HttpDigest");
            DigestAlgorithmParameter[] params = generator.generateParameters((AlgorithmParameterSpec)new HttpAlgorithmParameterImpl(hreq));
            Key key = null;
            for (int i = 0; i < params.length; ++i) {
                DigestAlgorithmParameter dap = params[i];
                if (!"A1".equals(dap.getName()) || !(dap instanceof Key)) continue;
                key = (Key)dap;
                break;
            }
            DigestCredentials creds = new DigestCredentials(this._realmName, key.getUsername(), params);
            LoginContextDriver.login((DigestCredentials)creds);
            SecurityContext secCtx = SecurityContext.getCurrent();
            return new WebPrincipal(creds.getUserName(), null, secCtx);
        }
        catch (Exception le) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("Web login failed: " + le.getMessage());
            }
            return null;
        }
    }

    public Principal authenticate(String username, byte[] authData) {
        return this.authenticate(username, new String(authData));
    }

    public Principal authenticate(String username, String password) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Tomcat callback for authenticate user/password");
            _logger.fine("usename = " + username);
        }
        if (this.authenticate(username, password, null)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            assert (secCtx != null);
            return new WebPrincipal(username, password, secCtx);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (this.authenticate(null, null, certs)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            assert (secCtx != null);
            return new WebPrincipal(certs, secCtx);
        }
        return null;
    }

    public boolean authenticate(WebPrincipal prin) {
        if (prin.isUsingCertificate()) {
            return this.authenticate(null, null, prin.getCertificates());
        }
        return this.authenticate(prin.getName(), prin.getPassword(), null);
    }

    protected boolean authenticate(String username, String password, X509Certificate[] certs) {
        boolean success;
        block5: {
            SecurityContext.setCurrent(null);
            String realm_name = null;
            success = false;
            try {
                if (certs != null) {
                    Subject subject = new Subject();
                    X509Certificate certificate = certs[0];
                    X500Name x500Name = (X500Name)certificate.getSubjectDN();
                    subject.getPublicCredentials().add(x500Name);
                    LoginContextDriver.login((Subject)subject, X500Name.class);
                    realm_name = "certificate";
                } else {
                    realm_name = this._realmName;
                    LoginContextDriver.login((String)username, (String)password, (String)realm_name);
                }
                success = true;
            }
            catch (Exception le) {
                success = false;
                if (!_logger.isLoggable(Level.WARNING)) break block5;
                _logger.warning("Web login failed: " + le.getMessage());
            }
        }
        if (success && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Web login succeeded for: " + username);
        }
        return success;
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = (String)this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            SecurityContext old = this.getSecurityContext();
            inv.setOldSecurityContext((Object)old);
            this.loginForRunAs(runAs);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("run-as principal for " + servletName + " set to: " + runAs);
            }
        }
    }

    private String getServletName(ComponentInvocation inv) {
        HttpServlet thisServlet;
        ServletConfig svc;
        Object invInstance = inv.getInstance();
        if (invInstance instanceof HttpServlet && (svc = (thisServlet = (HttpServlet)invInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = (String)this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            this.setSecurityContext((SecurityContext)inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal((String)principal, (String)this._realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent((SecurityContext)sc);
    }

    private boolean principalSetContainsOnlyAnonymousPrincipal(Set principalSet) {
        boolean rvalue = false;
        Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        if (defaultPrincipal != null && principalSet != null) {
            rvalue = principalSet.contains(defaultPrincipal);
        }
        if (rvalue) {
            Iterator it = principalSet.iterator();
            while (it.hasNext()) {
                if (((Object)((Principal)it.next())).equals(defaultPrincipal)) continue;
                return false;
            }
        }
        return rvalue;
    }

    protected String getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public Principal createFailOveredPrincipal(String username) {
        _logger.log(Level.FINEST, "IN createFailOveredPrincipal (" + username + ")");
        this.loginForRunAs(username);
        SecurityContext secCtx = SecurityContext.getCurrent();
        _logger.log(Level.FINE, "Security context is " + secCtx);
        assert (secCtx != null);
        WebPrincipal principal = new WebPrincipal(username, null, secCtx);
        _logger.log(Level.INFO, "Principal created for FailOvered user " + principal);
        return principal;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isGranted = false;
        try {
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "web_server.excep_authenticate_realmadapter", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(rb.getString("realmBase.forbidden"));
            return isGranted;
        }
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(rb.getString("realmBase.forbidden"));
        this.invokePostAuthenticateDelegate(request, response, context);
        return isGranted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeWebSecurityManager(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        WebSecurityManager secMgr;
        HttpServletRequest hrequest;
        boolean evaluated = false;
        try {
            this.rwLock.readLock().lock();
            evaluated = this.contextEvaluated;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (!evaluated) {
            try {
                this.rwLock.writeLock().lock();
                if (!this.contextEvaluated) {
                    Context context = (Context)this.getContainer();
                    LoginConfig config = context.getLoginConfig();
                    if (config != null && FORM.equals(config.getAuthMethod())) {
                        this.loginPage = config.getLoginPage();
                        this.errorPage = config.getErrorPage();
                    }
                    this.contextEvaluated = true;
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        if (this.loginPage != null || this.errorPage != null) {
            String requestURI = request.getRequestPathMB().toString();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security]  requestURI: " + requestURI + " loginPage: " + this.loginPage);
            }
            if (this.loginPage != null && this.loginPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to login page " + this.loginPage);
                }
                return true;
            }
            if (this.errorPage != null && this.errorPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to error page " + this.errorPage);
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to username/password submission");
                }
                return true;
            }
        }
        if ((hrequest = (HttpServletRequest)request).getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security] [ hasResourcePermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        if ((secMgr = this.getWebSecurityManager(true)) == null) {
            return false;
        }
        return secMgr.hasResourcePermission(hrequest);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        return this.hasUserDataPermission(request, response, constraints, null, null);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, String uri, String method) throws IOException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        if (hrequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security][ hasUserDataPermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        if (request.getRequest().isSecure()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] request.getRequest().isSecure(): " + request.getRequest().isSecure());
            }
            return true;
        }
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        int isGranted = 0;
        try {
            isGranted = secMgr.hasUserDataPermission(hrequest, uri, method);
        }
        catch (IllegalArgumentException e) {
            String msgWithId = rb.getString("realmAdapter.badRequestWithId");
            _logger.log(Level.WARNING, msgWithId, e);
            String msg = rb.getString("realmAdapter.badRequest");
            ((HttpServletResponse)response.getResponse()).sendError(400, msg);
            return false;
        }
        if (isGranted == -1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] redirecting using SSL");
            }
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            ((HttpServletResponse)response.getResponse()).sendError(403, rb.getString("realmBase.forbidden"));
            return false;
        }
        return true;
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.fine("[Web-Security]  SSL redirect is disabled");
            }
            hresponse.sendError(403, hrequest.getRequestURI());
            return false;
        }
        String protocol = "https";
        String serverHost = hrequest.getServerName();
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        try {
            url = new URL(protocol, serverHost, redirectPort, file.toString());
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            hresponse.sendError(500, hrequest.getRequestURI());
            return false;
        }
    }

    private String getCanonicalName(HttpRequest currentRequest) {
        return currentRequest.getWrapper().getServletName();
    }

    private String getResourceName(String uri, String contextPath) {
        if (contextPath.length() < uri.length()) {
            return uri.substring(contextPath.length());
        }
        return "";
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        WebSecurityManager secMgr;
        if (this.helper == null) {
            this.initConfigHelper();
        }
        if ((secMgr = this.getWebSecurityManager(false)) != null && secMgr.hasNoConstrainedResources() && !this.isSecurityExtensionEnabled()) {
            return null;
        }
        SecurityConstraint[] constraints = emptyConstraints;
        return constraints;
    }

    public SecurityConstraint[] findSecurityConstraints(String requestPathMB, String httpMethod, Context context) {
        WebSecurityManager secMgr;
        if (this.helper == null) {
            this.initConfigHelper();
        }
        if ((secMgr = this.getWebSecurityManager(false)) != null && secMgr.hasNoConstrainedResources() && !this.isSecurityExtensionEnabled()) {
            return null;
        }
        SecurityConstraint[] constraints = emptyConstraints;
        return constraints;
    }

    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        boolean isGranted = false;
        try {
            if (this.helper != null && this.helper.getServerAuthConfig() != null) {
                return 1;
            }
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "web_server.excep_authenticate_realmadapter", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(rb.getString("realmBase.forbidden"));
            return -1;
        }
        if (isGranted) {
            Object sharedState = null;
            boolean delegateSessionMgmt = false;
            if (((HttpServletRequest)request).getUserPrincipal() != null) {
                this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
                if (ssoEnabled) {
                    HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
                    WebSecurityManager webSecMgr = this.getWebSecurityManager(true);
                    if (!webSecMgr.permitAll(hreq)) {
                        hreq.getSession(true);
                    }
                }
            }
            return 0;
        }
        if (((HttpServletRequest)request).getUserPrincipal() != null) {
            ((HttpServletResponse)response.getResponse()).sendError(403);
            response.setDetailMessage(rb.getString("realmBase.forbidden"));
            return -1;
        }
        this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
        return 1;
    }

    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        boolean result = false;
        LoginConfig config = context.getLoginConfig();
        ServerAuthConfig serverAuthConfig = null;
        try {
            if (this.helper != null) {
                serverAuthConfig = this.helper.getServerAuthConfig();
            }
        }
        catch (Exception ex) {
            IOException iex = new IOException();
            iex.initCause(ex);
            throw iex;
        }
        result = serverAuthConfig != null ? this.validate(request, response, config, authenticator, calledFromAuthenticate) : ((AuthenticatorBase)authenticator).authenticate(request, response, config);
        return result;
    }

    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        boolean result = false;
        ServerAuthContext sAC = null;
        try {
            HttpServletRequest req;
            MessageInfo messageInfo;
            if (this.helper != null && (messageInfo = (MessageInfo)(req = (HttpServletRequest)request.getRequest()).getAttribute(MESSAGE_INFO)) != null && (sAC = (ServerAuthContext)messageInfo.getMap().get(SERVER_AUTH_CONTEXT)) != null) {
                AuthStatus authStatus = sAC.secureResponse(messageInfo, null);
                result = AuthStatus.SUCCESS.equals(authStatus);
            }
        }
        catch (AuthException ex) {
            IOException iex = new IOException();
            iex.initCause(ex);
            throw iex;
        }
        finally {
            if (this.helper != null && sAC != null) {
                if (request instanceof HttpRequestWrapper) {
                    request.removeNote("__javax.security.auth.message.request");
                }
                if (response instanceof HttpResponseWrapper) {
                    request.removeNote("__javax.security.auth.message.response");
                }
            }
        }
        return result;
    }

    public boolean isSecurityExtensionEnabled() {
        if (this.helper == null) {
            return false;
        }
        try {
            return this.helper.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private HttpServletHelper getConfigHelper() {
        HashMap<String, WebBundleDescriptor> map = new HashMap<String, WebBundleDescriptor>();
        map.put("WEB_BUNDLE", this.webDesc);
        return new HttpServletHelper(this.getAppContextID(), map, null, this._realmName, this.isSystemApp, defaultSystemProviderID);
    }

    private String getAppContextID() {
        return this.virtualServer.getName() + " " + this.webDesc.getContextRoot();
    }

    private boolean validate(HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        boolean isMandatory;
        boolean rvalue;
        HttpMessageInfo messageInfo;
        Subject subject;
        HttpServletResponse res;
        HttpServletRequest req;
        block17: {
            req = (HttpServletRequest)request.getRequest();
            res = (HttpServletResponse)response.getResponse();
            subject = new Subject();
            messageInfo = new HttpMessageInfo(req, res);
            rvalue = false;
            isMandatory = true;
            try {
                ServerAuthContext sAC;
                WebSecurityManager webSecMgr = this.getWebSecurityManager(true);
                boolean bl = isMandatory = !webSecMgr.permitAll(req);
                if (isMandatory || calledFromAuthenticate) {
                    messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
                }
                if ((sAC = this.helper.getServerAuthContext((MessageInfo)messageInfo, null)) != null) {
                    AuthStatus authStatus = sAC.validateRequest((MessageInfo)messageInfo, subject, null);
                    rvalue = AuthStatus.SUCCESS.equals(authStatus);
                    if (rvalue) {
                        messageInfo.getMap().put(SERVER_AUTH_CONTEXT, sAC);
                        req.setAttribute(MESSAGE_INFO, (Object)messageInfo);
                    }
                    break block17;
                }
                throw new AuthException("null ServerAuthContext");
            }
            catch (AuthException ae) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JMAC: http msg authentication fail", ae);
                }
                res.setStatus(500);
            }
        }
        if (rvalue) {
            Set<Principal> principalSet = subject.getPrincipals();
            if (principalSet != null && !principalSet.isEmpty() && !this.principalSetContainsOnlyAnonymousPrincipal(principalSet)) {
                HttpServletResponse newResponse;
                SecurityContext ctx = new SecurityContext(subject);
                Principal p = ctx.getCallerPrincipal();
                WebPrincipal wp = new WebPrincipal(p, ctx);
                try {
                    String authType = (String)messageInfo.getMap().get("javax.servlet.http.authType");
                    boolean register = messageInfo.getMap().containsKey("com.sun.web.RealmAdapter.register");
                    if (authType == null && config != null && config.getAuthMethod() != null) {
                        authType = config.getAuthMethod();
                    }
                    if (register) {
                        AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, (Principal)wp, authType);
                        proxy.authenticate(request, response, config);
                    } else {
                        request.setAuthType(authType == null ? PROXY_AUTH_TYPE : authType);
                        request.setUserPrincipal((Principal)wp);
                    }
                }
                catch (LifecycleException le) {
                    _logger.log(Level.SEVERE, "[Web-Security] unable to register session", le);
                }
                HttpServletRequest newRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (newRequest != req) {
                    request.setNote("__javax.security.auth.message.request", (Object)new HttpRequestWrapper(request, newRequest));
                }
                if ((newResponse = (HttpServletResponse)messageInfo.getResponseMessage()) != res) {
                    request.setNote("__javax.security.auth.message.response", (Object)new HttpResponseWrapper(response, newResponse));
                }
            } else if (isMandatory) {
                rvalue = false;
            }
        }
        return rvalue;
    }

    private static String getDefaultSystemProviderID() {
        String p = System.getProperty(SYSTEM_HTTPSERVLET_SECURITY_PROVIDER);
        if (p != null && (p = p.trim()).length() == 0) {
            p = null;
        }
        return p;
    }

    public void initializeRealm(Object descriptor, boolean isSystemApp, String realmName) {
        this.isSystemApp = isSystemApp;
        this.webDesc = (WebBundleDescriptor)descriptor;
        Application app = this.webDesc.getApplication();
        this.mapper = app.getRoleMapper();
        LoginConfiguration loginConfig = this.webDesc.getLoginConfiguration();
        this._realmName = app.getRealm();
        if (this._realmName == null && loginConfig != null) {
            this._realmName = loginConfig.getRealmName();
        }
        if (realmName != null && (this._realmName == null || this._realmName.equals(""))) {
            this._realmName = realmName;
        }
        this.CONTEXT_ID = WebSecurityManager.getContextID((WebBundleDescriptor)this.webDesc);
        this.runAsPrincipals = new HashMap();
        for (WebComponentDescriptor wcd : this.webDesc.getWebComponentDescriptors()) {
            RunAsIdentityDescriptor runAsDescriptor = wcd.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = wcd.getCanonicalName();
            if (principal == null || servlet == null) {
                _logger.warning("web.realmadapter.norunas");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            _logger.fine("Servlet " + servlet + " will run-as: " + principal);
        }
        this.appID = app.getRegistrationName();
    }

    protected void configureSecurity(WebBundleDescriptor wbd, boolean isSystem) {
        try {
            this.webSecurityManagerFactory.createManager(wbd, true, this.serverContext);
            String context = WebSecurityManager.getContextID((WebBundleDescriptor)wbd);
            SecurityUtil.generatePolicyFile((String)context);
            if (isSystem && context.equals("__admingui/__admingui")) {
                websecurityProbeProvider.policyCreationEvent(context);
            }
        }
        catch (Exception ce) {
            _logger.log(Level.SEVERE, "policy.configure", ce);
            throw new RuntimeException(ce);
        }
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal p) {
        if (p == null) {
            return null;
        }
        if (p instanceof WebPrincipal) {
            return ((WebPrincipal)p).getSecurityContext();
        }
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject s = new Subject();
                s.getPrincipals().add(p);
                return new SecurityContext(p.getName(), s);
            }
        });
    }

    public void setCurrentSecurityContextWithWebPrincipal(Principal principal) {
        if (principal instanceof WebPrincipal) {
            SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
        }
    }

    public void setCurrentSecurityContext(Principal principal) {
        SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
    }

    public synchronized void initConfigHelper() {
        if (this.helper != null) {
            return;
        }
        this.helper = this.getConfigHelper();
    }

    public void postConstruct() {
        this.webSecurityManagerFactory = this.habitat.getComponent(WebSecurityManagerFactory.class);
    }

    static class AuthenticatorProxy
    extends AuthenticatorBase {
        private AuthenticatorBase authBase;
        private Principal principal;
        private String authType;

        public boolean getCache() {
            return this.authBase.getCache();
        }

        public Container getContainer() {
            return this.authBase.getContainer();
        }

        AuthenticatorProxy(Authenticator authenticator, Principal p, String authType) throws LifecycleException {
            this.authBase = (AuthenticatorBase)authenticator;
            this.principal = p;
            this.authType = authType == null ? PROXY_AUTH_TYPE : authType;
            this.setCache(this.authBase.getCache());
            this.setContainer(this.authBase.getContainer());
            this.start();
        }

        public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
            this.register(request, response, this.principal, this.authType, this.principal.getName(), null);
            return true;
        }
    }

    private static class HttpMessageInfo
    implements MessageInfo {
        private Object request = null;
        private Object response = null;
        private Map map = new HashMap();

        HttpMessageInfo() {
        }

        HttpMessageInfo(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object getRequestMessage() {
            return this.request;
        }

        public Object getResponseMessage() {
            return this.response;
        }

        public void setRequestMessage(Object request) {
            this.request = request;
        }

        public void setResponseMessage(Object response) {
            this.response = response;
        }

        public Map getMap() {
            return this.map;
        }
    }
}

