/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class EchoAsyncWriteQueueFilter
implements ProtocolFilter {
    private ByteBufferCloner byteBufferCloner = new ByteBufferClonerImpl();

    public boolean execute(Context ctx) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer buffer = workerThread.getByteBuffer();
        buffer.flip();
        if (buffer.hasRemaining()) {
            try {
                if (ctx.getProtocol() == Controller.Protocol.TCP) {
                    ctx.getAsyncQueueWritable().writeToAsyncQueue(buffer, null, null, this.byteBufferCloner);
                } else if (ctx.getProtocol() == Controller.Protocol.UDP) {
                    SocketAddress address = (SocketAddress)ctx.getAttribute("socketAddress");
                    ctx.getAsyncQueueWritable().writeToAsyncQueue(address, buffer, null, null, this.byteBufferCloner);
                }
            }
            catch (IOException ex) {
                byte[] data = new byte[buffer.remaining()];
                int position = buffer.position();
                buffer.get(data);
                buffer.position(position);
                Controller.logger().log(Level.WARNING, "Exception. Echo \"" + new String(data) + "\"");
                throw ex;
            }
        }
        buffer.clear();
        return false;
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    private class ByteBufferClonerImpl
    implements ByteBufferCloner {
        private ByteBufferClonerImpl() {
        }

        public ByteBuffer clone(ByteBuffer originalByteBuffer) {
            ByteBuffer newBB = ByteBufferFactory.allocateView((int)originalByteBuffer.remaining(), (boolean)originalByteBuffer.isDirect());
            newBB.put(originalByteBuffer);
            newBB.flip();
            return newBB;
        }
    }
}

