/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMain;
import com.sun.enterprise.glassfish.bootstrap.ASMainOSGi;
import com.sun.enterprise.glassfish.bootstrap.ClassPathBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ASMainFelix
extends ASMainOSGi {
    private static final String FELIX_HOME = "FELIX_HOME";
    protected static final String CACHE_DIR = "org.osgi.framework.storage";
    public static final String GF_FELIX_HOME = "osgi/felix";
    public static final String CONFIG_PROPERTIES = "conf/config.properties";
    public static final String SYSTEM_PROPERTIES = "conf/system.properties";

    protected String getPreferedCacheDir() {
        return "osgi-cache/felix/";
    }

    public String getName() {
        return ASMain.Platform.Felix.toString();
    }

    protected void setFwDir() {
        String fwPath = System.getenv(FELIX_HOME);
        if (fwPath == null) {
            fwPath = System.getProperty(FELIX_HOME, new File(this.glassfishDir, GF_FELIX_HOME).getAbsolutePath());
        }
        this.fwDir = new File(fwPath);
        if (!this.fwDir.exists()) {
            throw new RuntimeException("Can't locate Felix at " + fwPath);
        }
    }

    protected void setUpCache(File sourceDir, File cacheDir) throws IOException {
        System.setProperty(CACHE_DIR, cacheDir.getCanonicalPath());
    }

    protected void addFrameworkJars(ClassPathBuilder cpb) throws IOException {
        cpb.addJar(new File(this.fwDir, "bin/felix.jar"));
    }

    protected void launchOSGiFW() throws Exception {
        String sysFileURL = new File(this.fwDir, SYSTEM_PROPERTIES).toURI().toURL().toString();
        System.setProperty("felix.system.properties", sysFileURL);
        String confFileURL = new File(this.fwDir, CONFIG_PROPERTIES).toURI().toURL().toString();
        System.setProperty("felix.config.properties", confFileURL);
        Class<?> mc = this.launcherCL.loadClass(this.getFWMainClassName());
        final String[] args = new String[]{};
        final Method m = mc.getMethod("main", args.getClass());
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    m.invoke(null, new Object[]{args});
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "OSGi Framework Launcher");
        launcherThread.setDaemon(false);
        launcherThread.start();
    }

    private String getFWMainClassName() {
        return "org.apache.felix.main.Main";
    }
}

