/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.webservice.member.at;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.tx.TXException;
import com.sun.xml.ws.developer.MemberSubmissionAddressing;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.developer.Stateful;
import com.sun.xml.ws.developer.StatefulWebServiceManager;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.at.ATParticipant;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.webservice.member.at.Notification;
import com.sun.xml.ws.tx.webservice.member.at.ParticipantPortType;
import java.util.logging.Level;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MemberSubmissionAddressing
@Stateful
@WebService(serviceName="WSATCoordinator", portName="Participant", endpointInterface="com.sun.xml.ws.tx.webservice.member.at.ParticipantPortType", targetNamespace="http://schemas.xmlsoap.org/ws/2004/10/wsat", wsdlLocation="WEB-INF/wsdl/wsat.wsdl")
public class ParticipantPortTypeImpl
implements ParticipantPortType {
    public static final String serviceName = "WSATCoordinator";
    public static final String portName = "Participant";
    private static final TxLogger logger = TxLogger.getLogger(ParticipantPortTypeImpl.class);
    @Resource
    private WebServiceContext wsContext;
    private static StatefulWebServiceManager<ParticipantPortTypeImpl> manager;
    private String activityId;
    private String participantId;
    private EndpointReference fallbackEPR;
    private ATParticipant participant;

    public ParticipantPortTypeImpl() {
    }

    public ParticipantPortTypeImpl(String activityId, String participantId) {
        this.activityId = activityId;
        this.participantId = participantId;
    }

    private void initPerOperationData() {
        block14: {
            this.participant = null;
            this.fallbackEPR = null;
            if (this.wsContext != null) {
                MessageContext mc = this.wsContext.getMessageContext();
                if (mc != null) {
                    HeaderList hdrLst = (HeaderList)mc.get((Object)"com.sun.xml.ws.api.message.HeaderList");
                    if (hdrLst != null) {
                        this.fallbackEPR = hdrLst.getReplyTo(AddressingVersion.MEMBER, SOAPVersion.SOAP_11).toSpec(MemberSubmissionEndpointReference.class);
                    } else if (logger.isLogging(Level.WARNING)) {
                        logger.warning("initOperationData", "INBOUND_HEADER_LIST_PROPERTY unexpectedly null");
                    }
                } else if (logger.isLogging(Level.WARNING)) {
                    logger.warning("initOperationData", "WebServiceContext.getMessageContext() unexpectedly null");
                }
            } else if (logger.isLogging(Level.WARNING)) {
                logger.warning("initContextFromIncomingMessage", "wsContext unexpectedly null");
            }
            ATCoordinator coordinator = null;
            if ("-1".equals(this.activityId)) {
                if (logger.isLogging(Level.INFO)) {
                    logger.info("Two Phase Commit Participant", "handling notification for an unknown transaction");
                }
                return;
            }
            coordinator = (ATCoordinator)CoordinationManager.getInstance().getCoordinator(this.activityId);
            if (coordinator != null) {
                try {
                    this.participant = (ATParticipant)coordinator.getRegistrant(this.participantId);
                }
                catch (ClassCastException ce) {
                    if (!logger.isLogging(Level.WARNING)) break block14;
                    logger.warning("getATPartcipant", ce.getLocalizedMessage());
                }
            }
        }
    }

    @Override
    public void prepareOperation(Notification parameters) {
        String METHOD_NAME = "prepareOperation";
        this.initPerOperationData();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("prepareOperation", this.getCoordIdPartId());
        }
        if (this.participant != null) {
            try {
                this.participant.prepare();
            }
            catch (TXException ex) {
                if (logger.isLogging(Level.WARNING)) {
                    logger.warning("prepareOperation", "caught TXException during prepare");
                }
            }
        } else if (this.fallbackEPR != null) {
            if (logger.isLogging(Level.WARNING)) {
                logger.warning("prepareOperation", "Unknown participant " + this.getCoordIdPartId() + " reply with aborted to " + this.fallbackEPR);
            }
            ATParticipant.getATCoordinatorWS(this.fallbackEPR, null, false).abortedOperation(null);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("prepareOperation", "required wsa:ReplyTo property not found");
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("prepareOperation", this.getCoordIdPartId());
        }
    }

    @Override
    public void commitOperation(Notification parameters) {
        String METHOD_NAME = "commitOperation";
        this.initPerOperationData();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("commitOperation", this.getCoordIdPartId());
        }
        if (this.participant != null) {
            try {
                this.participant.commit();
            }
            catch (TXException ex) {
                if (logger.isLogging(Level.WARNING)) {
                    logger.warning("commitOperation", ex.getLocalizedMessage());
                }
            }
        } else if (this.fallbackEPR != null) {
            if (logger.isLogging(Level.WARNING)) {
                logger.warning("commitOperation", "Unknown participant " + this.getCoordIdPartId() + " reply with committed to " + this.fallbackEPR);
            }
            ATParticipant.getATCoordinatorWS(this.fallbackEPR, null, false).committedOperation(null);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("commitOperation", "required wsa:ReplyTo property not found");
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("commitOperation", this.getCoordIdPartId());
        }
    }

    @Override
    public void rollbackOperation(Notification parameters) {
        String METHOD_NAME = "rollbackOperation";
        this.initPerOperationData();
        if (logger.isLogging(Level.FINER)) {
            logger.entering("rollbackOperation", parameters);
        }
        if (this.participant != null) {
            this.participant.abort();
        } else if (this.fallbackEPR != null) {
            if (logger.isLogging(Level.WARNING)) {
                logger.warning("rollbackOperation", "Unknown participant " + this.getCoordIdPartId() + " reply with aborted to" + this.fallbackEPR);
            }
            ATParticipant.getATCoordinatorWS(this.fallbackEPR, null, false).abortedOperation(null);
        } else if (logger.isLogging(Level.SEVERE)) {
            logger.severe("rollbackOperation", "required wsa:ReplyTo property not found");
        }
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("rollbackOperation", this.getCoordIdPartId());
        }
    }

    private String getCoordIdPartId() {
        return "CoorId=" + this.activityId + " PartId=" + this.participantId + " ";
    }

    public static StatefulWebServiceManager<ParticipantPortTypeImpl> getManager() {
        return manager;
    }

    public static void setManager(StatefulWebServiceManager<ParticipantPortTypeImpl> aManager) {
        manager = aManager;
    }
}

