/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class FlowHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        if (DEBUG) {
            this.logger.log(1, "FlowHandler: handle() [ Received Flow  Message]");
        }
        assert (packet.getPacketType() == 52);
        Hashtable hashtable = null;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error: unable to retrieve  properties from resume message " + packet, (Throwable)exception);
            hashtable = new Hashtable();
        }
        Integer n = null;
        Consumer consumer = null;
        if (hashtable != null) {
            Long l;
            n = (Integer)hashtable.get("JMQSize");
            if (n == null) {
                n = (Integer)hashtable.get("JMQRBufferSize");
            }
            if ((l = (Long)hashtable.get("JMQConsumerID")) != null) {
                ConsumerUID consumerUID = new ConsumerUID(l);
                consumer = Consumer.getConsumer(consumerUID);
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Setting JMQRBufferSize -" + n);
        }
        if (consumer != null) {
            int n2 = n == null ? -1 : n;
            this.consumerFlow(consumer, n2);
        } else {
            int n3 = n == null ? -1 : n;
            this.connectionFlow(iMQConnection, n3);
        }
        return true;
    }

    public void consumerFlow(Consumer consumer, int n) {
        try {
            int n2 = Consumer.calcPrefetch(consumer, n);
            consumer.resumeFlow(n2);
        }
        catch (Exception exception) {
            this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "protocol error, bad rbuf size"), (Throwable)exception);
            consumer.resumeFlow(-1);
        }
    }

    public void connectionFlow(IMQConnection iMQConnection, int n) {
        iMQConnection.resumeFlow(n);
    }
}

