/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class HelloHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();
    private BrokerResources rb = Globals.getBrokerResources();
    private static boolean DEBUG;
    private static boolean ALLOW_C_CLIENTS;
    private static boolean CAN_RECONNECT;

    public static void DUMP(String string) {
        Globals.getLogger().log(4, string);
        Globals.getLogger().log(4, "------------------------");
        Globals.getLogger().log(4, "Number of connections is " + Globals.getConnectionManager().getNumConnections(null));
        List list = Globals.getConnectionManager().getConnectionList(null);
        for (int i = 0; i < list.size(); ++i) {
            Connection connection = (Connection)list.get(i);
            Globals.getLogger().log(4, "\t" + i + "\t" + (Object)((Object)connection.getConnectionUID()) + " :" + connection.getRemoteConnectionString());
        }
        Globals.getLogger().log(4, "------------------------");
    }

    public HelloHandler(ConnectionManager connectionManager) {
        this.connectionList = connectionManager;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        int n;
        Serializable serializable;
        Object object2;
        block86: {
            block85: {
                Object object3;
                HashSet<String> hashSet;
                Object object4;
                Hashtable hashtable;
                block84: {
                    block83: {
                        Object object5;
                        Object object6;
                        String string;
                        if (DEBUG) {
                            this.logger.log(1, "HelloHandler: handle() [ Received Hello Message]");
                        }
                        String string2 = null;
                        hashtable = null;
                        try {
                            hashtable = packet.getProperties();
                        }
                        catch (Exception exception) {
                            this.logger.log(8, "Internal Error: error  retrieving properties from hello message ", (Throwable)exception);
                            hashtable = new Hashtable();
                        }
                        boolean bl = iMQConnection.isStarted();
                        boolean bl2 = iMQConnection.isAuthenticated();
                        int n2 = 0;
                        int n3 = iMQConnection.getHighestSupportedProtocol();
                        int n4 = 100;
                        String string3 = null;
                        UID uID = null;
                        ConnectionUID connectionUID = null;
                        Integer n5 = null;
                        boolean bl3 = false;
                        if (hashtable != null) {
                            Integer n6 = (Integer)hashtable.get("JMQProtocolLevel");
                            n2 = n6 == null ? 100 : n6;
                            n5 = (Integer)hashtable.get("JMQSize");
                            if (n5 == null) {
                                n5 = (Integer)hashtable.get("JMQRBufferSize");
                            }
                            if ((object2 = (Long)hashtable.get("JMQStoreSession")) != null) {
                                uID = new UID(((Long)object2).longValue());
                            }
                            string3 = (String)hashtable.get("JMQClusterID");
                            serializable = (Boolean)hashtable.get("JMQReconnectable");
                            Boolean bl4 = (Boolean)hashtable.get("JMQHAClient");
                            if (Globals.getHAEnabled() && bl4 != null && bl4.booleanValue()) {
                                serializable = bl4;
                            }
                            string = (String)hashtable.get("JMQUserAgent");
                            if (!ALLOW_C_CLIENTS && string != null && string.indexOf("C;") != -1) {
                                bl3 = true;
                            }
                            if (string != null) {
                                iMQConnection.addClientData("useragent", string);
                            }
                            if ((object2 = (Long)hashtable.get("JMQConnectionID")) != null) {
                                this.logger.log(4, "Have old connectionUID");
                                connectionUID = new ConnectionUID((Long)object2);
                                this.logger.log(8, "B1122", (Object)connectionUID);
                                this.logger.log(4, "Checking for active connection");
                                object6 = Globals.getConnectionManager().getConnection(connectionUID);
                                HelloHandler.DUMP("Before connection Destroy");
                                if (object6 != null) {
                                    this.logger.log(4, "Destroying old connection " + (Object)((Object)connectionUID));
                                    ((Connection)object6).destroyConnection(true, 3, "Destroying old connection with same connectionUID " + (Object)((Object)connectionUID) + " - reconnect is happening before connection was reaped");
                                }
                                HelloHandler.DUMP("After Connection Destroy");
                            }
                            iMQConnection.getConnectionUID().setCanReconnect(serializable == null ? false : (Boolean)serializable);
                            object6 = (Long)hashtable.get("JMQInterval");
                            long l = object6 == null ? 10000L : (long)((Long)object6).intValue();
                            iMQConnection.setReconnectInterval(l);
                        } else {
                            n2 = 100;
                        }
                        int n7 = 0;
                        n7 = n2 > n3 ? n3 : (n2 < n4 ? n4 : n2);
                        iMQConnection.setClientProtocolVersion(n7);
                        if (n5 != null) {
                            this.logger.log(4, "Received JMQRBufferSize -" + n5);
                            iMQConnection.setFlowCount(n5);
                        }
                        object2 = new Packet(iMQConnection.useDirectBuffers());
                        object2.setPacketType(11);
                        object2.setConsumerID(packet.getConsumerID());
                        serializable = new Hashtable();
                        string2 = "unavailable";
                        n = 503;
                        if (iMQConnection.getRemoteIP() == null) {
                            iMQConnection.setRemoteIP(packet.getIP());
                        }
                        if ((bl2 || bl) && !packet.getIndempotent()) {
                            n = 500;
                            string2 = "Connection reuse not allowed";
                            if (bl2) {
                                this.logger.log(16, "Internal Error:  received HELLO on already authenticated connection " + iMQConnection.getRemoteConnectionString() + " " + (Object)((Object)iMQConnection.getConnectionUID()));
                            } else {
                                this.logger.log(16, "Internal Error:  received HELLO on already started connection " + iMQConnection.getRemoteConnectionString() + " " + (Object)((Object)iMQConnection.getConnectionUID()));
                            }
                        } else if (bl3) {
                            this.logger.log(32, "B3122", (Object)Globals.getBrokerResources().getString("B0046"));
                            string2 = "C clients not allowed on this version";
                            n = 503;
                        } else if (!CAN_RECONNECT && iMQConnection.getConnectionUID().getCanReconnect()) {
                            this.logger.log(32, "B3122", (Object)Globals.getBrokerResources().getString("B0047"));
                            string2 = "Client Failover not allowed on this version";
                        } else if (n2 != n7) {
                            this.logger.log(16, "B2052", (Object)Integer.toString(n2), (Object)Integer.toString(n7));
                            string2 = "bad version";
                            n = 505;
                        } else if (iMQConnection.getConnectionState() != -1) {
                            if (iMQConnection.setConnectionState(1)) {
                                string2 = null;
                                n = 200;
                            } else {
                                n = 503;
                            }
                        } else {
                            n = 503;
                        }
                        string = Globals.getBrokerSessionID();
                        if (string != null) {
                            ((Hashtable)serializable).put("JMQBrokerSessionID", new Long(string.longValue()));
                        }
                        object6 = null;
                        UID uID2 = null;
                        Object var22_26 = null;
                        ClusterManager clusterManager = Globals.getClusterManager();
                        if (clusterManager != null) {
                            object6 = clusterManager.getClusterId();
                            uID2 = clusterManager.getStoreSessionUID();
                            ((Hashtable)serializable).put("JMQHA", clusterManager.isHA());
                            if (object6 != null) {
                                ((Hashtable)serializable).put("JMQClusterID", object6);
                            }
                            if (uID2 != null) {
                                ((Hashtable)serializable).put("JMQStoreSession", new Long(uID2.longValue()));
                            }
                            object5 = null;
                            object4 = clusterManager.getKnownBrokers();
                            hashSet = new HashSet<String>();
                            while (object4.hasNext()) {
                                object3 = (ClusteredBroker)object4.next();
                                hashSet.add(object3.getBrokerURL().toString());
                            }
                            object4 = hashSet.iterator();
                            while (object4.hasNext()) {
                                if (object5 == null) {
                                    object5 = object4.next().toString();
                                    continue;
                                }
                                object5 = (String)object5 + "," + object4.next().toString();
                            }
                            if (object5 != null) {
                                ((Hashtable)serializable).put("JMQBrokerList", object5);
                            }
                        }
                        if ((object5 = Globals.getHAMonitorService()) != null && ((HAMonitorService)object5).inTakeover() && ((IMQService)iMQConnection.getService()).getServiceType() != 1) {
                            n = 408;
                            if (connectionUID != null) {
                                this.logger.log(8, "B2193", (Object)connectionUID);
                            } else {
                                this.logger.log(8, "B2193", (Object)iMQConnection.getConnectionUID());
                            }
                        }
                        if (object6 != null && string3 != null && !((String)object6).equals(string3)) {
                            n = 400;
                        } else if (!(uID != null && uID2 != null && uID.equals((Object)uID2) || uID == null)) {
                            if (clusterManager == null) {
                                this.logger.log(16, "B3100", (Object)"Internal Error: Received session on non-clustered broker");
                                n = 404;
                            } else {
                                object4 = null;
                                hashSet = clusterManager.getSupportedStoreSessionUIDs();
                                if (hashSet.contains(uID)) {
                                    object4 = clusterManager.getLocalBroker();
                                }
                                if (object4 == null && (object3 = clusterManager.lookupStoreSessionOwner(uID)) != null) {
                                    object4 = clusterManager.getBroker((String)object3);
                                }
                                try {
                                    if (object4 != null) {
                                        int n8;
                                        object3 = null;
                                        object = clusterManager.getStoreSessionCreator(uID);
                                        if (object != null) {
                                            object3 = clusterManager.getBroker((String)object);
                                        }
                                        if (BrokerStatus.getBrokerInDoubt(n8 = object4.getStatus()) || !BrokerStatus.getBrokerLinkIsUp(n8) || object4.getState() == BrokerState.FAILOVER_STARTED) {
                                            n = 408;
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1255", uID, object4));
                                        } else if (!object4.isLocalBroker()) {
                                            n = 301;
                                            ((Hashtable)serializable).put("JMQStoreOwner", object4.getBrokerURL().toString());
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1256", uID, object4));
                                        } else if (object3 == null) {
                                            n = 404;
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1257", uID));
                                        } else if (object3.getState() == BrokerState.FAILOVER_STARTED) {
                                            n = 408;
                                            this.logger.log(8, Globals.getBrokerResources().getKString("B1258", uID));
                                        } else {
                                            ((Hashtable)serializable).put("JMQStoreOwner", object4.getBrokerURL().toString());
                                        }
                                    } else {
                                        n = 404;
                                        this.logger.log(8, Globals.getBrokerResources().getKString("B1259", uID));
                                    }
                                }
                                catch (Exception exception) {
                                    this.logger.log(16, "B2131", (Object)uID.toString(), (Throwable)exception);
                                    n = 404;
                                }
                            }
                        }
                        if (!iMQConnection.isAdminConnection() && Globals.getMemManager() != null) {
                            ((Hashtable)serializable).put("JMQSize", new Integer(Globals.getMemManager().getJMQSize()));
                            ((Hashtable)serializable).put("JMQBytes", new Long(Globals.getMemManager().getJMQBytes()));
                            ((Hashtable)serializable).put("JMQMaxMsgBytes", new Long(Globals.getMemManager().getJMQMaxMsgBytes()));
                        }
                        if (string2 != null) {
                            ((Hashtable)serializable).put("JMQReason", string2);
                        }
                        ((Hashtable)serializable).put("JMQService", iMQConnection.getService().getName());
                        ((Hashtable)serializable).put("JMQStatus", new Integer(n));
                        ((Hashtable)serializable).put("JMQConnectionID", new Long(iMQConnection.getConnectionUID().longValue()));
                        ((Hashtable)serializable).put("JMQProtocolLevel", new Integer(n7));
                        ((Hashtable)serializable).put("JMQVersion", Globals.getVersion().getProductVersion());
                        IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)iMQConnection;
                        if (IMQBasicConnection.getDumpPacket()) break block83;
                        IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)iMQConnection;
                        if (!IMQBasicConnection.getDumpOutPacket()) break block84;
                    }
                    ((Hashtable)serializable).put("JMQReqID", packet.getSysMessageID().toString());
                }
                try {
                    object4 = Globals.getCurrentLicense(null);
                    ((Hashtable)serializable).put("JMQLicense", ((LicenseBase)object4).getProperty("imq.license_type"));
                    ((Hashtable)serializable).put("JMQLicenseDesc", ((LicenseBase)object4).getProperty("description"));
                }
                catch (BrokerException brokerException) {
                    ((Hashtable)serializable).put("JMQLicenseDesc", brokerException.toString());
                }
                object2.setProperties((Hashtable)serializable);
                iMQConnection.sendControlMessage((Packet)object2);
                if (n != 200 && n != 301 && n != 404 && n != 408) {
                    iMQConnection.closeConnection(true, 4, Globals.getBrokerResources().getKString("B0063"));
                    this.connectionList.removeConnection(iMQConnection.getConnectionUID(), false, 4, Globals.getBrokerResources().getKString("B0063"));
                    return true;
                }
                n = 503;
                object4 = null;
                if (hashtable != null) {
                    object4 = (String)hashtable.get("JMQAuthType");
                }
                hashSet = iMQConnection.getAccessController();
                object2 = new Packet(iMQConnection.useDirectBuffers());
                object2.setPacketType(38);
                object2.setConsumerID(packet.getConsumerID());
                serializable = new Hashtable();
                ((Hashtable)serializable).put("JMQSequence", new Integer(packet.getSequence()));
                ((Hashtable)serializable).put("JMQChallenge", true);
                object3 = new Properties();
                ((Properties)object3).setProperty("imq.clientIP", packet.getIPString());
                ((Properties)object3).setProperty("imq.connectionID", iMQConnection.getConnectionUID().toString());
                object = null;
                try {
                    AuthCacheData authCacheData = ((IMQService)iMQConnection.getService()).getAuthCacheData();
                    object = ((AccessController)((Object)hashSet)).getChallenge(packet.getSequence(), (Properties)object3, authCacheData.getCacheData(), (String)object4);
                    ((Hashtable)serializable).put("JMQAuthType", ((AccessController)((Object)hashSet)).getAuthType());
                    if (iMQConnection.setConnectionState(2)) {
                        n = 200;
                    }
                }
                catch (FailedLoginException failedLoginException) {
                    this.logger.log(16, failedLoginException.getMessage(), (Throwable)failedLoginException);
                    n = 403;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw outOfMemoryError;
                }
                catch (Throwable throwable) {
                    this.logger.log(32, Globals.getBrokerResources().getKString("B3060") + " - " + throwable.getMessage(), throwable);
                    n = 403;
                }
                ((Hashtable)serializable).put("JMQStatus", new Integer(n));
                IMQBasicConnection cfr_ignored_2 = (IMQBasicConnection)iMQConnection;
                if (IMQBasicConnection.getDumpPacket()) break block85;
                IMQBasicConnection cfr_ignored_3 = (IMQBasicConnection)iMQConnection;
                if (!IMQBasicConnection.getDumpOutPacket()) break block86;
            }
            ((Hashtable)serializable).put("JMQReqID", packet.getSysMessageID().toString());
        }
        object2.setProperties((Hashtable)serializable);
        if (object != null) {
            object2.setMessageBody((byte[])object);
        }
        iMQConnection.sendControlMessage((Packet)object2);
        if (DEBUG) {
            this.logger.log(4, "HelloHandler: handle() [ sent challenge ]:status=" + Status.getString((int)n));
        }
        if (n != 200 && n != 301 && n != 404 && n != 408) {
            iMQConnection.closeConnection(true, 4, Globals.getBrokerResources().getKString("B0063"));
            this.connectionList.removeConnection(iMQConnection.getConnectionUID(), false, 4, Globals.getBrokerResources().getKString("B0063"));
        }
        return true;
    }

    static {
        LicenseBase licenseBase;
        DEBUG = false;
        ALLOW_C_CLIENTS = false;
        CAN_RECONNECT = false;
        try {
            licenseBase = Globals.getCurrentLicense(null);
            ALLOW_C_CLIENTS = licenseBase.getBooleanProperty("imq.enable_c_api", false);
        }
        catch (BrokerException brokerException) {
            ALLOW_C_CLIENTS = false;
        }
        try {
            licenseBase = Globals.getCurrentLicense(null);
            CAN_RECONNECT = licenseBase.getBooleanProperty("imq.enable_reconnect", false);
        }
        catch (BrokerException brokerException) {
            CAN_RECONNECT = false;
        }
    }
}

