/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransaction2PCompleteEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransaction2PPrepareEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.RemoteTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashSet;

public class RemoteTransactionManager
extends BaseTransactionManager {
    RemoteTransactionManager(TransactionLogManager transactionLogManager) {
        super(transactionLogManager);
    }

    void processStoredTxnOnStartup(BaseTransaction baseTransaction) {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " processStoredTxnOnStartup " + baseTransaction;
            logger.log(4, (String)object);
        }
        object = baseTransaction.getTid();
        int n = baseTransaction.getState();
        if (n == 6 || n == 7) {
            this.addToCompleteStored(baseTransaction);
        } else if (n == 5) {
            this.addToIncompleteStored(baseTransaction);
        }
    }

    TransactionEvent generateEvent(BaseTransaction baseTransaction, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " generateEvent ");
        }
        RemoteTransactionEvent remoteTransactionEvent = null;
        if (bl) {
            remoteTransactionEvent = new RemoteTransaction2PCompleteEvent();
        } else if (baseTransaction.getState() == 5) {
            remoteTransactionEvent = new RemoteTransaction2PPrepareEvent();
        } else {
            throw new UnsupportedOperationException();
        }
        remoteTransactionEvent.remoteTransaction = (RemoteTransaction)baseTransaction;
        return remoteTransactionEvent;
    }

    void processTxn(BaseTransaction baseTransaction) throws IOException, BrokerException {
        int n;
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " processTxn " + baseTransaction;
            logger.log(4, string);
        }
        if ((n = baseTransaction.getState()) != 5) {
            throw new UnsupportedOperationException();
        }
        this.addToIncompleteUnstored(baseTransaction);
    }

    BaseTransaction processTxnCompletion(TransactionUID transactionUID, int n) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " processTxnCompletion " + transactionUID);
        }
        boolean bl = true;
        return this.processTxnCompletion(transactionUID, n, bl);
    }

    void replayTransactionEvent(TransactionEvent transactionEvent, HashSet hashSet) throws BrokerException, IOException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " replayTransactionEvent");
        }
        RemoteTransactionEvent remoteTransactionEvent = (RemoteTransactionEvent)transactionEvent;
        RemoteTransaction remoteTransaction = remoteTransactionEvent.remoteTransaction;
        int n = remoteTransaction.getState();
        TransactionUID transactionUID = remoteTransaction.getTid();
        if (remoteTransactionEvent.getSubType() == 1) {
            if (this.incompleteStored.containsKey(transactionUID)) {
                if (Store.getDEBUG()) {
                    String string = this.getPrefix() + " found matching txn in prepared store on replay " + remoteTransaction;
                    Globals.getLogger().log(4, string);
                }
            } else {
                this.addToIncompleteUnstored(remoteTransaction);
            }
        } else if (remoteTransactionEvent.getSubType() == 2) {
            BaseTransaction baseTransaction = null;
            if (this.incompleteUnstored.containsKey(transactionUID)) {
                baseTransaction = this.removeFromIncompleteUnstored(transactionUID);
            } else if (this.incompleteStored.containsKey(transactionUID)) {
                baseTransaction = this.removeFromIncompleteStored(transactionUID);
                this.updateStoredState(transactionUID, n);
                this.addToCompleteStored(baseTransaction);
            } else if (this.completeStored.containsKey(transactionUID)) {
                baseTransaction = (BaseTransaction)this.completeStored.get(transactionUID);
            }
            if (baseTransaction != null) {
                RemoteTransaction remoteTransaction2 = (RemoteTransaction)baseTransaction;
                if (n == 6) {
                    TransactionAcknowledgement[] transactionAcknowledgementArray = remoteTransaction2.getTxnAcks();
                    DestinationUID[] destinationUIDArray = remoteTransaction2.getDestIds();
                    this.transactionLogManager.transactionLogReplayer.replayRemoteAcks(transactionAcknowledgementArray, destinationUIDArray, transactionUID, hashSet);
                }
            } else {
                logger.log(32, "Could not find prepared work for completing two-phase transaction " + remoteTransaction.getTid());
            }
        }
    }

    String getPrefix() {
        return "RemoteTransactionManager: " + Thread.currentThread().getName();
    }
}

