/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap interestMap = new ConcurrentHashMap(256);

    InterestStore() {
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Consumers", String.valueOf(this.interestMap.size()));
        return hashtable;
    }

    public void printInfo(PrintStream printStream) {
        printStream.println("\nInterests");
        printStream.println("---------");
        printStream.println("number of interests:   " + this.interestMap.size());
    }

    void storeInterest(Consumer consumer) throws IOException, BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        try {
            Consumer consumer2 = this.interestMap.putIfAbsent(consumerUID, consumer);
            if (consumer2 != null) {
                this.logger.log(32, "B3010", (Object)consumerUID, (Object)consumer.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3010", consumerUID, consumer.getDestinationUID().getLongString()));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4012", (Object)consumerUID, (Throwable)runtimeException);
            throw runtimeException;
        }
    }

    void removeInterest(Consumer consumer) throws IOException, BrokerException {
        Object var2_2 = null;
        ConsumerUID consumerUID = consumer.getConsumerUID();
        try {
            var2_2 = this.interestMap.remove(consumerUID);
            if (var2_2 == null) {
                this.logger.log(32, "B3011", (Object)consumerUID, (Object)consumer.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3011", consumerUID, consumer.getDestinationUID().getLongString()));
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.log(32, "B4034", (Object)consumerUID);
            throw new BrokerException(this.br.getString("B4034", consumerUID), runtimeException);
        }
    }

    Consumer[] getAllInterests() throws IOException {
        return this.interestMap.values().toArray(new Consumer[0]);
    }

    void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore.clearAll() called");
        }
        this.interestMap.clear();
    }

    void close(boolean bl) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore: closing, " + this.interestMap.size() + " in-memory interests");
        }
        this.interestMap.clear();
    }
}

