/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ASTPair;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.CodeGeneration;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.OptimizerTokenTypes;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.FieldInfo;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumberType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.NumericWrapperClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class Optimizer
extends TreeParser
implements OptimizerTokenTypes {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(Optimizer.class);
    protected TypeTable typetab;
    protected ParameterTable paramtab;
    protected ErrorMsg errorMsg;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"import\"", "\"this\"", "\"ascending\"", "\"descending\"", "\"distinct\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "\"null\"", "\"true\"", "\"false\"", "\"avg\"", "\"max\"", "\"min\"", "\"sum\"", "\"count\"", "LPAREN", "RPAREN", "COMMA", "EQUAL", "LNOT", "BNOT", "NOT_EQUAL", "DIV", "PLUS", "MINUS", "STAR", "MOD", "GE", "GT", "LE", "LT", "BXOR", "BOR", "OR", "BAND", "AND", "SEMI", "WS", "NEWLINE", "CHAR_LITERAL", "STRING_LITERAL", "ESC", "HEX_DIGIT", "INT_LITERAL", "EXPONENT", "FLOATINGPOINT_SUFFIX", "an identifier", "UNICODE_ESCAPE", "QUERY", "CLASS_DEF", "IMPORT_DEF", "PARAMETER_DEF", "VARIABLE_DEF", "ORDERING_DEF", "FILTER_DEF", "ARG_LIST", "UNARY_MINUS", "UNARY_PLUS", "TYPECAST", "OBJECT_EQUAL", "OBJECT_NOT_EQUAL", "COLLECTION_EQUAL", "COLLECTION_NOT_EQUAL", "CONCAT", "FIELD_ACCESS", "STATIC_FIELD_ACCESS", "CONTAINS", "NOT_CONTAINS", "NAVIGATION", "STARTS_WITH", "ENDS_WITH", "IS_EMPTY", "VARIABLE", "PARAMETER", "TYPENAME", "VALUE", "RESULT_DEF", "LIKE", "SUBSTRING", "INDEXOF", "LENGTH", "ABS", "SQRT", "NOT_IN", "DOT", "LONG_LITERAL", "FLOAT_LITERAL", "DOUBLE_LITERAL"};

    public void init(TypeTable typetab, ParameterTable paramtab, ErrorMsg errorMsg) {
        this.typetab = typetab;
        this.paramtab = paramtab;
        this.errorMsg = errorMsg;
    }

    public void reportError(RecognitionException ex) {
        this.errorMsg.fatal("Optimizer error", (Exception)ex);
    }

    public void reportError(String s) {
        this.errorMsg.fatal("Optimizer error: " + s);
    }

    protected static char parseChar(String text) {
        char first = text.charAt(0);
        if (first == '\\') {
            char second = text.charAt(1);
            switch (second) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 't': {
                    return '\t';
                }
                case 'b': {
                    return '\b';
                }
                case 'f': {
                    return '\f';
                }
                case 'u': {
                    return (char)Integer.parseInt(text.substring(2, text.length()), 16);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    return (char)Integer.parseInt(text.substring(1, text.length()), 8);
                }
            }
            return second;
        }
        return first;
    }

    protected JQLAST checkAnd(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (this.isBooleanValueAST(left)) {
            ast = this.handleValueAndExpr(op, left.getValue(), right);
        } else if (this.isBooleanValueAST(right)) {
            ast = this.handleValueAndExpr(op, right.getValue(), left);
        }
        return ast;
    }

    protected JQLAST checkOr(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (this.isBooleanValueAST(left)) {
            ast = this.handleValueOrExpr(op, left.getValue(), right);
        } else if (this.isBooleanValueAST(right)) {
            ast = this.handleValueOrExpr(op, right.getValue(), left);
        }
        return ast;
    }

    protected JQLAST checkEqualityOp(JQLAST op, JQLAST left, JQLAST right, boolean negate) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            ast = this.handleValueEqValue(op, left, right, negate);
        } else if (this.isBooleanValueAST(left)) {
            ast = this.handleBooleanValueEqExpr(op, left.getValue(), right, negate);
        } else if (this.isBooleanValueAST(right)) {
            ast = this.handleBooleanValueEqExpr(op, right.getValue(), left, negate);
        }
        return ast;
    }

    protected JQLAST checkObjectEqualityOp(JQLAST op, JQLAST left, JQLAST right, boolean negate) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            ast = this.handleValueEqValue(op, left, right, negate);
        }
        return ast;
    }

    protected JQLAST checkCollectionEqualityOp(JQLAST op, JQLAST left, JQLAST right, boolean negate) {
        boolean isRightConstant;
        JQLAST ast = op;
        boolean isLeftConstant = left.getType() == 85;
        boolean bl = isRightConstant = right.getType() == 85;
        if (isLeftConstant && isRightConstant) {
            ast = this.handleValueEqValue(op, left, right, negate);
        } else if (isLeftConstant && left.getValue() == null && this.isNonConstantCollection(right) || isRightConstant && right.getValue() == null && this.isNonConstantCollection(left)) {
            ast.setType(85);
            ast.setValue(new Boolean(negate));
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkLogicalNotOp(JQLAST op, JQLAST arg) {
        JQLAST ast = op;
        if (arg.getType() == 85) {
            Object valueObj = arg.getValue();
            boolean value = valueObj instanceof Boolean ? (Boolean)valueObj : false;
            arg.setType(85);
            arg.setValue(new Boolean(!value));
            arg.setNextSibling(null);
            ast = arg;
        } else {
            ast = this.deMorgan(arg);
        }
        return ast;
    }

    protected JQLAST checkBinaryPlusOp(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            Object leftValue = left.getValue();
            Object rightValue = right.getValue();
            Object value = null;
            if (leftValue == null) {
                value = rightValue;
            } else if (rightValue == null) {
                value = leftValue;
            } else {
                Type type = op.getJQLType();
                if (type instanceof NumericWrapperClassType) {
                    type = ((NumericWrapperClassType)type).getPrimitiveType();
                }
                if (type.equals(this.typetab.intType)) {
                    value = new Integer(((Number)leftValue).intValue() + ((Number)rightValue).intValue());
                } else if (type.equals(this.typetab.longType)) {
                    value = new Long(((Number)leftValue).longValue() + ((Number)rightValue).longValue());
                } else if (type.equals(this.typetab.floatType)) {
                    value = new Float(((Number)leftValue).floatValue() + ((Number)rightValue).floatValue());
                } else if (type.equals(this.typetab.doubleType)) {
                    value = new Double(((Number)leftValue).doubleValue() + ((Number)rightValue).doubleValue());
                } else if (type.equals(this.typetab.bigDecimalType)) {
                    value = this.getBigDecimalValue(leftValue).add(this.getBigDecimalValue(rightValue));
                } else if (type.equals(this.typetab.bigIntegerType)) {
                    value = this.getBigIntegerValue(leftValue).add(this.getBigIntegerValue(rightValue));
                } else {
                    this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.checkbinaryplusop.invalidtype", (String)String.valueOf(type)));
                }
            }
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkConcatOp(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            Object leftValue = left.getValue();
            Object rightValue = right.getValue();
            Object value = null;
            value = leftValue == null ? rightValue : (rightValue == null ? leftValue : leftValue.toString() + rightValue.toString());
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkBinaryMinusOp(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            Object leftValue = left.getValue();
            Object rightValue = right.getValue();
            Object value = null;
            if (rightValue == null) {
                value = leftValue;
            } else {
                Type type;
                if (leftValue == null) {
                    leftValue = new Integer(0);
                }
                if ((type = op.getJQLType()) instanceof NumericWrapperClassType) {
                    type = ((NumericWrapperClassType)type).getPrimitiveType();
                }
                if (type.equals(this.typetab.intType)) {
                    value = new Integer(((Number)leftValue).intValue() - ((Number)rightValue).intValue());
                } else if (type.equals(this.typetab.longType)) {
                    value = new Long(((Number)leftValue).longValue() - ((Number)rightValue).longValue());
                } else if (type.equals(this.typetab.floatType)) {
                    value = new Float(((Number)leftValue).floatValue() - ((Number)rightValue).floatValue());
                } else if (type.equals(this.typetab.doubleType)) {
                    value = new Double(((Number)leftValue).doubleValue() - ((Number)rightValue).doubleValue());
                } else if (type.equals(this.typetab.bigDecimalType)) {
                    value = this.getBigDecimalValue(leftValue).subtract(this.getBigDecimalValue(rightValue));
                } else if (type.equals(this.typetab.bigIntegerType)) {
                    value = this.getBigIntegerValue(leftValue).subtract(this.getBigIntegerValue(rightValue));
                } else {
                    this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.checkbinaryminusop.invalidtype", (String)String.valueOf(type)));
                }
            }
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkMultiplicationOp(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            Type type;
            Object leftValue = left.getValue();
            Object rightValue = right.getValue();
            Number value = null;
            if (leftValue == null) {
                leftValue = new Integer(0);
            }
            if (rightValue == null) {
                rightValue = new Integer(0);
            }
            if ((type = op.getJQLType()) instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
            }
            if (type.equals(this.typetab.intType)) {
                value = new Integer(((Number)leftValue).intValue() * ((Number)rightValue).intValue());
            } else if (type.equals(this.typetab.longType)) {
                value = new Long(((Number)leftValue).longValue() * ((Number)rightValue).longValue());
            } else if (type.equals(this.typetab.floatType)) {
                value = new Float(((Number)leftValue).floatValue() * ((Number)rightValue).floatValue());
            } else if (type.equals(this.typetab.doubleType)) {
                value = new Double(((Number)leftValue).doubleValue() * ((Number)rightValue).doubleValue());
            } else if (type.equals(this.typetab.bigDecimalType)) {
                value = this.getBigDecimalValue(leftValue).multiply(this.getBigDecimalValue(rightValue));
            } else if (type.equals(this.typetab.bigIntegerType)) {
                value = this.getBigIntegerValue(leftValue).multiply(this.getBigIntegerValue(rightValue));
            } else {
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.checkmultiplicationop.invalidtype", (String)String.valueOf(type)));
            }
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkDivisionOp(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            Type type;
            Object leftValue = left.getValue();
            Object rightValue = right.getValue();
            Number value = null;
            if (leftValue == null) {
                leftValue = new Integer(0);
            }
            if (rightValue == null) {
                rightValue = new Integer(0);
            }
            if ((type = op.getJQLType()) instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
            }
            if (type.equals(this.typetab.intType)) {
                value = new Integer(((Number)leftValue).intValue() / ((Number)rightValue).intValue());
            } else if (type.equals(this.typetab.longType)) {
                value = new Long(((Number)leftValue).longValue() / ((Number)rightValue).longValue());
            } else if (type.equals(this.typetab.floatType)) {
                value = new Float(((Number)leftValue).floatValue() / ((Number)rightValue).floatValue());
            } else if (type.equals(this.typetab.doubleType)) {
                value = new Double(((Number)leftValue).doubleValue() / ((Number)rightValue).doubleValue());
            } else if (type.equals(this.typetab.bigDecimalType)) {
                value = this.getBigDecimalValue(leftValue).divide(this.getBigDecimalValue(rightValue), 6);
            } else if (type.equals(this.typetab.bigIntegerType)) {
                value = this.getBigIntegerValue(leftValue).divide(this.getBigIntegerValue(rightValue));
            } else {
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.checkdivisionop.invalidtype", (String)String.valueOf(type)));
            }
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkModOp(JQLAST op, JQLAST left, JQLAST right) {
        JQLAST ast = op;
        if (left.getType() == 85 && right.getType() == 85) {
            Type type;
            Object leftValue = left.getValue();
            Object rightValue = right.getValue();
            Number value = null;
            if (leftValue == null) {
                leftValue = new Integer(0);
            }
            if (rightValue == null) {
                rightValue = new Integer(0);
            }
            if ((type = op.getJQLType()) instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
            }
            if (type.equals(this.typetab.intType)) {
                value = new Integer(((Number)leftValue).intValue() % ((Number)rightValue).intValue());
            } else if (type.equals(this.typetab.longType)) {
                value = new Long(((Number)leftValue).longValue() % ((Number)rightValue).longValue());
            } else if (type.equals(this.typetab.floatType)) {
                value = new Float(((Number)leftValue).floatValue() % ((Number)rightValue).floatValue());
            } else if (type.equals(this.typetab.doubleType)) {
                value = new Double(((Number)leftValue).doubleValue() % ((Number)rightValue).doubleValue());
            } else if (type.equals(this.typetab.bigDecimalType)) {
                BigDecimal leftBigDecimal = this.getBigDecimalValue(leftValue);
                BigDecimal rightBigDecimal = this.getBigDecimalValue(rightValue);
                BigDecimal quotient = leftBigDecimal.divide(rightBigDecimal, 0, 6);
                value = leftBigDecimal.subtract(rightBigDecimal.multiply(quotient));
            } else if (type.equals(this.typetab.bigIntegerType)) {
                value = this.getBigIntegerValue(leftValue).remainder(this.getBigIntegerValue(rightValue));
            } else {
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.checkmodop.invalidtype", (String)String.valueOf(type)));
            }
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkUnaryMinusOp(JQLAST op, JQLAST arg) {
        JQLAST ast = op;
        if (arg.getType() == 85) {
            Object value = arg.getValue();
            Type type = op.getJQLType();
            Number negate = null;
            if (type instanceof NumberType) {
                negate = ((NumberType)((Object)type)).negate((Number)value);
            } else {
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.checkunaryminusop.invalidtype", (String)String.valueOf(type)));
            }
            ast.setType(85);
            ast.setValue(negate);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected JQLAST checkCastOp(JQLAST op, JQLAST castType, JQLAST expr) {
        JQLAST ast = op;
        if (expr.getType() == 85) {
            Object value = expr.getValue();
            Type type = op.getJQLType();
            if (type instanceof NumericWrapperClassType) {
                type = ((NumericWrapperClassType)type).getPrimitiveType();
            }
            if (type.equals(this.typetab.intType)) {
                value = new Integer(((Number)value).intValue());
            } else if (type.equals(this.typetab.longType)) {
                value = new Long(((Number)value).longValue());
            } else if (type.equals(this.typetab.floatType)) {
                value = new Float(((Number)value).floatValue());
            } else if (type.equals(this.typetab.doubleType)) {
                value = new Double(((Number)value).doubleValue());
            } else if (type.equals(this.typetab.bigDecimalType)) {
                value = this.getBigDecimalValue(value);
            } else if (type.equals(this.typetab.bigIntegerType)) {
                value = this.getBigIntegerValue(value);
            } else if (type.equals(this.typetab.byteType)) {
                value = new Byte((byte)((Number)value).intValue());
            } else if (type.equals(this.typetab.shortType)) {
                value = new Short((short)((Number)value).intValue());
            } else if (type.equals(this.typetab.charType)) {
                value = new Character((char)((Number)value).intValue());
            }
            ast.setType(85);
            ast.setValue(value);
            ast.setFirstChild(null);
        }
        return ast;
    }

    protected BigDecimal getBigDecimalValue(Object value) {
        BigDecimal ret = null;
        if (value instanceof Number) {
            ret = (BigDecimal)this.typetab.bigDecimalType.getValue((Number)value);
        } else {
            this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.getbigdecimalvalue.notnumber", (String)String.valueOf(value)));
        }
        return ret;
    }

    protected BigInteger getBigIntegerValue(Object value) {
        BigInteger ret = null;
        if (value instanceof Number) {
            ret = (BigInteger)this.typetab.bigIntegerType.getValue((Number)value);
        } else {
            this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.getbigintegervalue.notnumber", (String)String.valueOf(value)));
        }
        return ret;
    }

    protected JQLAST handleValueEqValue(JQLAST op, JQLAST left, JQLAST right, boolean negate) {
        Object leftValue = left.getValue();
        Object rightValue = right.getValue();
        boolean value = false;
        value = leftValue == null && rightValue == null ? true : (leftValue != null && rightValue != null ? leftValue.equals(rightValue) : false);
        if (negate) {
            value = !value;
        }
        op.setType(85);
        op.setValue(new Boolean(value));
        op.setFirstChild(null);
        return op;
    }

    private JQLAST handleBooleanValueEqExpr(JQLAST op, Object value, JQLAST expr, boolean negate) {
        JQLAST ast;
        boolean skip;
        boolean bl = skip = value instanceof Boolean ? (Boolean)value : false;
        if (negate) {
            boolean bl2 = skip = !skip;
        }
        if (skip) {
            ast = expr;
        } else {
            switch (expr.getType()) {
                case 28: {
                    expr.setType(31);
                    expr.setText("!=");
                    ast = expr;
                    break;
                }
                case 31: {
                    expr.setType(28);
                    expr.setText("==");
                    ast = expr;
                    break;
                }
                case 29: {
                    ast = (JQLAST)expr.getFirstChild();
                    break;
                }
                default: {
                    op.setType(29);
                    op.setText("!");
                    op.setFirstChild((AST)expr);
                    ast = op;
                }
            }
            expr.setNextSibling(null);
        }
        return ast;
    }

    private JQLAST handleValueAndExpr(JQLAST op, Object value, JQLAST expr) {
        JQLAST ast;
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            expr.setNextSibling(null);
            ast = expr;
        } else {
            op.setType(85);
            op.setText("false");
            op.setValue(new Boolean(false));
            op.setFirstChild(null);
            ast = op;
        }
        return ast;
    }

    private JQLAST handleValueOrExpr(JQLAST op, Object value, JQLAST expr) {
        JQLAST ast;
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            op.setType(85);
            op.setText("true");
            op.setValue(new Boolean(true));
            op.setFirstChild(null);
            ast = op;
        } else {
            expr.setNextSibling(null);
            ast = expr;
        }
        return ast;
    }

    protected boolean isBooleanValueAST(JQLAST ast) {
        return ast.getType() == 85 && this.typetab.booleanType.equals(ast.getJQLType());
    }

    protected boolean isNonConstantCollection(JQLAST ast) {
        switch (ast.getType()) {
            case 74: 
            case 78: {
                return true;
            }
            case 68: {
                JQLAST expr = (JQLAST)ast.getFirstChild().getNextSibling();
                return this.isNonConstantCollection(expr);
            }
        }
        return false;
    }

    protected JQLAST deMorgan(JQLAST tree) {
        JQLAST result = null;
        JQLAST left = null;
        JQLAST right = null;
        switch (tree.getType()) {
            case 44: 
            case 45: {
                left = (JQLAST)tree.getFirstChild();
                right = (JQLAST)left.getNextSibling();
                String leftVar = this.getVariableFromContainsClause(left);
                String rightVar = this.getVariableFromContainsClause(right);
                if (leftVar != null) {
                    result = this.buildAST(tree, left, this.deMorgan(right, leftVar));
                    break;
                }
                if (rightVar != null) {
                    result = this.buildAST(tree, right, this.deMorgan(left, rightVar));
                    break;
                }
                this.invertNode(tree);
                result = this.buildAST(tree, this.deMorgan(left), this.deMorgan(right));
                break;
            }
            case 42: 
            case 43: {
                left = (JQLAST)tree.getFirstChild();
                right = (JQLAST)left.getNextSibling();
                this.invertNode(tree);
                result = this.buildAST(tree, this.deMorgan(left), this.deMorgan(right));
                break;
            }
            case 29: {
                result = (JQLAST)tree.getFirstChild();
                break;
            }
            default: {
                result = this.buildAST(new JQLAST(29, "!", this.typetab.booleanType), tree);
            }
        }
        return result;
    }

    protected JQLAST deMorgan(JQLAST tree, String var) {
        JQLAST result = tree;
        switch (tree.getType()) {
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                JQLAST left = (JQLAST)tree.getFirstChild();
                JQLAST right = (JQLAST)left.getNextSibling();
                if (!this.includesVariableAccess((AST)left, var) || !this.includesVariableAccess((AST)right, var)) {
                    this.invertNode(tree);
                }
                result = this.buildAST(tree, this.deMorgan(left, var), this.deMorgan(right, var));
                break;
            }
            default: {
                if (this.includesVariableAccess((AST)tree, var)) break;
                result = this.deMorgan(tree);
            }
        }
        return result;
    }

    protected String getVariableFromContainsClause(JQLAST tree) {
        switch (tree.getType()) {
            case 76: 
            case 77: {
                return tree.getFirstChild().getNextSibling().getText();
            }
        }
        return null;
    }

    protected boolean includesVariableAccess(AST tree, String var) {
        if (tree == null || var == null) {
            return false;
        }
        boolean found = false;
        JQLAST child = (JQLAST)tree.getFirstChild();
        if (tree.getType() == 82 && tree.getText().equals(var) && child != null) {
            found = true;
            if (child.getType() != 93) {
                tree.setFirstChild((AST)this.buildAST(new JQLAST(93, "notIn", this.typetab.booleanType), child));
            }
        }
        for (AST node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!this.includesVariableAccess(node, var)) continue;
            found = true;
        }
        return found;
    }

    protected void invertNode(JQLAST node) {
        switch (node.getType()) {
            case 45: {
                node.setType(43);
                node.setText("||");
                break;
            }
            case 44: {
                node.setType(42);
                node.setText("|");
                break;
            }
            case 43: {
                node.setType(45);
                node.setText("&&");
                break;
            }
            case 42: {
                node.setType(44);
                node.setText("&");
                break;
            }
            case 28: {
                node.setType(31);
                node.setText("!=");
                break;
            }
            case 31: {
                node.setType(28);
                node.setText("==");
                break;
            }
            case 40: {
                node.setType(37);
                node.setText(">=");
                break;
            }
            case 39: {
                node.setType(38);
                node.setText(">");
                break;
            }
            case 38: {
                node.setType(39);
                node.setText("<=");
                break;
            }
            case 37: {
                node.setType(40);
                node.setText("<");
            }
        }
    }

    protected JQLAST buildAST(JQLAST root, JQLAST left, JQLAST right) {
        root.setFirstChild((AST)left);
        left.setNextSibling((AST)right);
        right.setNextSibling(null);
        return root;
    }

    protected JQLAST buildAST(JQLAST root, JQLAST arg) {
        root.setFirstChild((AST)arg);
        arg.setNextSibling(null);
        return root;
    }

    public Optimizer() {
        this.tokenNames = _tokenNames;
    }

    public final void query(AST _t) throws RecognitionException {
        JQLAST query_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST query_AST = null;
        JQLAST q = null;
        JQLAST q_AST = null;
        AST __t2 = _t;
        q = _t == ASTNULL ? null : (JQLAST)_t;
        Object q_AST_in = null;
        q_AST = (JQLAST)this.astFactory.create((AST)q);
        this.astFactory.addASTChild(currentAST, (AST)q_AST);
        ASTPair __currentAST2 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 58);
        _t = _t.getFirstChild();
        this.candidateClass(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.parameters(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.variables(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.ordering(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.result(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.filter(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST2;
        _t = __t2;
        _t = _t.getNextSibling();
        query_AST = (JQLAST)currentAST.root;
        this.returnAST = query_AST;
        this._retTree = _t;
    }

    public final void candidateClass(AST _t) throws RecognitionException {
        JQLAST candidateClass_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST candidateClass_AST = null;
        this.errorMsg.setContext("setCandidates");
        JQLAST tmp1_AST = null;
        JQLAST tmp1_AST_in = null;
        tmp1_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp1_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp1_AST);
        this.match(_t, 59);
        _t = _t.getNextSibling();
        candidateClass_AST = (JQLAST)currentAST.root;
        this.returnAST = candidateClass_AST;
        this._retTree = _t;
    }

    public final void parameters(AST _t) throws RecognitionException {
        JQLAST parameters_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST parameters_AST = null;
        this.errorMsg.setContext("declareParameters");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 61) break;
            this.declareParameter(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        parameters_AST = (JQLAST)currentAST.root;
        this.returnAST = parameters_AST;
        this._retTree = _t;
    }

    public final void variables(AST _t) throws RecognitionException {
        JQLAST variables_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST variables_AST = null;
        this.errorMsg.setContext("declareVariables");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 62) break;
            this.declareVariable(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        variables_AST = (JQLAST)currentAST.root;
        this.returnAST = variables_AST;
        this._retTree = _t;
    }

    public final void ordering(AST _t) throws RecognitionException {
        JQLAST ordering_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST ordering_AST = null;
        this.errorMsg.setContext("setOrdering");
        while (true) {
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() != 63) break;
            this.orderSpec(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
        }
        ordering_AST = (JQLAST)currentAST.root;
        this.returnAST = ordering_AST;
        this._retTree = _t;
    }

    public final void result(AST _t) throws RecognitionException {
        JQLAST result_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST result_AST = null;
        JQLAST r = null;
        JQLAST r_AST = null;
        this.errorMsg.setContext("setResult");
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 86: {
                AST __t21 = _t;
                r = _t == ASTNULL ? null : (JQLAST)_t;
                Object r_AST_in = null;
                r_AST = (JQLAST)this.astFactory.create((AST)r);
                this.astFactory.addASTChild(currentAST, (AST)r_AST);
                ASTPair __currentAST21 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 86);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST21;
                _t = __t21;
                _t = _t.getNextSibling();
                result_AST = (JQLAST)currentAST.root;
                break;
            }
            case 64: {
                result_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = result_AST;
        this._retTree = _t;
    }

    public final void filter(AST _t) throws RecognitionException {
        JQLAST filter_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST filter_AST = null;
        this.errorMsg.setContext("setFilter");
        AST __t30 = _t;
        JQLAST tmp2_AST = null;
        JQLAST tmp2_AST_in = null;
        tmp2_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp2_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp2_AST);
        ASTPair __currentAST30 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 64);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST30;
        _t = __t30;
        _t = _t.getNextSibling();
        filter_AST = (JQLAST)currentAST.root;
        this.returnAST = filter_AST;
        this._retTree = _t;
    }

    public final void declareParameter(AST _t) throws RecognitionException {
        JQLAST declareParameter_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST declareParameter_AST = null;
        AST __t8 = _t;
        JQLAST tmp3_AST = null;
        JQLAST tmp3_AST_in = null;
        tmp3_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp3_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp3_AST);
        ASTPair __currentAST8 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 61);
        _t = _t.getFirstChild();
        this.type(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        JQLAST tmp4_AST = null;
        JQLAST tmp4_AST_in = null;
        tmp4_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp4_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp4_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST8;
        _t = __t8;
        _t = _t.getNextSibling();
        declareParameter_AST = (JQLAST)currentAST.root;
        this.returnAST = declareParameter_AST;
        this._retTree = _t;
    }

    public final void type(AST _t) throws RecognitionException {
        JQLAST type_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST type_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 84: {
                JQLAST tmp5_AST = null;
                JQLAST tmp5_AST_in = null;
                tmp5_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp5_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp5_AST);
                this.match(_t, 84);
                _t = _t.getNextSibling();
                type_AST = (JQLAST)currentAST.root;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.primitiveType(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                type_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = type_AST;
        this._retTree = _t;
    }

    public final void declareVariable(AST _t) throws RecognitionException {
        JQLAST declareVariable_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST declareVariable_AST = null;
        AST __t13 = _t;
        JQLAST tmp6_AST = null;
        JQLAST tmp6_AST_in = null;
        tmp6_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp6_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp6_AST);
        ASTPair __currentAST13 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 62);
        _t = _t.getFirstChild();
        this.type(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        JQLAST tmp7_AST = null;
        JQLAST tmp7_AST_in = null;
        tmp7_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp7_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp7_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST13;
        _t = __t13;
        _t = _t.getNextSibling();
        declareVariable_AST = (JQLAST)currentAST.root;
        this.returnAST = declareVariable_AST;
        this._retTree = _t;
    }

    public final void orderSpec(AST _t) throws RecognitionException {
        JQLAST orderSpec_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST orderSpec_AST = null;
        AST __t18 = _t;
        JQLAST tmp8_AST = null;
        JQLAST tmp8_AST_in = null;
        tmp8_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp8_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp8_AST);
        ASTPair __currentAST18 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 63);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 6: {
                JQLAST tmp9_AST = null;
                JQLAST tmp9_AST_in = null;
                tmp9_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp9_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp9_AST);
                this.match(_t, 6);
                _t = _t.getNextSibling();
                break;
            }
            case 7: {
                JQLAST tmp10_AST = null;
                JQLAST tmp10_AST_in = null;
                tmp10_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp10_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp10_AST);
                this.match(_t, 7);
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST18;
        _t = __t18;
        _t = _t.getNextSibling();
        orderSpec_AST = (JQLAST)currentAST.root;
        this.returnAST = orderSpec_AST;
        this._retTree = _t;
    }

    public final void expression(AST _t) throws RecognitionException {
        JQLAST expression_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST expression_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 49: 
            case 50: 
            case 53: 
            case 68: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: {
                this.primary(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            case 41: 
            case 42: 
            case 44: {
                this.bitwiseExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            case 43: 
            case 45: {
                this.conditionalExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            case 28: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                this.relationalExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 73: {
                this.binaryArithmeticExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            case 66: 
            case 67: {
                this.unaryArithmeticExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            case 29: 
            case 30: {
                this.complementExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                expression_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = expression_AST;
        this._retTree = _t;
    }

    public final void resultExpr(AST _t) throws RecognitionException {
        JQLAST resultExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST resultExpr_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 8: {
                AST __t23 = _t;
                JQLAST tmp11_AST = null;
                JQLAST tmp11_AST_in = null;
                tmp11_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp11_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp11_AST);
                ASTPair __currentAST23 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 8);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST23;
                _t = __t23;
                _t = _t.getNextSibling();
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 20: {
                AST __t24 = _t;
                JQLAST tmp12_AST = null;
                JQLAST tmp12_AST_in = null;
                tmp12_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp12_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp12_AST);
                ASTPair __currentAST24 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 20);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST24;
                _t = __t24;
                _t = _t.getNextSibling();
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 21: {
                AST __t25 = _t;
                JQLAST tmp13_AST = null;
                JQLAST tmp13_AST_in = null;
                tmp13_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp13_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp13_AST);
                ASTPair __currentAST25 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 21);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST25;
                _t = __t25;
                _t = _t.getNextSibling();
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 22: {
                AST __t26 = _t;
                JQLAST tmp14_AST = null;
                JQLAST tmp14_AST_in = null;
                tmp14_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp14_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp14_AST);
                ASTPair __currentAST26 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 22);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST26;
                _t = __t26;
                _t = _t.getNextSibling();
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 23: {
                AST __t27 = _t;
                JQLAST tmp15_AST = null;
                JQLAST tmp15_AST_in = null;
                tmp15_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp15_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp15_AST);
                ASTPair __currentAST27 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 23);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST27;
                _t = __t27;
                _t = _t.getNextSibling();
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 24: {
                AST __t28 = _t;
                JQLAST tmp16_AST = null;
                JQLAST tmp16_AST_in = null;
                tmp16_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp16_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp16_AST);
                ASTPair __currentAST28 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 24);
                _t = _t.getFirstChild();
                this.resultExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST28;
                _t = __t28;
                _t = _t.getNextSibling();
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 53: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: {
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                resultExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = resultExpr_AST;
        this._retTree = _t;
    }

    public final void primary(AST _t) throws RecognitionException {
        JQLAST primary_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST primary_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 68: {
                this.castExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 49: 
            case 50: 
            case 53: 
            case 95: 
            case 96: 
            case 97: {
                this.literal(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 85: {
                JQLAST tmp17_AST = null;
                JQLAST tmp17_AST_in = null;
                tmp17_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp17_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp17_AST);
                this.match(_t, 85);
                _t = _t.getNextSibling();
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 5: {
                JQLAST tmp18_AST = null;
                JQLAST tmp18_AST_in = null;
                tmp18_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp18_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp18_AST);
                this.match(_t, 5);
                _t = _t.getNextSibling();
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 83: {
                this.parameter(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 75: {
                this.staticFieldAccess(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 74: {
                this.fieldAccess(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 78: {
                this.navigation(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 82: {
                this.variableAccess(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 76: {
                AST __t69 = _t;
                JQLAST tmp19_AST = null;
                JQLAST tmp19_AST_in = null;
                tmp19_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp19_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp19_AST);
                ASTPair __currentAST69 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 76);
                _t = _t.getFirstChild();
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                JQLAST tmp20_AST = null;
                JQLAST tmp20_AST_in = null;
                tmp20_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp20_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp20_AST);
                this.match(_t, 82);
                _t = _t.getNextSibling();
                currentAST = __currentAST69;
                _t = __t69;
                _t = _t.getNextSibling();
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 77: {
                AST __t70 = _t;
                JQLAST tmp21_AST = null;
                JQLAST tmp21_AST_in = null;
                tmp21_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp21_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp21_AST);
                ASTPair __currentAST70 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 77);
                _t = _t.getFirstChild();
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                JQLAST tmp22_AST = null;
                JQLAST tmp22_AST_in = null;
                tmp22_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp22_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp22_AST);
                this.match(_t, 82);
                _t = _t.getNextSibling();
                currentAST = __currentAST70;
                _t = __t70;
                _t = _t.getNextSibling();
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 79: {
                this.startsWith(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 80: {
                this.endsWith(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 81: {
                this.isEmpty(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 87: {
                this.like(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 88: {
                this.substring(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 89: {
                this.indexOf(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 90: {
                this.length(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 91: {
                this.abs(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            case 92: {
                this.sqrt(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                primary_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = primary_AST;
        this._retTree = _t;
    }

    public final void bitwiseExpr(AST _t) throws RecognitionException {
        JQLAST bitwiseExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST bitwiseExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        JQLAST op3 = null;
        JQLAST op3_AST = null;
        JQLAST left3_AST = null;
        JQLAST left3 = null;
        JQLAST right3_AST = null;
        JQLAST right3 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 44: {
                AST __t33 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST33 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 44);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST33;
                _t = __t33;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    bitwiseExpr_AST = (JQLAST)currentAST.root;
                    bitwiseExpr_AST = this.checkAnd(op1_AST, left1_AST, right1_AST);
                    currentAST.root = bitwiseExpr_AST;
                    currentAST.child = bitwiseExpr_AST != null && bitwiseExpr_AST.getFirstChild() != null ? bitwiseExpr_AST.getFirstChild() : bitwiseExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                bitwiseExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 42: {
                AST __t34 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST34 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 42);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST34;
                _t = __t34;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    bitwiseExpr_AST = (JQLAST)currentAST.root;
                    bitwiseExpr_AST = this.checkOr(op2_AST, left2_AST, right2_AST);
                    currentAST.root = bitwiseExpr_AST;
                    currentAST.child = bitwiseExpr_AST != null && bitwiseExpr_AST.getFirstChild() != null ? bitwiseExpr_AST.getFirstChild() : bitwiseExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                bitwiseExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 41: {
                AST __t35 = _t;
                op3 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (JQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST35 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 41);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST35;
                _t = __t35;
                _t = _t.getNextSibling();
                bitwiseExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = bitwiseExpr_AST;
        this._retTree = _t;
    }

    public final void conditionalExpr(AST _t) throws RecognitionException {
        JQLAST conditionalExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST conditionalExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 45: {
                AST __t37 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST37 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 45);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST37;
                _t = __t37;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    conditionalExpr_AST = (JQLAST)currentAST.root;
                    conditionalExpr_AST = this.checkAnd(op1_AST, left1_AST, right1_AST);
                    currentAST.root = conditionalExpr_AST;
                    currentAST.child = conditionalExpr_AST != null && conditionalExpr_AST.getFirstChild() != null ? conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                conditionalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 43: {
                AST __t38 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST38 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 43);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST38;
                _t = __t38;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    conditionalExpr_AST = (JQLAST)currentAST.root;
                    conditionalExpr_AST = this.checkOr(op2_AST, left2_AST, right2_AST);
                    currentAST.root = conditionalExpr_AST;
                    currentAST.child = conditionalExpr_AST != null && conditionalExpr_AST.getFirstChild() != null ? conditionalExpr_AST.getFirstChild() : conditionalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                conditionalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = conditionalExpr_AST;
        this._retTree = _t;
    }

    public final void relationalExpr(AST _t) throws RecognitionException {
        JQLAST relationalExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST relationalExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        JQLAST op3 = null;
        JQLAST op3_AST = null;
        JQLAST left3_AST = null;
        JQLAST left3 = null;
        JQLAST right3_AST = null;
        JQLAST right3 = null;
        JQLAST op4 = null;
        JQLAST op4_AST = null;
        JQLAST left4_AST = null;
        JQLAST left4 = null;
        JQLAST right4_AST = null;
        JQLAST right4 = null;
        JQLAST op5 = null;
        JQLAST op5_AST = null;
        JQLAST left5_AST = null;
        JQLAST left5 = null;
        JQLAST right5_AST = null;
        JQLAST right5 = null;
        JQLAST op6 = null;
        JQLAST op6_AST = null;
        JQLAST left6_AST = null;
        JQLAST left6 = null;
        JQLAST right6_AST = null;
        JQLAST right6 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 28: {
                AST __t40 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST40 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 28);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST40;
                _t = __t40;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    relationalExpr_AST = (JQLAST)currentAST.root;
                    relationalExpr_AST = this.checkEqualityOp(op1_AST, left1_AST, right1_AST, false);
                    currentAST.root = relationalExpr_AST;
                    currentAST.child = relationalExpr_AST != null && relationalExpr_AST.getFirstChild() != null ? relationalExpr_AST.getFirstChild() : relationalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 31: {
                AST __t41 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST41 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 31);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST41;
                _t = __t41;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    relationalExpr_AST = (JQLAST)currentAST.root;
                    relationalExpr_AST = this.checkEqualityOp(op2_AST, left2_AST, right2_AST, true);
                    currentAST.root = relationalExpr_AST;
                    currentAST.child = relationalExpr_AST != null && relationalExpr_AST.getFirstChild() != null ? relationalExpr_AST.getFirstChild() : relationalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 69: {
                AST __t42 = _t;
                op3 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (JQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST42 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 69);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST42;
                _t = __t42;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    relationalExpr_AST = (JQLAST)currentAST.root;
                    relationalExpr_AST = this.checkObjectEqualityOp(op3_AST, left3_AST, right3_AST, false);
                    currentAST.root = relationalExpr_AST;
                    currentAST.child = relationalExpr_AST != null && relationalExpr_AST.getFirstChild() != null ? relationalExpr_AST.getFirstChild() : relationalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 70: {
                AST __t43 = _t;
                op4 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op4_AST_in = null;
                op4_AST = (JQLAST)this.astFactory.create((AST)op4);
                this.astFactory.addASTChild(currentAST, (AST)op4_AST);
                ASTPair __currentAST43 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 70);
                _t = _t.getFirstChild();
                left4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST43;
                _t = __t43;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    relationalExpr_AST = (JQLAST)currentAST.root;
                    relationalExpr_AST = this.checkObjectEqualityOp(op4_AST, left4_AST, right4_AST, true);
                    currentAST.root = relationalExpr_AST;
                    currentAST.child = relationalExpr_AST != null && relationalExpr_AST.getFirstChild() != null ? relationalExpr_AST.getFirstChild() : relationalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 71: {
                AST __t44 = _t;
                op5 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op5_AST_in = null;
                op5_AST = (JQLAST)this.astFactory.create((AST)op5);
                this.astFactory.addASTChild(currentAST, (AST)op5_AST);
                ASTPair __currentAST44 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 71);
                _t = _t.getFirstChild();
                left5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST44;
                _t = __t44;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    relationalExpr_AST = (JQLAST)currentAST.root;
                    relationalExpr_AST = this.checkCollectionEqualityOp(op5_AST, left5_AST, right5_AST, false);
                    currentAST.root = relationalExpr_AST;
                    currentAST.child = relationalExpr_AST != null && relationalExpr_AST.getFirstChild() != null ? relationalExpr_AST.getFirstChild() : relationalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 72: {
                AST __t45 = _t;
                op6 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op6_AST_in = null;
                op6_AST = (JQLAST)this.astFactory.create((AST)op6);
                this.astFactory.addASTChild(currentAST, (AST)op6_AST);
                ASTPair __currentAST45 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 72);
                _t = _t.getFirstChild();
                left6 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left6_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right6 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right6_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST45;
                _t = __t45;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    relationalExpr_AST = (JQLAST)currentAST.root;
                    relationalExpr_AST = this.checkCollectionEqualityOp(op6_AST, left6_AST, right6_AST, true);
                    currentAST.root = relationalExpr_AST;
                    currentAST.child = relationalExpr_AST != null && relationalExpr_AST.getFirstChild() != null ? relationalExpr_AST.getFirstChild() : relationalExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 40: {
                AST __t46 = _t;
                JQLAST tmp23_AST = null;
                JQLAST tmp23_AST_in = null;
                tmp23_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp23_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp23_AST);
                ASTPair __currentAST46 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 40);
                _t = _t.getFirstChild();
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST46;
                _t = __t46;
                _t = _t.getNextSibling();
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 38: {
                AST __t47 = _t;
                JQLAST tmp24_AST = null;
                JQLAST tmp24_AST_in = null;
                tmp24_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp24_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp24_AST);
                ASTPair __currentAST47 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 38);
                _t = _t.getFirstChild();
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST47;
                _t = __t47;
                _t = _t.getNextSibling();
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 39: {
                AST __t48 = _t;
                JQLAST tmp25_AST = null;
                JQLAST tmp25_AST_in = null;
                tmp25_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp25_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp25_AST);
                ASTPair __currentAST48 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 39);
                _t = _t.getFirstChild();
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST48;
                _t = __t48;
                _t = _t.getNextSibling();
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 37: {
                AST __t49 = _t;
                JQLAST tmp26_AST = null;
                JQLAST tmp26_AST_in = null;
                tmp26_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp26_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp26_AST);
                ASTPair __currentAST49 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 37);
                _t = _t.getFirstChild();
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST49;
                _t = __t49;
                _t = _t.getNextSibling();
                relationalExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = relationalExpr_AST;
        this._retTree = _t;
    }

    public final void binaryArithmeticExpr(AST _t) throws RecognitionException {
        JQLAST binaryArithmeticExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST binaryArithmeticExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST left1_AST = null;
        JQLAST left1 = null;
        JQLAST right1_AST = null;
        JQLAST right1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST left2_AST = null;
        JQLAST left2 = null;
        JQLAST right2_AST = null;
        JQLAST right2 = null;
        JQLAST op3 = null;
        JQLAST op3_AST = null;
        JQLAST left3_AST = null;
        JQLAST left3 = null;
        JQLAST right3_AST = null;
        JQLAST right3 = null;
        JQLAST op4 = null;
        JQLAST op4_AST = null;
        JQLAST left4_AST = null;
        JQLAST left4 = null;
        JQLAST right4_AST = null;
        JQLAST right4 = null;
        JQLAST op5 = null;
        JQLAST op5_AST = null;
        JQLAST left5_AST = null;
        JQLAST left5 = null;
        JQLAST right5_AST = null;
        JQLAST right5 = null;
        JQLAST op6 = null;
        JQLAST op6_AST = null;
        JQLAST left6_AST = null;
        JQLAST left6 = null;
        JQLAST right6_AST = null;
        JQLAST right6 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 33: {
                AST __t51 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST51 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 33);
                _t = _t.getFirstChild();
                left1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST51;
                _t = __t51;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    binaryArithmeticExpr_AST = this.checkBinaryPlusOp(op1_AST, left1_AST, right1_AST);
                    currentAST.root = binaryArithmeticExpr_AST;
                    currentAST.child = binaryArithmeticExpr_AST != null && binaryArithmeticExpr_AST.getFirstChild() != null ? binaryArithmeticExpr_AST.getFirstChild() : binaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 73: {
                AST __t52 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST52 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 73);
                _t = _t.getFirstChild();
                left2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST52;
                _t = __t52;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    binaryArithmeticExpr_AST = this.checkConcatOp(op2_AST, left2_AST, right2_AST);
                    currentAST.root = binaryArithmeticExpr_AST;
                    currentAST.child = binaryArithmeticExpr_AST != null && binaryArithmeticExpr_AST.getFirstChild() != null ? binaryArithmeticExpr_AST.getFirstChild() : binaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 34: {
                AST __t53 = _t;
                op3 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op3_AST_in = null;
                op3_AST = (JQLAST)this.astFactory.create((AST)op3);
                this.astFactory.addASTChild(currentAST, (AST)op3_AST);
                ASTPair __currentAST53 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 34);
                _t = _t.getFirstChild();
                left3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right3 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right3_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST53;
                _t = __t53;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    binaryArithmeticExpr_AST = this.checkBinaryMinusOp(op3_AST, left3_AST, right3_AST);
                    currentAST.root = binaryArithmeticExpr_AST;
                    currentAST.child = binaryArithmeticExpr_AST != null && binaryArithmeticExpr_AST.getFirstChild() != null ? binaryArithmeticExpr_AST.getFirstChild() : binaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 35: {
                AST __t54 = _t;
                op4 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op4_AST_in = null;
                op4_AST = (JQLAST)this.astFactory.create((AST)op4);
                this.astFactory.addASTChild(currentAST, (AST)op4_AST);
                ASTPair __currentAST54 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 35);
                _t = _t.getFirstChild();
                left4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right4 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right4_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST54;
                _t = __t54;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    binaryArithmeticExpr_AST = this.checkMultiplicationOp(op4_AST, left4_AST, right4_AST);
                    currentAST.root = binaryArithmeticExpr_AST;
                    currentAST.child = binaryArithmeticExpr_AST != null && binaryArithmeticExpr_AST.getFirstChild() != null ? binaryArithmeticExpr_AST.getFirstChild() : binaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 32: {
                AST __t55 = _t;
                op5 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op5_AST_in = null;
                op5_AST = (JQLAST)this.astFactory.create((AST)op5);
                this.astFactory.addASTChild(currentAST, (AST)op5_AST);
                ASTPair __currentAST55 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 32);
                _t = _t.getFirstChild();
                left5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right5 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right5_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST55;
                _t = __t55;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    binaryArithmeticExpr_AST = this.checkDivisionOp(op5_AST, left5_AST, right5_AST);
                    currentAST.root = binaryArithmeticExpr_AST;
                    currentAST.child = binaryArithmeticExpr_AST != null && binaryArithmeticExpr_AST.getFirstChild() != null ? binaryArithmeticExpr_AST.getFirstChild() : binaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 36: {
                AST __t56 = _t;
                op6 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op6_AST_in = null;
                op6_AST = (JQLAST)this.astFactory.create((AST)op6);
                this.astFactory.addASTChild(currentAST, (AST)op6_AST);
                ASTPair __currentAST56 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 36);
                _t = _t.getFirstChild();
                left6 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                left6_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                right6 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                right6_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST56;
                _t = __t56;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    binaryArithmeticExpr_AST = this.checkModOp(op6_AST, left6_AST, right6_AST);
                    currentAST.root = binaryArithmeticExpr_AST;
                    currentAST.child = binaryArithmeticExpr_AST != null && binaryArithmeticExpr_AST.getFirstChild() != null ? binaryArithmeticExpr_AST.getFirstChild() : binaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                binaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = binaryArithmeticExpr_AST;
        this._retTree = _t;
    }

    public final void unaryArithmeticExpr(AST _t) throws RecognitionException {
        JQLAST unaryArithmeticExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST unaryArithmeticExpr_AST = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST arg2_AST = null;
        JQLAST arg2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        if (_t.getType() == 67) {
            AST __t58 = _t;
            JQLAST tmp27_AST = null;
            JQLAST tmp27_AST_in = null;
            tmp27_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
            tmp27_AST_in = (JQLAST)_t;
            this.astFactory.addASTChild(currentAST, (AST)tmp27_AST);
            ASTPair __currentAST58 = currentAST.copy();
            currentAST.root = currentAST.child;
            currentAST.child = null;
            this.match(_t, 67);
            _t = _t.getFirstChild();
            this.expression(_t);
            _t = this._retTree;
            this.astFactory.addASTChild(currentAST, this.returnAST);
            currentAST = __currentAST58;
            _t = __t58;
            _t = _t.getNextSibling();
            unaryArithmeticExpr_AST = (JQLAST)currentAST.root;
        } else {
            boolean synPredMatched60 = false;
            if (_t == null) {
                _t = ASTNULL;
            }
            if (_t.getType() == 66) {
                AST __t60 = _t;
                synPredMatched60 = true;
                ++this.inputState.guessing;
                try {
                    this.unaryMinusLiteralExpr(_t);
                    _t = this._retTree;
                }
                catch (RecognitionException pe) {
                    synPredMatched60 = false;
                }
                _t = __t60;
                --this.inputState.guessing;
            }
            if (synPredMatched60) {
                this.unaryMinusLiteralExpr(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                unaryArithmeticExpr_AST = (JQLAST)currentAST.root;
            } else if (_t.getType() == 66) {
                AST __t61 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST61 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 66);
                _t = _t.getFirstChild();
                arg2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST61;
                _t = __t61;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    unaryArithmeticExpr_AST = (JQLAST)currentAST.root;
                    unaryArithmeticExpr_AST = this.checkUnaryMinusOp(op2_AST, arg2_AST);
                    currentAST.root = unaryArithmeticExpr_AST;
                    currentAST.child = unaryArithmeticExpr_AST != null && unaryArithmeticExpr_AST.getFirstChild() != null ? unaryArithmeticExpr_AST.getFirstChild() : unaryArithmeticExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                unaryArithmeticExpr_AST = (JQLAST)currentAST.root;
            } else {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = unaryArithmeticExpr_AST;
        this._retTree = _t;
    }

    public final void complementExpr(AST _t) throws RecognitionException {
        JQLAST complementExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST complementExpr_AST = null;
        JQLAST op1 = null;
        JQLAST op1_AST = null;
        JQLAST arg1_AST = null;
        JQLAST arg1 = null;
        JQLAST op2 = null;
        JQLAST op2_AST = null;
        JQLAST arg2_AST = null;
        JQLAST arg2 = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 30: {
                AST __t66 = _t;
                op1 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op1_AST_in = null;
                op1_AST = (JQLAST)this.astFactory.create((AST)op1);
                this.astFactory.addASTChild(currentAST, (AST)op1_AST);
                ASTPair __currentAST66 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 30);
                _t = _t.getFirstChild();
                arg1 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg1_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST66;
                _t = __t66;
                _t = _t.getNextSibling();
                complementExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            case 29: {
                AST __t67 = _t;
                op2 = _t == ASTNULL ? null : (JQLAST)_t;
                Object op2_AST_in = null;
                op2_AST = (JQLAST)this.astFactory.create((AST)op2);
                this.astFactory.addASTChild(currentAST, (AST)op2_AST);
                ASTPair __currentAST67 = currentAST.copy();
                currentAST.root = currentAST.child;
                currentAST.child = null;
                this.match(_t, 29);
                _t = _t.getFirstChild();
                arg2 = _t == ASTNULL ? null : (JQLAST)_t;
                this.expression(_t);
                _t = this._retTree;
                arg2_AST = (JQLAST)this.returnAST;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                currentAST = __currentAST67;
                _t = __t67;
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    complementExpr_AST = (JQLAST)currentAST.root;
                    complementExpr_AST = this.checkLogicalNotOp(op2_AST, arg2_AST);
                    currentAST.root = complementExpr_AST;
                    currentAST.child = complementExpr_AST != null && complementExpr_AST.getFirstChild() != null ? complementExpr_AST.getFirstChild() : complementExpr_AST;
                    currentAST.advanceChildToEnd();
                }
                complementExpr_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = complementExpr_AST;
        this._retTree = _t;
    }

    public final void unaryMinusLiteralExpr(AST _t) throws RecognitionException {
        JQLAST unaryMinusLiteralExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST unaryMinusLiteralExpr_AST = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        JQLAST l = null;
        JQLAST l_AST = null;
        AST __t63 = _t;
        JQLAST tmp28_AST = null;
        JQLAST tmp28_AST_in = null;
        tmp28_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp28_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp28_AST);
        ASTPair __currentAST63 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 66);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 53: {
                i = (JQLAST)_t;
                Object i_AST_in = null;
                i_AST = (JQLAST)this.astFactory.create((AST)i);
                this.astFactory.addASTChild(currentAST, (AST)i_AST);
                this.match(_t, 53);
                _t = _t.getNextSibling();
                break;
            }
            case 95: {
                l = (JQLAST)_t;
                Object l_AST_in = null;
                l_AST = (JQLAST)this.astFactory.create((AST)l);
                this.astFactory.addASTChild(currentAST, (AST)l_AST);
                this.match(_t, 95);
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        currentAST = __currentAST63;
        _t = __t63;
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0) {
            unaryMinusLiteralExpr_AST = (JQLAST)currentAST.root;
            JQLAST li = i_AST != null ? i_AST : l_AST;
            li.setText("-" + li.getText());
            li.setValue(this.literalHelper((AST)li));
            li.setType(85);
            unaryMinusLiteralExpr_AST = li;
            currentAST.root = unaryMinusLiteralExpr_AST;
            currentAST.child = unaryMinusLiteralExpr_AST != null && unaryMinusLiteralExpr_AST.getFirstChild() != null ? unaryMinusLiteralExpr_AST.getFirstChild() : unaryMinusLiteralExpr_AST;
            currentAST.advanceChildToEnd();
        }
        unaryMinusLiteralExpr_AST = (JQLAST)currentAST.root;
        this.returnAST = unaryMinusLiteralExpr_AST;
        this._retTree = _t;
    }

    public final void castExpr(AST _t) throws RecognitionException {
        JQLAST castExpr_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST castExpr_AST = null;
        JQLAST c = null;
        JQLAST c_AST = null;
        JQLAST t_AST = null;
        JQLAST t = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        AST __t72 = _t;
        c = _t == ASTNULL ? null : (JQLAST)_t;
        Object c_AST_in = null;
        c_AST = (JQLAST)this.astFactory.create((AST)c);
        this.astFactory.addASTChild(currentAST, (AST)c_AST);
        ASTPair __currentAST72 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 68);
        _t = _t.getFirstChild();
        t = _t == ASTNULL ? null : (JQLAST)_t;
        this.type(_t);
        _t = this._retTree;
        t_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        e = _t == ASTNULL ? null : (JQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        e_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST72;
        _t = __t72;
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0) {
            castExpr_AST = (JQLAST)currentAST.root;
            castExpr_AST = this.checkCastOp(c_AST, t_AST, e_AST);
            currentAST.root = castExpr_AST;
            currentAST.child = castExpr_AST != null && castExpr_AST.getFirstChild() != null ? castExpr_AST.getFirstChild() : castExpr_AST;
            currentAST.advanceChildToEnd();
        }
        castExpr_AST = (JQLAST)currentAST.root;
        this.returnAST = castExpr_AST;
        this._retTree = _t;
    }

    public final void literal(AST _t) throws RecognitionException {
        JQLAST literal_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST literal_AST = null;
        JQLAST l_AST = null;
        JQLAST l = null;
        Object value = null;
        l = _t == ASTNULL ? null : (JQLAST)_t;
        value = this.literalHelper(_t);
        _t = this._retTree;
        l_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        if (this.inputState.guessing == 0) {
            l_AST.setType(85);
            l_AST.setValue(value);
        }
        literal_AST = (JQLAST)currentAST.root;
        this.returnAST = literal_AST;
        this._retTree = _t;
    }

    public final void parameter(AST _t) throws RecognitionException {
        JQLAST parameter_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST parameter_AST = null;
        JQLAST p = null;
        JQLAST p_AST = null;
        p = (JQLAST)_t;
        Object p_AST_in = null;
        p_AST = (JQLAST)this.astFactory.create((AST)p);
        this.astFactory.addASTChild(currentAST, (AST)p_AST);
        this.match(_t, 83);
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0 && this.paramtab.inline(p_AST.getText())) {
            p_AST.setType(85);
            p_AST.setValue(this.paramtab.getValueByName(p_AST.getText()));
        }
        parameter_AST = (JQLAST)currentAST.root;
        this.returnAST = parameter_AST;
        this._retTree = _t;
    }

    public final void staticFieldAccess(AST _t) throws RecognitionException {
        JQLAST staticFieldAccess_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST staticFieldAccess_AST = null;
        JQLAST s = null;
        JQLAST s_AST = null;
        JQLAST t = null;
        JQLAST t_AST = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        Object value = null;
        AST __t77 = _t;
        s = _t == ASTNULL ? null : (JQLAST)_t;
        Object s_AST_in = null;
        s_AST = (JQLAST)this.astFactory.create((AST)s);
        this.astFactory.addASTChild(currentAST, (AST)s_AST);
        ASTPair __currentAST77 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 75);
        _t = _t.getFirstChild();
        t = (JQLAST)_t;
        Object t_AST_in = null;
        t_AST = (JQLAST)this.astFactory.create((AST)t);
        this.astFactory.addASTChild(currentAST, (AST)t_AST);
        this.match(_t, 84);
        _t = _t.getNextSibling();
        i = (JQLAST)_t;
        Object i_AST_in = null;
        i_AST = (JQLAST)this.astFactory.create((AST)i);
        this.astFactory.addASTChild(currentAST, (AST)i_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST77;
        _t = __t77;
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0) {
            ClassType classType = (ClassType)t.getJQLType();
            FieldInfo fieldInfo = classType.getFieldInfo(i.getText());
            try {
                value = fieldInfo.getField().get(null);
                s_AST.setType(85);
                s_AST.setValue(value);
                s_AST.setFirstChild(null);
            }
            catch (IllegalAccessException e) {
                throw new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.staticfieldaccess.illegal", (String)i.getText(), (String)classType.getName()), e);
            }
        }
        staticFieldAccess_AST = (JQLAST)currentAST.root;
        this.returnAST = staticFieldAccess_AST;
        this._retTree = _t;
    }

    public final void fieldAccess(AST _t) throws RecognitionException {
        JQLAST fieldAccess_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST fieldAccess_AST = null;
        JQLAST f = null;
        JQLAST f_AST = null;
        JQLAST o_AST = null;
        JQLAST o = null;
        JQLAST name = null;
        JQLAST name_AST = null;
        AST __t79 = _t;
        f = _t == ASTNULL ? null : (JQLAST)_t;
        Object f_AST_in = null;
        f_AST = (JQLAST)this.astFactory.create((AST)f);
        this.astFactory.addASTChild(currentAST, (AST)f_AST);
        ASTPair __currentAST79 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 74);
        _t = _t.getFirstChild();
        o = _t == ASTNULL ? null : (JQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        o_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        name = (JQLAST)_t;
        Object name_AST_in = null;
        name_AST = (JQLAST)this.astFactory.create((AST)name);
        this.astFactory.addASTChild(currentAST, (AST)name_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST79;
        _t = __t79;
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0 && o_AST.getType() == 85) {
            Object object = o_AST.getValue();
            ClassType classType = (ClassType)o_AST.getJQLType();
            Object value = CodeGeneration.getFieldValue(classType, object, name_AST.getText());
            f_AST.setType(85);
            f_AST.setValue(value);
            f_AST.setFirstChild(null);
        }
        fieldAccess_AST = (JQLAST)currentAST.root;
        this.returnAST = fieldAccess_AST;
        this._retTree = _t;
    }

    public final void navigation(AST _t) throws RecognitionException {
        JQLAST navigation_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST navigation_AST = null;
        JQLAST n = null;
        JQLAST n_AST = null;
        JQLAST o_AST = null;
        JQLAST o = null;
        JQLAST name = null;
        JQLAST name_AST = null;
        AST __t81 = _t;
        n = _t == ASTNULL ? null : (JQLAST)_t;
        Object n_AST_in = null;
        n_AST = (JQLAST)this.astFactory.create((AST)n);
        this.astFactory.addASTChild(currentAST, (AST)n_AST);
        ASTPair __currentAST81 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 78);
        _t = _t.getFirstChild();
        o = _t == ASTNULL ? null : (JQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        o_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        name = (JQLAST)_t;
        Object name_AST_in = null;
        name_AST = (JQLAST)this.astFactory.create((AST)name);
        this.astFactory.addASTChild(currentAST, (AST)name_AST);
        this.match(_t, 56);
        _t = _t.getNextSibling();
        currentAST = __currentAST81;
        _t = __t81;
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0 && o_AST.getType() == 85) {
            Object object = o_AST.getValue();
            ClassType classType = (ClassType)o_AST.getJQLType();
            Object value = CodeGeneration.getFieldValue(classType, object, name_AST.getText());
            n_AST.setType(85);
            n_AST.setValue(value);
            n_AST.setFirstChild(null);
        }
        navigation_AST = (JQLAST)currentAST.root;
        this.returnAST = navigation_AST;
        this._retTree = _t;
    }

    public final void variableAccess(AST _t) throws RecognitionException {
        JQLAST variableAccess_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST variableAccess_AST = null;
        AST __t83 = _t;
        JQLAST tmp29_AST = null;
        JQLAST tmp29_AST_in = null;
        tmp29_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp29_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp29_AST);
        ASTPair __currentAST83 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 82);
        _t = _t.getFirstChild();
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 53: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: {
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        currentAST = __currentAST83;
        _t = __t83;
        _t = _t.getNextSibling();
        variableAccess_AST = (JQLAST)currentAST.root;
        this.returnAST = variableAccess_AST;
        this._retTree = _t;
    }

    public final void startsWith(AST _t) throws RecognitionException {
        JQLAST startsWith_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST startsWith_AST = null;
        AST __t86 = _t;
        JQLAST tmp30_AST = null;
        JQLAST tmp30_AST_in = null;
        tmp30_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp30_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp30_AST);
        ASTPair __currentAST86 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 79);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST86;
        _t = __t86;
        _t = _t.getNextSibling();
        startsWith_AST = (JQLAST)currentAST.root;
        this.returnAST = startsWith_AST;
        this._retTree = _t;
    }

    public final void endsWith(AST _t) throws RecognitionException {
        JQLAST endsWith_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST endsWith_AST = null;
        AST __t88 = _t;
        JQLAST tmp31_AST = null;
        JQLAST tmp31_AST_in = null;
        tmp31_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp31_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp31_AST);
        ASTPair __currentAST88 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 80);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST88;
        _t = __t88;
        _t = _t.getNextSibling();
        endsWith_AST = (JQLAST)currentAST.root;
        this.returnAST = endsWith_AST;
        this._retTree = _t;
    }

    public final void isEmpty(AST _t) throws RecognitionException {
        JQLAST isEmpty_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST isEmpty_AST = null;
        JQLAST op = null;
        JQLAST op_AST = null;
        JQLAST e_AST = null;
        JQLAST e = null;
        AST __t90 = _t;
        op = _t == ASTNULL ? null : (JQLAST)_t;
        Object op_AST_in = null;
        op_AST = (JQLAST)this.astFactory.create((AST)op);
        this.astFactory.addASTChild(currentAST, (AST)op_AST);
        ASTPair __currentAST90 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 81);
        _t = _t.getFirstChild();
        e = _t == ASTNULL ? null : (JQLAST)_t;
        this.expression(_t);
        _t = this._retTree;
        e_AST = (JQLAST)this.returnAST;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST90;
        _t = __t90;
        _t = _t.getNextSibling();
        if (this.inputState.guessing == 0 && e_AST.getType() == 85) {
            Object object = e_AST.getValue();
            Boolean value = null;
            if (object == null) {
                value = new Boolean(false);
            } else if (object instanceof Collection) {
                value = new Boolean(((Collection)object).isEmpty());
            } else {
                this.errorMsg.fatal(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.isempty.requirecollection"));
            }
            op_AST.setType(85);
            op_AST.setValue(value);
            op_AST.setFirstChild(null);
        }
        isEmpty_AST = (JQLAST)currentAST.root;
        this.returnAST = isEmpty_AST;
        this._retTree = _t;
    }

    public final void like(AST _t) throws RecognitionException {
        JQLAST like_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST like_AST = null;
        AST __t92 = _t;
        JQLAST tmp32_AST = null;
        JQLAST tmp32_AST_in = null;
        tmp32_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp32_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp32_AST);
        ASTPair __currentAST92 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 87);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 53: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: {
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        currentAST = __currentAST92;
        _t = __t92;
        _t = _t.getNextSibling();
        like_AST = (JQLAST)currentAST.root;
        this.returnAST = like_AST;
        this._retTree = _t;
    }

    public final void substring(AST _t) throws RecognitionException {
        JQLAST substring_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST substring_AST = null;
        AST __t95 = _t;
        JQLAST tmp33_AST = null;
        JQLAST tmp33_AST_in = null;
        tmp33_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp33_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp33_AST);
        ASTPair __currentAST95 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 88);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST95;
        _t = __t95;
        _t = _t.getNextSibling();
        substring_AST = (JQLAST)currentAST.root;
        this.returnAST = substring_AST;
        this._retTree = _t;
    }

    public final void indexOf(AST _t) throws RecognitionException {
        JQLAST indexOf_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST indexOf_AST = null;
        AST __t97 = _t;
        JQLAST tmp34_AST = null;
        JQLAST tmp34_AST_in = null;
        tmp34_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp34_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp34_AST);
        ASTPair __currentAST97 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 89);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 5: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 53: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: {
                this.expression(_t);
                _t = this._retTree;
                this.astFactory.addASTChild(currentAST, this.returnAST);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        currentAST = __currentAST97;
        _t = __t97;
        _t = _t.getNextSibling();
        indexOf_AST = (JQLAST)currentAST.root;
        this.returnAST = indexOf_AST;
        this._retTree = _t;
    }

    public final void length(AST _t) throws RecognitionException {
        JQLAST length_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST length_AST = null;
        AST __t100 = _t;
        JQLAST tmp35_AST = null;
        JQLAST tmp35_AST_in = null;
        tmp35_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp35_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp35_AST);
        ASTPair __currentAST100 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 90);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST100;
        _t = __t100;
        _t = _t.getNextSibling();
        length_AST = (JQLAST)currentAST.root;
        this.returnAST = length_AST;
        this._retTree = _t;
    }

    public final void abs(AST _t) throws RecognitionException {
        JQLAST abs_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST abs_AST = null;
        AST __t102 = _t;
        JQLAST tmp36_AST = null;
        JQLAST tmp36_AST_in = null;
        tmp36_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp36_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp36_AST);
        ASTPair __currentAST102 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 91);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST102;
        _t = __t102;
        _t = _t.getNextSibling();
        abs_AST = (JQLAST)currentAST.root;
        this.returnAST = abs_AST;
        this._retTree = _t;
    }

    public final void sqrt(AST _t) throws RecognitionException {
        JQLAST sqrt_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST sqrt_AST = null;
        AST __t104 = _t;
        JQLAST tmp37_AST = null;
        JQLAST tmp37_AST_in = null;
        tmp37_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
        tmp37_AST_in = (JQLAST)_t;
        this.astFactory.addASTChild(currentAST, (AST)tmp37_AST);
        ASTPair __currentAST104 = currentAST.copy();
        currentAST.root = currentAST.child;
        currentAST.child = null;
        this.match(_t, 92);
        _t = _t.getFirstChild();
        this.expression(_t);
        _t = this._retTree;
        this.astFactory.addASTChild(currentAST, this.returnAST);
        currentAST = __currentAST104;
        _t = __t104;
        _t = _t.getNextSibling();
        sqrt_AST = (JQLAST)currentAST.root;
        this.returnAST = sqrt_AST;
        this._retTree = _t;
    }

    public final Object literalHelper(AST _t) throws RecognitionException {
        JQLAST literalHelper_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST literalHelper_AST = null;
        JQLAST i = null;
        JQLAST i_AST = null;
        JQLAST l = null;
        JQLAST l_AST = null;
        JQLAST f = null;
        JQLAST f_AST = null;
        JQLAST d = null;
        JQLAST d_AST = null;
        JQLAST c = null;
        JQLAST c_AST = null;
        JQLAST s = null;
        JQLAST s_AST = null;
        JQLAST n = null;
        JQLAST n_AST = null;
        Object value = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 18: {
                JQLAST tmp38_AST = null;
                JQLAST tmp38_AST_in = null;
                tmp38_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp38_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp38_AST);
                this.match(_t, 18);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    value = new Boolean(true);
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 19: {
                JQLAST tmp39_AST = null;
                JQLAST tmp39_AST_in = null;
                tmp39_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp39_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp39_AST);
                this.match(_t, 19);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    value = new Boolean(false);
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 53: {
                i = (JQLAST)_t;
                Object i_AST_in = null;
                i_AST = (JQLAST)this.astFactory.create((AST)i);
                this.astFactory.addASTChild(currentAST, (AST)i_AST);
                this.match(_t, 53);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    try {
                        value = Integer.decode(i.getText());
                    }
                    catch (NumberFormatException ex) {
                        this.errorMsg.error(i.getLine(), i.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.literal.invalid", (String)i.getJQLType().getName(), (String)i.getText()));
                    }
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 95: {
                l = (JQLAST)_t;
                Object l_AST_in = null;
                l_AST = (JQLAST)this.astFactory.create((AST)l);
                this.astFactory.addASTChild(currentAST, (AST)l_AST);
                this.match(_t, 95);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    String txt = l.getText();
                    char last = txt.charAt(txt.length() - 1);
                    if (last == 'l' || last == 'L') {
                        txt = txt.substring(0, txt.length() - 1);
                    }
                    try {
                        value = Long.decode(txt);
                    }
                    catch (NumberFormatException ex) {
                        this.errorMsg.error(l.getLine(), l.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.literal.invalid", (String)l.getJQLType().getName(), (String)l.getText()));
                    }
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 96: {
                f = (JQLAST)_t;
                Object f_AST_in = null;
                f_AST = (JQLAST)this.astFactory.create((AST)f);
                this.astFactory.addASTChild(currentAST, (AST)f_AST);
                this.match(_t, 96);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    String txt = f.getText();
                    char last = txt.charAt(txt.length() - 1);
                    if (last == 'f' || last == 'F') {
                        txt = txt.substring(0, txt.length() - 1);
                    }
                    try {
                        value = new Float(txt);
                    }
                    catch (NumberFormatException ex) {
                        this.errorMsg.error(f.getLine(), f.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.literal.invalid", (String)f.getJQLType().getName(), (String)f.getText()));
                    }
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 97: {
                d = (JQLAST)_t;
                Object d_AST_in = null;
                d_AST = (JQLAST)this.astFactory.create((AST)d);
                this.astFactory.addASTChild(currentAST, (AST)d_AST);
                this.match(_t, 97);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    String txt = d.getText();
                    char last = txt.charAt(txt.length() - 1);
                    if (last == 'd' || last == 'd') {
                        txt = txt.substring(0, txt.length() - 1);
                    }
                    try {
                        value = new Double(txt);
                    }
                    catch (NumberFormatException ex) {
                        this.errorMsg.error(d.getLine(), d.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.optimizer.literal.invalid", (String)d.getJQLType().getName(), (String)d.getText()));
                    }
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 49: {
                c = (JQLAST)_t;
                Object c_AST_in = null;
                c_AST = (JQLAST)this.astFactory.create((AST)c);
                this.astFactory.addASTChild(currentAST, (AST)c_AST);
                this.match(_t, 49);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    value = new Character(Optimizer.parseChar(c.getText()));
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 50: {
                s = (JQLAST)_t;
                Object s_AST_in = null;
                s_AST = (JQLAST)this.astFactory.create((AST)s);
                this.astFactory.addASTChild(currentAST, (AST)s_AST);
                this.match(_t, 50);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    value = s.getText();
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            case 17: {
                n = (JQLAST)_t;
                Object n_AST_in = null;
                n_AST = (JQLAST)this.astFactory.create((AST)n);
                this.astFactory.addASTChild(currentAST, (AST)n_AST);
                this.match(_t, 17);
                _t = _t.getNextSibling();
                if (this.inputState.guessing == 0) {
                    value = null;
                }
                literalHelper_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = literalHelper_AST;
        this._retTree = _t;
        return value;
    }

    public final void primitiveType(AST _t) throws RecognitionException {
        JQLAST primitiveType_AST_in = _t == ASTNULL ? null : (JQLAST)_t;
        this.returnAST = null;
        ASTPair currentAST = new ASTPair();
        JQLAST primitiveType_AST = null;
        if (_t == null) {
            _t = ASTNULL;
        }
        switch (_t.getType()) {
            case 9: {
                JQLAST tmp40_AST = null;
                JQLAST tmp40_AST_in = null;
                tmp40_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp40_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp40_AST);
                this.match(_t, 9);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 10: {
                JQLAST tmp41_AST = null;
                JQLAST tmp41_AST_in = null;
                tmp41_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp41_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp41_AST);
                this.match(_t, 10);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 11: {
                JQLAST tmp42_AST = null;
                JQLAST tmp42_AST_in = null;
                tmp42_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp42_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp42_AST);
                this.match(_t, 11);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 12: {
                JQLAST tmp43_AST = null;
                JQLAST tmp43_AST_in = null;
                tmp43_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp43_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp43_AST);
                this.match(_t, 12);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 13: {
                JQLAST tmp44_AST = null;
                JQLAST tmp44_AST_in = null;
                tmp44_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp44_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp44_AST);
                this.match(_t, 13);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 14: {
                JQLAST tmp45_AST = null;
                JQLAST tmp45_AST_in = null;
                tmp45_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp45_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp45_AST);
                this.match(_t, 14);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 15: {
                JQLAST tmp46_AST = null;
                JQLAST tmp46_AST_in = null;
                tmp46_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp46_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp46_AST);
                this.match(_t, 15);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            case 16: {
                JQLAST tmp47_AST = null;
                JQLAST tmp47_AST_in = null;
                tmp47_AST = (JQLAST)this.astFactory.create((AST)((JQLAST)_t));
                tmp47_AST_in = (JQLAST)_t;
                this.astFactory.addASTChild(currentAST, (AST)tmp47_AST);
                this.match(_t, 16);
                _t = _t.getNextSibling();
                primitiveType_AST = (JQLAST)currentAST.root;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this.returnAST = primitiveType_AST;
        this._retTree = _t;
    }
}

