/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.falcon;

import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import java.util.HashMap;

class Resource {
    private String resId = null;
    private ConnectionUID owner = null;
    private long timestamp;
    private long xid;
    private int lockState;
    private int status;
    private HashMap recipients;

    public Resource(String string) {
        this.resId = string;
        this.timestamp = 0L;
        this.xid = 0L;
        this.recipients = new HashMap();
    }

    public String getResId() {
        return this.resId;
    }

    public ConnectionUID getOwner() {
        return this.owner;
    }

    public void setOwner(ConnectionUID connectionUID) {
        this.owner = connectionUID;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public long getXid() {
        return this.xid;
    }

    public int getLockState() {
        return this.lockState;
    }

    public void setLockState(int n) {
        this.lockState = n;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String showRecipients() {
        String string = "";
        for (BrokerAddress brokerAddress : this.recipients.keySet()) {
            string = string + "\n\t" + brokerAddress.toString();
        }
        return string;
    }

    public synchronized void prepareLockRequest(BrokerAddress[] brokerAddressArray, long l) {
        this.recipients.clear();
        for (int i = 0; i < brokerAddressArray.length; ++i) {
            this.recipients.put(brokerAddressArray[i], null);
        }
        this.xid = l;
        this.status = 0;
    }

    public synchronized int waitForStatusChange(long l) {
        long l2 = l * 1000L;
        long l3 = System.currentTimeMillis() + l2;
        while (this.status == 0 && this.recipients.size() > 0) {
            try {
                this.wait(l2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            if (l4 > l3) {
                return -1;
            }
            l2 = l3 - l4;
        }
        return this.status;
    }

    public synchronized void consumeResponse(long l, BrokerAddress brokerAddress, int n) {
        if (l != this.xid) {
            return;
        }
        if (this.status != 0) {
            return;
        }
        switch (n) {
            case 0: {
                this.recipients.remove(brokerAddress);
                break;
            }
            case 1: 
            case 2: {
                this.status = n;
            }
        }
        if (this.status != 0 || this.recipients.size() == 0) {
            this.notify();
        }
    }

    public synchronized void impliedFailure() {
        this.status = 1;
        this.notify();
    }

    public synchronized void brokerAdded(BrokerAddress brokerAddress) {
        this.status = 3;
        this.notify();
    }

    public synchronized void brokerRemoved(BrokerAddress brokerAddress) {
        if (this.status != 0) {
            return;
        }
        this.recipients.remove(brokerAddress);
        if (this.recipients.size() == 0) {
            this.notify();
        }
    }
}

