/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.PreparedTxnStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTransactionManager {
    public static final Logger logger = Globals.getLogger();
    PreparedTxnStore preparedTxnStore;
    TransactionLogManager transactionLogManager;
    Set<TransactionUID> playingToMessageStore = Collections.synchronizedSet(new HashSet());
    Map<TransactionUID, BaseTransaction> completeStored = new Hashtable<TransactionUID, BaseTransaction>();
    Map<TransactionUID, BaseTransaction> incompleteUnstored = new Hashtable<TransactionUID, BaseTransaction>();
    Map<TransactionUID, BaseTransaction> incompleteStored = new Hashtable<TransactionUID, BaseTransaction>();

    BaseTransactionManager(TransactionLogManager transactionLogManager) {
        this.transactionLogManager = transactionLogManager;
        this.preparedTxnStore = transactionLogManager.preparedTxnStore;
    }

    abstract String getPrefix();

    public List<BaseTransaction> getAllIncompleteTransactions() {
        ArrayList<BaseTransaction> arrayList = new ArrayList<BaseTransaction>();
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " getAllIncompleteTransactions  " + " num incompleteUnstored = " + this.incompleteUnstored.size() + " num incompleteStored = " + this.incompleteStored.size();
            logger.log(4, string);
        }
        arrayList.addAll(this.incompleteUnstored.values());
        arrayList.addAll(this.incompleteStored.values());
        return arrayList;
    }

    public HashMap getAllTransactionsMap() {
        List<BaseTransaction> list = this.getAllIncompleteTransactions();
        HashMap<TransactionUID, TransactionState> hashMap = new HashMap<TransactionUID, TransactionState>(list.size());
        for (BaseTransaction baseTransaction : list) {
            TransactionState transactionState = new TransactionState(baseTransaction.getTransactionState());
            hashMap.put(baseTransaction.getTid(), transactionState);
        }
        return hashMap;
    }

    public void addToCompleteStored(BaseTransaction baseTransaction) {
        this.completeStored.put(baseTransaction.getTid(), baseTransaction);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " adding  " + baseTransaction.getTid() + "  to completeStored. Total = " + this.completeStored.size();
            logger.log(4, string);
        }
    }

    public void removeFromCompleteStored(TransactionUID transactionUID) {
        this.completeStored.remove(transactionUID);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " removing " + transactionUID + " from completeStored. Total = " + this.completeStored.size();
            logger.log(4, string);
        }
    }

    void addToIncompleteStored(BaseTransaction baseTransaction) {
        this.incompleteStored.put(baseTransaction.getTid(), baseTransaction);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " adding  " + baseTransaction.getTid() + "  to incompleteStored. Total = " + this.incompleteStored.size();
            logger.log(4, string);
        }
    }

    BaseTransaction removeFromIncompleteStored(TransactionUID transactionUID) {
        BaseTransaction baseTransaction = this.incompleteStored.remove(transactionUID);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " removing  " + transactionUID + " from incompleteStored. Total = " + this.incompleteStored.size();
            logger.log(4, string);
        }
        return baseTransaction;
    }

    void addToIncompleteUnstored(BaseTransaction baseTransaction) {
        this.incompleteUnstored.put(baseTransaction.getTid(), baseTransaction);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " adding  " + baseTransaction.getTid() + "  to incompleteUnstored. Total = " + this.incompleteUnstored.size();
            logger.log(4, string);
        }
    }

    BaseTransaction removeFromIncompleteUnstored(TransactionUID transactionUID) {
        BaseTransaction baseTransaction = this.incompleteUnstored.remove(transactionUID);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " removing  " + transactionUID + " from incompleteUnstored. Total = " + this.incompleteUnstored.size();
            logger.log(4, string);
        }
        return baseTransaction;
    }

    abstract void processStoredTxnOnStartup(BaseTransaction var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPlayingToMessageStoreCompletion() {
        Set<TransactionUID> set = this.playingToMessageStore;
        synchronized (set) {
            String string;
            if (Store.getDEBUG()) {
                string = this.getPrefix() + " num playingToMessageStore =" + this.playingToMessageStore.size();
                logger.log(4, string);
            }
            try {
                while (this.playingToMessageStore.size() > 0) {
                    if (Store.getDEBUG()) {
                        string = this.getPrefix() + " waiting for " + this.playingToMessageStore.size() + " playingToMessageStore";
                        logger.log(4, string);
                    }
                    this.playingToMessageStore.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playingToMessageStoreComplete(TransactionUID transactionUID) {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " playingToMessageStoreComplete " + transactionUID;
            logger.log(4, (String)object);
        }
        object = this.playingToMessageStore;
        synchronized (object) {
            Boolean bl = this.playingToMessageStore.remove(transactionUID);
            if (bl == null) {
                String string = this.getPrefix() + " playingToMessageStoreComplete(): could not find " + transactionUID;
                logger.log(16, string);
            }
            this.playingToMessageStore.notify();
        }
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " remove transaction from  playingToMessageStore." + " tid=" + transactionUID + " size = " + this.playingToMessageStore.size();
            logger.log(4, (String)object);
        }
    }

    void writePreparedTransactionsToPreparedTxnStoreOnCheckpoint() throws BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " writePreparedTransactionsToPreparedTxnStoreOnCheckpoint" + " num incompleteUnstored=" + this.incompleteUnstored.size();
            logger.log(4, string);
        }
        for (BaseTransaction baseTransaction : this.incompleteUnstored.values()) {
            String string;
            if (!this.preparedTxnStore.containsTransaction(baseTransaction.getTid())) {
                if (Store.getDEBUG()) {
                    string = this.getPrefix() + " transaction storing preparedTransaction " + baseTransaction;
                    logger.log(4, string);
                }
                try {
                    this.preparedTxnStore.storeTransaction(baseTransaction, true);
                    this.addToIncompleteStored(baseTransaction);
                    continue;
                }
                catch (IOException iOException) {
                    throw new BrokerException("failed to store transaction in preparedTxnStore " + baseTransaction, iOException);
                }
            }
            string = this.getPrefix() + " transaction already exists in preparedTxnStore " + baseTransaction;
            logger.log(8, string);
        }
        this.incompleteUnstored.clear();
    }

    void removeCompleteTransactionsAfterCheckpoint() throws BrokerException {
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " removeCompleteTransactionsAfterCheckpoint" + "num completeStored=" + this.completeStored.size();
            logger.log(4, string);
        }
        for (TransactionUID transactionUID : this.completeStored.keySet()) {
            String string;
            if (this.preparedTxnStore.containsTransaction(transactionUID)) {
                this.preparedTxnStore.removeTransaction(transactionUID, true);
                if (!Store.getDEBUG()) continue;
                string = this.getPrefix() + " removed transaction " + transactionUID;
                logger.log(4, string);
                continue;
            }
            if (!Store.getDEBUG()) continue;
            string = this.getPrefix() + " Could not find transaction in preparedTxnStore " + transactionUID;
            logger.log(4, string);
        }
        this.completeStored.clear();
    }

    void rollbackAllTransactions() {
        Object object;
        if (Store.getDEBUG()) {
            object = this.getPrefix() + " rollbackAllTransactions" + " num incompleteStored=" + this.incompleteStored.size() + " num incompleteUnstored=" + this.incompleteUnstored.size();
            logger.log(4, (String)object);
        }
        object = this.incompleteStored.values();
        ArrayList<BaseTransaction> arrayList = new ArrayList<BaseTransaction>((Collection<BaseTransaction>)object);
        this.rollbackTransactions(arrayList);
        Collection<BaseTransaction> collection = this.incompleteUnstored.values();
        ArrayList<BaseTransaction> arrayList2 = new ArrayList<BaseTransaction>(collection);
        this.rollbackTransactions(arrayList2);
    }

    void rollbackTransactions(Collection<BaseTransaction> collection) {
        for (BaseTransaction baseTransaction : collection) {
            try {
                this.processTxnCompletion(baseTransaction.getTid(), 7, true);
            }
            catch (IOException iOException) {
                logger.log(32, "could not rollback " + baseTransaction, (Throwable)iOException);
            }
            catch (BrokerException brokerException) {
                logger.log(32, "could not rollback " + baseTransaction, (Throwable)brokerException);
            }
        }
    }

    abstract void processTxn(BaseTransaction var1) throws IOException, BrokerException;

    abstract TransactionEvent generateEvent(BaseTransaction var1, boolean var2) throws IOException, BrokerException;

    abstract BaseTransaction processTxnCompletion(TransactionUID var1, int var2) throws IOException, BrokerException;

    BaseTransaction processTxnCompletion(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        Object object;
        if (n == 6) {
            this.playingToMessageStore.add(transactionUID);
            if (Store.getDEBUG()) {
                object = this.getPrefix() + " add transaction to  playingToMessageStore." + " tid=" + transactionUID + " size = " + this.playingToMessageStore.size();
                logger.log(4, (String)object);
            }
        }
        object = null;
        boolean bl2 = false;
        object = this.incompleteUnstored.get(transactionUID);
        if (object == null) {
            object = this.incompleteStored.get(transactionUID);
            if (object != null) {
                bl2 = true;
            } else {
                String string = this.getPrefix() + " processTxnCompletion: Could not find txn for " + transactionUID;
                logger.log(16, string);
                throw new BrokerException(string);
            }
        }
        ((BaseTransaction)object).getTransactionDetails().setState(n);
        if (bl2) {
            this.updateStoredState(transactionUID, n);
            if (bl) {
                this.incompleteStored.remove(transactionUID);
                this.completeStored.put(transactionUID, (BaseTransaction)object);
            }
        } else if (bl) {
            this.removeFromIncompleteUnstored(transactionUID);
        }
        this.messageListLogged((BaseTransaction)object);
        return object;
    }

    protected void messageListLogged(BaseTransaction baseTransaction) {
        List<TransactionWorkMessage> list;
        TransactionWork transactionWork = baseTransaction.getTransactionWork();
        if (transactionWork != null && (list = transactionWork.getSentMessages()) != null) {
            this.transactionLogManager.loggedMessageHelper.messageListLogged(list);
        }
    }

    void updateStoredState(TransactionUID transactionUID, int n) throws IOException, BrokerException {
        this.preparedTxnStore.updateTransactionState(transactionUID, n, true);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " updated transaction state of stored prepared transaction to " + TransactionState.toString(n);
            logger.log(4, string);
        }
    }

    void updateStoredCompletion(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        this.preparedTxnStore.updateTransactionCompletion(transactionUID, bl, true);
        if (Store.getDEBUG()) {
            String string = this.getPrefix() + " updated completion status of stored transaction to " + bl;
            logger.log(4, string);
        }
    }

    abstract void replayTransactionEvent(TransactionEvent var1, HashSet var2) throws BrokerException, IOException;
}

