/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.server.Adapter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAXWSAdapterRegistry {
    private static JAXWSAdapterRegistry registry = null;
    private Map store;
    final Logger logger = LogDomains.getLogger(JAXWSAdapterRegistry.class, (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();

    private JAXWSAdapterRegistry() {
        this.store = new HashMap();
    }

    public static synchronized JAXWSAdapterRegistry getInstance() {
        if (registry == null) {
            registry = new JAXWSAdapterRegistry();
        }
        return registry;
    }

    public void addAdapter(String contextRoot, String urlPattern, Adapter info) {
        ContextAdapter contextRtInfo;
        if (contextRoot == null) {
            contextRoot = "";
        }
        if ((contextRtInfo = (ContextAdapter)this.store.get(contextRoot)) == null) {
            contextRtInfo = new ContextAdapter(contextRoot);
        }
        contextRtInfo.addAdapter(urlPattern, info);
        this.store.put(contextRoot, contextRtInfo);
    }

    public Adapter getAdapter(String contextRoot, String path, String urlPattern) {
        ContextAdapter serviceInfo = (ContextAdapter)this.store.get(contextRoot);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getAdapter(path, urlPattern);
    }

    public void removeAdapter(String contextRoot) {
        ContextAdapter serviceInfo;
        if (contextRoot == null) {
            contextRoot = "";
        }
        if ((serviceInfo = (ContextAdapter)this.store.get(contextRoot)) == null) {
            return;
        }
        this.store.remove(contextRoot);
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(key, values);
    }

    class ContextAdapter {
        String contextRoot;
        Map fixedUrlPatternEndpoints;
        List<Adapter> pathUrlPatternEndpoints;

        ContextAdapter(String contextRoot) {
            this.contextRoot = contextRoot;
            this.fixedUrlPatternEndpoints = new HashMap();
            this.pathUrlPatternEndpoints = new ArrayList<Adapter>();
        }

        void addAdapter(String urlPattern, Adapter info) {
            if (urlPattern.indexOf("*.") != -1) {
                JAXWSAdapterRegistry.this.logger.log(Level.SEVERE, JAXWSAdapterRegistry.this.rb.getString("enterprise.webservice.implicitMappingNotSupported"));
            } else if (urlPattern.endsWith("/*")) {
                this.pathUrlPatternEndpoints.add(info);
            } else {
                if (this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
                    JAXWSAdapterRegistry.this.logger.log(Level.SEVERE, JAXWSAdapterRegistry.this.format(JAXWSAdapterRegistry.this.rb.getString("enterprise.webservice.duplicateService"), new String[]{urlPattern}));
                }
                this.fixedUrlPatternEndpoints.put(urlPattern, info);
            }
        }

        Adapter getAdapter(String path, String urlPattern) {
            Adapter result = (Adapter)this.fixedUrlPatternEndpoints.get(path);
            if (result == null) {
                for (Adapter candidate : this.pathUrlPatternEndpoints) {
                    if (!path.startsWith(this.getValidPathForEndpoint(urlPattern))) continue;
                    result = candidate;
                    break;
                }
            }
            return result;
        }

        private String getValidPathForEndpoint(String s) {
            if (s.endsWith("/*")) {
                return s.substring(0, s.length() - 2);
            }
            return s;
        }
    }
}

