/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultThreadPool
extends FixedThreadPool
implements Thread.UncaughtExceptionHandler {
    private final AtomicInteger queueSize = new AtomicInteger();
    protected final AtomicInteger workerThreadCounter = new AtomicInteger();

    public DefaultThreadPool() {
        this("Grizzly", DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public DefaultThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, null);
    }

    public DefaultThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(name, corePoolsize, maxPoolSize, keepAliveTime, timeUnit, threadFactory, new LinkedTransferQueue<Runnable>());
    }

    public DefaultThreadPool(String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, BlockingQueue<Runnable> workQueue) {
        super(workQueue, threadFactory);
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeUnit == null");
        }
        this.setPoolSizes(corePoolsize, maxPoolSize);
        this.keepAliveTime = TimeUnit.MILLISECONDS.convert(keepAliveTime, timeUnit);
        this.name = name;
        if (this.threadFactory == null) {
            this.threadFactory = new DefaultWorkerThreadFactory();
        }
    }

    @Override
    public void execute(Runnable task) {
        int aliveWorkers;
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        while ((aliveWorkers = this.aliveworkerCount.get()) < this.maxPoolSize && (aliveWorkers < this.corePoolSize || this.queueSize.get() > 0 || !this.hasIdleWorkersApproximately()) && this.running) {
            if (!this.aliveworkerCount.compareAndSet(aliveWorkers, aliveWorkers + 1)) continue;
            this.startWorker(new DefaultThreadWorker(task, false));
            return;
        }
        if (this.running) {
            if (this.workQueue.offer(task)) {
                if (aliveWorkers >= this.maxPoolSize) {
                    this.onMaxNumberOfThreadsReached();
                }
                this.onTaskQueued(task);
            } else {
                this.onTaskQueueOverflow();
                throw new RejectedExecutionException("The queue is full");
            }
        }
    }

    private boolean hasIdleWorkersApproximately() {
        return this.aliveworkerCount.get() > this.approximateRunningWorkerCount.get();
    }

    public void start() {
        int aliveCount;
        while ((aliveCount = this.aliveworkerCount.get()) < this.corePoolSize) {
            if (!this.aliveworkerCount.compareAndSet(aliveCount, aliveCount + 1)) continue;
            this.startWorker(new DefaultThreadWorker(null, true));
        }
    }

    public void stop() {
        this.shutdownNow();
    }

    @Override
    protected void onTaskQueued(Runnable task) {
        super.onTaskQueued(task);
        this.queueSize.incrementAndGet();
    }

    @Override
    protected void onTaskDequeued(Runnable task) {
        this.queueSize.decrementAndGet();
        super.onTaskDequeued(task);
    }

    @Override
    public int getQueueSize() {
        return this.queueSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPoolSizes(int corePoolSize, int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolSize(corePoolSize, maxPoolSize);
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolSize(corePoolSize, this.maxPoolSize);
            this.corePoolSize = corePoolSize;
        }
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolSize(this.corePoolSize, maxPoolSize);
            this.maxPoolSize = maxPoolSize;
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    protected String nextThreadId() {
        return Integer.toString(this.workerThreadCounter.getAndIncrement());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("DefaultThreadPool[");
        this.injectToStringAttributes(builder);
        builder.append(']');
        return builder.toString();
    }

    protected void injectToStringAttributes(StringBuilder sb) {
        sb.append("name=").append(this.name);
        sb.append(", min-threads=").append(this.getCorePoolSize());
        sb.append(", max-threads=").append(this.getMaximumPoolSize());
        sb.append(", max-queue-size=").append(this.getMaxQueuedTasksCount());
        sb.append(", is-shutdown=").append(this.isShutdown());
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ((WorkerThreadImpl)t).createByteBuffer(false);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        ((WorkerThreadImpl)Thread.currentThread()).reset();
        super.afterExecute(r, t);
    }

    protected class DefaultThreadWorker
    extends FixedThreadPool.BasicWorker {
        private final boolean core;
        private Runnable firstTask;

        public DefaultThreadWorker(Runnable firstTask, boolean core) {
            super(DefaultThreadPool.this);
            this.core = core;
            this.firstTask = firstTask;
        }

        protected Runnable getTask() throws InterruptedException {
            Runnable r;
            if (this.firstTask != null) {
                r = this.firstTask;
                this.firstTask = null;
            } else {
                if (!this.core && DefaultThreadPool.this.aliveworkerCount.get() > DefaultThreadPool.this.maxPoolSize) {
                    return null;
                }
                r = this.core ? (Runnable)DefaultThreadPool.this.workQueue.take() : (Runnable)DefaultThreadPool.this.workQueue.poll(DefaultThreadPool.this.keepAliveTime, TimeUnit.MILLISECONDS);
            }
            return r;
        }
    }

    private class DefaultWorkerThreadFactory
    implements ThreadFactory {
        private DefaultWorkerThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            WorkerThreadImpl thread = new WorkerThreadImpl(DefaultThreadPool.this, DefaultThreadPool.this.name + "-WorkerThread(" + DefaultThreadPool.this.nextThreadId() + ")", r, DefaultThreadPool.this.initialByteBufferSize);
            thread.setUncaughtExceptionHandler(DefaultThreadPool.this);
            thread.setPriority(DefaultThreadPool.this.priority);
            return thread;
        }
    }
}

